/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.internal.core;

import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.api.core.RunMap;
import com.adobe.qe.toughday.api.core.SkippedTestException;
import com.adobe.qe.toughday.api.core.benchmark.TestResult;
import com.adobe.qe.toughday.internal.core.benckmark.AdHocTest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.HdrHistogram.SynchronizedHistogram;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public class RunMapImpl
implements RunMap {
    private long startNanoTime;
    private long startMillisTime;
    private Map<AbstractTest, TestEntry> runMap;
    private ReadWriteLock runMapLock = new ReentrantReadWriteLock();
    private List<AbstractTest> orderedTests;
    private ReadWriteLock testResultsLock = new ReentrantReadWriteLock();
    private ConcurrentLinkedQueue<TestResult> currentTestResults = new ConcurrentLinkedQueue();

    public RunMapImpl() {
        this.runMap = new HashMap<AbstractTest, TestEntry>();
        this.orderedTests = Collections.synchronizedList(new ArrayList());
    }

    private RunMapImpl(List<AbstractTest> orderedTests) {
        this();
        this.orderedTests.addAll(orderedTests);
        for (AbstractTest test : orderedTests) {
            this.runMap.put(test, new TestEntry(test));
        }
    }

    public void addTest(AbstractTest test) {
        this.runMapLock.writeLock().lock();
        try {
            if (this.runMap.containsKey(test)) {
                return;
            }
            TestEntry entry = new TestEntry(test);
            this.runMap.put(test, entry);
            if (test instanceof AdHocTest) {
                this.insertPartiallyOrderedAdHocTest(test);
            } else {
                this.orderedTests.add(test);
            }
        }
        finally {
            this.runMapLock.writeLock().unlock();
        }
    }

    @Override
    public RunMap.TestStatistics getRecord(AbstractTest test) {
        this.runMapLock.readLock().lock();
        try {
            RunMap.TestStatistics testStatistics = this.runMap.get(test);
            return testStatistics;
        }
        finally {
            this.runMapLock.readLock().unlock();
        }
    }

    public Collection<TestResult> getCurrentTestResults() {
        return this.currentTestResults;
    }

    public Collection<AbstractTest> getTests() {
        return this.orderedTests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(TestResult testResult) {
        this.testResultsLock.readLock().lock();
        this.currentTestResults.add(testResult);
        this.testResultsLock.readLock().unlock();
        this.runMapLock.readLock().lock();
        try {
            if (testResult.isShowInAggregatedView()) {
                AbstractTest test = testResult.getTest();
                TestEntry entry = this.runMap.get(test);
                if (entry == null) {
                    this.runMapLock.readLock().unlock();
                    this.addTest(test);
                    this.runMapLock.readLock().lock();
                    entry = this.runMap.get(test);
                }
                entry.record(testResult);
            }
        }
        finally {
            this.runMapLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<AbstractTest, Long> aggregateAndReinitialize(RunMap otherRunmap) {
        RunMapImpl other = (RunMapImpl)otherRunmap;
        other.testResultsLock.writeLock().lock();
        try {
            this.testResultsLock.writeLock().lock();
            try {
                TestResult testResult = other.currentTestResults.poll();
                while (testResult != null) {
                    this.currentTestResults.add(testResult);
                    testResult = other.currentTestResults.poll();
                }
            }
            finally {
                this.testResultsLock.writeLock().unlock();
            }
        }
        finally {
            other.testResultsLock.writeLock().unlock();
        }
        this.runMapLock.writeLock().lock();
        try {
            other.runMapLock.writeLock().lock();
            try {
                HashMap<AbstractTest, Long> counts = new HashMap<AbstractTest, Long>();
                Object object = this.orderedTests;
                synchronized (object) {
                    for (AbstractTest test : other.orderedTests) {
                        TestEntry otherEntry = other.runMap.get(test);
                        TestEntry thisEntry = this.runMap.get(test);
                        if (thisEntry == null) {
                            this.addTest(test.clone());
                            thisEntry = this.runMap.get(test);
                        }
                        long count = thisEntry.aggregateAndReinitialize(otherEntry);
                        counts.put(test, count);
                    }
                }
                object = counts;
                other.runMapLock.writeLock().unlock();
                return object;
            }
            catch (Throwable throwable) {
                other.runMapLock.writeLock().unlock();
                throw throwable;
            }
        }
        finally {
            this.runMapLock.writeLock().unlock();
        }
    }

    public void reinitialize() {
        this.runMapLock.writeLock().lock();
        try {
            for (TestEntry testEntry : this.runMap.values()) {
                testEntry.init();
                testEntry.reinitTime();
            }
        }
        finally {
            this.runMapLock.writeLock().unlock();
        }
    }

    public void reinitStartTimes() {
        this.runMapLock.writeLock().lock();
        try {
            this.startNanoTime = System.nanoTime();
            this.startMillisTime = System.currentTimeMillis();
            for (TestEntry entry : this.runMap.values()) {
                entry.reinitTime();
            }
        }
        finally {
            this.runMapLock.writeLock().unlock();
        }
    }

    public void clearCurrentTestResults() {
        try {
            this.runMapLock.writeLock().lock();
            this.currentTestResults.clear();
        }
        finally {
            this.runMapLock.writeLock().unlock();
        }
    }

    public RunMap newInstance() {
        try {
            this.runMapLock.readLock().lock();
            RunMapImpl runMapImpl = new RunMapImpl(this.orderedTests);
            return runMapImpl;
        }
        finally {
            this.runMapLock.readLock().unlock();
        }
    }

    private void insertPartiallyOrderedAdHocTest(AbstractTest test) {
        if (test.getParent() == null) {
            this.orderedTests.add(test);
            return;
        }
        int ancestorLevel = -1;
        int index = -1;
        int i = 0;
        for (AbstractTest other : this.orderedTests) {
            ++i;
            Triple<AbstractTest, Integer, Integer> commonAncestorAndLevel = this.lowestCommonAncestor(test, other);
            if (commonAncestorAndLevel.getLeft() == null || commonAncestorAndLevel.getMiddle() <= ancestorLevel && (commonAncestorAndLevel.getRight() < 0 || commonAncestorAndLevel.getMiddle() != ancestorLevel)) continue;
            index = i + (commonAncestorAndLevel.getRight() < 0 ? -1 : 0);
            ancestorLevel = commonAncestorAndLevel.getMiddle();
        }
        if (index != -1 && index < this.orderedTests.size()) {
            this.orderedTests.add(index, test);
        } else {
            this.orderedTests.add(test);
        }
    }

    private Triple<AbstractTest, Integer, Integer> lowestCommonAncestor(AbstractTest test1, AbstractTest test2) {
        LinkedList<AbstractTest> test1Ancestors = new LinkedList<AbstractTest>();
        LinkedList<AbstractTest> test2Ancestors = new LinkedList<AbstractTest>();
        for (AbstractTest p = test1; p != null; p = p.getParent()) {
            test1Ancestors.addFirst(p);
        }
        int test1AncestorsSize = test1Ancestors.size();
        if (test1AncestorsSize == 0) {
            return new ImmutableTriple<Object, Integer, Integer>(null, -1, 0);
        }
        for (AbstractTest p = test2; p != null; p = p.getParent()) {
            test2Ancestors.addFirst(p);
        }
        int test2AncestorsSize = test2Ancestors.size();
        if (test2AncestorsSize == 0) {
            return new ImmutableTriple<Object, Integer, Integer>(null, -1, 0);
        }
        if (!((AbstractTest)test1Ancestors.peekFirst()).equals(test2Ancestors.peekFirst())) {
            return new ImmutableTriple<Object, Integer, Integer>(null, -1, 0);
        }
        int level = 0;
        AbstractTest lowestCommonAncestor = null;
        while (test1Ancestors.peekFirst() != null && test2Ancestors.peekFirst() != null && ((AbstractTest)test1Ancestors.peekFirst()).equals(test2Ancestors.peekFirst())) {
            ++level;
            lowestCommonAncestor = (AbstractTest)test1Ancestors.removeFirst();
            test2Ancestors.removeFirst();
        }
        return new ImmutableTriple<Object, Integer, Integer>(lowestCommonAncestor, level, level == test1AncestorsSize ? -1 : 1);
    }

    public class TestEntry
    implements RunMap.TestStatistics {
        public static final double ONE_BILLION_D = 1.0E9;
        private static final long ONE_MILION = 1000000L;
        private AbstractTest test;
        private double totalDuration;
        private long failRuns;
        private long skippedRuns;
        private Map<Class<? extends Throwable>, Long> failsMap;
        private long lastNanoTime;
        private SynchronizedHistogram histogram;

        private void init() {
            this.totalDuration = 0.0;
            this.failRuns = 0L;
            this.skippedRuns = 0L;
            this.histogram.reset();
            this.failsMap = new HashMap<Class<? extends Throwable>, Long>();
        }

        public TestEntry(AbstractTest test) {
            this.test = test;
            this.histogram = new SynchronizedHistogram(3600000L, 3);
            this.reinitTime();
            this.init();
        }

        public synchronized void record(TestResult testResult) {
            switch (testResult.getStatus()) {
                case PASSED: {
                    this.recordRun(testResult.getDuration());
                    break;
                }
                case SKIPPED: {
                    this.recordSkipped(testResult.getSkippedCause());
                    break;
                }
                case FAILED: {
                    this.recordFail(testResult.getFailCause());
                }
            }
        }

        public synchronized void recordSkipped(SkippedTestException e) {
            this.lastNanoTime = System.nanoTime();
            ++this.skippedRuns;
        }

        public synchronized void recordFail(Throwable e) {
            this.lastNanoTime = System.nanoTime();
            if (!this.failsMap.containsKey(e.getClass())) {
                this.failsMap.put(e.getClass(), 0L);
            }
            this.failsMap.put(e.getClass(), this.failsMap.get(e.getClass()) + 1L);
            ++this.failRuns;
        }

        public synchronized void recordRun(double duration) {
            long endTimestamp = System.currentTimeMillis();
            this.histogram.recordValue((long)duration);
            this.lastNanoTime = System.nanoTime();
            this.totalDuration += duration;
        }

        public synchronized void reinitTime() {
            this.lastNanoTime = System.nanoTime();
        }

        @Override
        public AbstractTest getTest() {
            return this.test;
        }

        @Override
        public String getTimestamp() {
            return RunMap.TIME_STAMP_FORMAT.format(new Date(RunMapImpl.this.startMillisTime + (this.lastNanoTime - RunMapImpl.this.startNanoTime) / 1000000L));
        }

        @Override
        public double getTotalDuration() {
            return this.totalDuration;
        }

        @Override
        public long getTotalRuns() {
            return this.histogram.getTotalCount();
        }

        @Override
        public double getRealThroughput() {
            return (double)this.histogram.getTotalCount() * 1.0E9 / (double)(this.lastNanoTime - RunMapImpl.this.startNanoTime);
        }

        @Override
        public long getMinDuration() {
            return this.histogram.getMinValue();
        }

        @Override
        public long getMaxDuration() {
            return this.histogram.getMaxValue();
        }

        @Override
        public double getAverageDuration() {
            return this.histogram.getMean();
        }

        @Override
        public long getFailRuns() {
            return this.failRuns;
        }

        @Override
        public long getSkippedRuns() {
            return this.skippedRuns;
        }

        @Override
        public long getValueAtPercentile(double percentile) {
            return this.histogram.getValueAtPercentile(percentile);
        }

        @Override
        public double getStandardDeviation() {
            return this.histogram.getStdDeviation();
        }

        @Override
        public long getMedianDuration() {
            return this.histogram.getValueAtPercentile(50.0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized long aggregateAndReinitialize(TestEntry other) {
            long totalRuns = 0L;
            TestEntry testEntry = other;
            synchronized (testEntry) {
                totalRuns = other.histogram.getTotalCount();
                this.histogram.add(other.histogram);
                this.lastNanoTime = Math.max(this.lastNanoTime, other.lastNanoTime);
                this.totalDuration += other.totalDuration;
                this.failRuns += other.failRuns;
                this.skippedRuns += other.skippedRuns;
                other.init();
            }
            return totalRuns;
        }
    }
}

