/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.internal.core;

import com.adobe.qe.toughday.api.annotations.ConfigArgSet;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.internal.core.ReflectionsContainer;
import com.adobe.qe.toughday.internal.core.SuiteSetup;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TestSuite {
    private List<SuiteSetup> setupStep;
    private WeightMap weightMap;
    private HashMap<AbstractTest, Long> timeoutMap;
    private HashMap<AbstractTest, Long> counterMap;
    private String description = "";
    private List<String> tags = new ArrayList<String>();
    private List<AbstractTest> orderedTests;

    public TestSuite() {
        this.weightMap = new WeightMap();
        this.timeoutMap = new HashMap();
        this.counterMap = new HashMap();
        this.setupStep = new ArrayList<SuiteSetup>();
        this.orderedTests = new ArrayList<AbstractTest>();
    }

    public TestSuite add(AbstractTest test, int weight) {
        this.weightMap.put(test, weight);
        this.orderedTests.add(test);
        return this;
    }

    public TestSuite add(AbstractTest test, int weight, long timeout, long count) {
        this.add(test, weight);
        if (timeout >= 0L) {
            this.timeoutMap.put(test, timeout * 1000L);
        }
        if (count >= 0L) {
            this.counterMap.put(test, count);
        }
        return this;
    }

    public TestSuite replaceWeight(String testName, int weight) {
        AbstractTest test = this.weightMap.getTest(testName);
        this.weightMap.put(test, weight);
        return this;
    }

    public TestSuite replaceTimeout(String testName, long timeout) {
        AbstractTest test = this.weightMap.getTest(testName);
        this.timeoutMap.put(test, timeout);
        return this;
    }

    public TestSuite replaceCount(String testName, long count) {
        AbstractTest test = this.weightMap.getTest(testName);
        this.counterMap.put(test, count);
        return this;
    }

    public TestSuite replaceName(AbstractTest abstractTest, String newTestName) {
        int weight = this.weightMap.remove(abstractTest);
        abstractTest.setName(newTestName);
        this.weightMap.put(abstractTest, weight);
        return this;
    }

    public TestSuite addAll(TestSuite testSuite) {
        this.weightMap.putAll((Map<? extends AbstractTest, ? extends Integer>)testSuite.getWeightMap());
        this.timeoutMap.putAll(testSuite.timeoutMap);
        this.counterMap.putAll(testSuite.counterMap);
        this.setupStep.addAll(testSuite.setupStep);
        this.orderedTests.addAll(testSuite.orderedTests);
        return this;
    }

    @ConfigArgSet(required=false)
    public TestSuite setSuiteSetup(String setupStepClassNames) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        String[] suiteSetups;
        for (String setupStepClassName : suiteSetups = setupStepClassNames.split(",")) {
            Class<? extends SuiteSetup> setupStepClass = null;
            setupStepClass = ReflectionsContainer.getInstance().getSuiteSetupClasses().get(setupStepClassName);
            if (setupStepClass == null) {
                throw new ClassNotFoundException("Could not find class " + setupStepClassName + " for suite setup step");
            }
            this.withSetupStep(setupStepClass);
        }
        return this;
    }

    public TestSuite withSetupStep(Class<? extends SuiteSetup> setupStepClass) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor<? extends SuiteSetup> constructor = setupStepClass.getConstructor(null);
        this.withSetupStep(constructor.newInstance(new Object[0]));
        return this;
    }

    public TestSuite withSetupStep(SuiteSetup setupStep) {
        this.setupStep.add(setupStep);
        return this;
    }

    public TestSuite setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public TestSuite addTag(String tag) {
        this.tags.add(tag);
        return this;
    }

    public TestSuite addTags(Collection<String> tags) {
        this.tags.addAll(tags);
        return this;
    }

    public TestSuite addTags(String[] tags) {
        this.tags.addAll(Arrays.asList(tags));
        return this;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public List<SuiteSetup> getSetupStep() {
        return this.setupStep;
    }

    public Long getTimeout(AbstractTest test) {
        return this.timeoutMap.get(test);
    }

    public Long getCount(AbstractTest test) {
        return this.counterMap.get(test);
    }

    public Map<AbstractTest, Integer> getWeightMap() {
        return this.weightMap;
    }

    public int getTotalWeight() {
        return this.weightMap.getTotalWeight();
    }

    public Collection<AbstractTest> getTests() {
        return this.orderedTests;
    }

    public AbstractTest getTest(String testName) {
        return this.weightMap.getTest(testName);
    }

    public void remove(String testName) {
        AbstractTest test = this.weightMap.getTest(testName);
        this.orderedTests.remove(test);
        this.weightMap.remove(test);
    }

    public void remove(AbstractTest test) {
        this.weightMap.remove(test);
        this.orderedTests.remove(test);
    }

    public boolean contains(String testName) {
        return this.weightMap.contains(testName);
    }

    private static class WeightMap
    extends HashMap<AbstractTest, Integer> {
        private int totalWeight;
        private HashMap<String, AbstractTest> nameMap = new HashMap();

        private WeightMap() {
        }

        @Override
        public Integer put(AbstractTest test, Integer weight) {
            if (this.nameMap.containsKey(test.getName())) {
                throw new IllegalArgumentException("Suite already contains a test named: \"" + test.getName() + "\". " + "Please provide a different name using the \"name\" property.");
            }
            this.nameMap.put(test.getName(), test);
            Integer previous = super.put(test, weight);
            this.totalWeight += -(previous != null ? previous : 0) + weight;
            return previous;
        }

        @Override
        public void putAll(Map<? extends AbstractTest, ? extends Integer> other) {
            for (Map.Entry<? extends AbstractTest, ? extends Integer> entry : other.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Integer remove(Object test) {
            if (!(test instanceof AbstractTest)) {
                throw new IllegalArgumentException("Argument must extend AbstractTest");
            }
            this.nameMap.remove(((AbstractTest)test).getName());
            Integer previous = (Integer)super.remove(test);
            this.totalWeight -= previous != null ? previous : 0;
            return previous;
        }

        public int getTotalWeight() {
            return this.totalWeight;
        }

        public AbstractTest getTest(String testName) {
            if (!this.nameMap.containsKey(testName)) {
                throw new IllegalArgumentException("Test suite doesn't contain a test with this name: " + testName);
            }
            return this.nameMap.get(testName);
        }

        public boolean contains(String testName) {
            return this.nameMap.containsKey(testName);
        }
    }
}

