/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.internal.core.benckmark;

import com.adobe.qe.toughday.api.annotations.Internal;
import com.adobe.qe.toughday.api.annotations.labels.NotNull;
import com.adobe.qe.toughday.api.annotations.labels.Nullable;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.api.core.AbstractTestRunner;
import com.adobe.qe.toughday.api.core.TestId;
import com.adobe.qe.toughday.internal.core.UUIDTestId;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

@Internal
public final class AdHocTest
extends AbstractTest {
    private static final List<AbstractTest> EMPTY_ARRAY = new ArrayList<AbstractTest>();

    private void init(TestId id, AbstractTest parent, String name) {
        assert (id != null) : "The ID must not be null";
        assert (parent != null) : "The parent must not be null";
        assert (name != null) : "The name must not be null";
        this.setID(id);
        this.setParent(parent);
        this.setName(name);
    }

    public AdHocTest(@NotNull TestId id, @NotNull AbstractTest parent, @NotNull String name) {
        this.init(id, parent, name);
    }

    public AdHocTest(@Nullable UUID id, @NotNull AbstractTest parent, @NotNull String name) {
        if (id != null) {
            this.init(new UUIDTestId(id), parent, name);
        } else {
            this.init(new AdHocTestId(parent, name), parent, name);
        }
    }

    public AdHocTest(@NotNull AbstractTest parent, @NotNull String name) {
        this(new AdHocTestId(parent, name), parent, name);
    }

    @Override
    public List<AbstractTest> getChildren() {
        return EMPTY_ARRAY;
    }

    @Override
    public Class<? extends AbstractTestRunner> getTestRunnerClass() {
        return null;
    }

    @Override
    public AbstractTest newInstance() {
        return new AdHocTest(this.getId(), this.getParent(), this.getName());
    }

    private static class AdHocTestId
    extends TestId {
        private AbstractTest parent;
        private String name;
        private long nameHash;

        public AdHocTestId(AbstractTest parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        @Override
        public boolean equals(TestId testId) {
            if (this == testId) {
                return true;
            }
            if (!(testId instanceof AdHocTestId)) {
                return false;
            }
            AdHocTestId adHocTestId = (AdHocTestId)testId;
            if (!this.parent.getId().equals(adHocTestId.parent.getId())) {
                return false;
            }
            if (this.nameHash != 0L && adHocTestId.nameHash != 0L && this.nameHash != adHocTestId.nameHash) {
                return false;
            }
            return this.name.equals(adHocTestId.name);
        }

        @Override
        public long getHashCode() {
            long h = this.nameHash;
            if (h == 0L && this.name.length() > 0) {
                for (int i = 0; i < this.name.length(); ++i) {
                    h = 31L * h + (long)this.name.charAt(i);
                }
                this.nameHash = h;
            }
            return h * this.parent.getId().getHashCode();
        }
    }
}

