/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.internal.core.benckmark;

import com.adobe.qe.toughday.api.annotations.labels.Nullable;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.api.core.RunMap;
import com.adobe.qe.toughday.api.core.SkippedTestException;
import com.adobe.qe.toughday.api.core.benchmark.Benchmark;
import com.adobe.qe.toughday.api.core.benchmark.Proxy;
import com.adobe.qe.toughday.api.core.benchmark.ProxyFactory;
import com.adobe.qe.toughday.api.core.benchmark.ProxyHelpers;
import com.adobe.qe.toughday.api.core.benchmark.ResultInfo;
import com.adobe.qe.toughday.api.core.benchmark.TestResult;
import com.adobe.qe.toughday.api.core.benchmark.signatures.Callable;
import com.adobe.qe.toughday.api.core.benchmark.signatures.InjectTestResultCallable;
import com.adobe.qe.toughday.api.core.benchmark.signatures.VoidCallable;
import com.adobe.qe.toughday.api.core.benchmark.signatures.VoidInjectTestResultCallable;
import com.adobe.qe.toughday.internal.core.benckmark.AdHocTest;
import com.adobe.qe.toughday.internal.core.benckmark.ImmutableResultInfo;
import com.adobe.qe.toughday.internal.core.benckmark.ProxiesContainer;
import java.lang.reflect.Modifier;
import java.util.UUID;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class BenchmarkImpl
implements Benchmark {
    private ProxiesContainer proxiesContainer = new ProxiesContainer();
    private RunMap runMap;

    @Override
    public <T, F extends T> void registerClassProxy(Class<T> klass, Class<F> proxyClass) {
        this.proxiesContainer.registerClassProxy(klass, proxyClass);
    }

    @Override
    public <T> void registerClassProxyFactory(Class<T> klass, ProxyFactory<T> proxyFactory) {
        this.proxiesContainer.registerClassProxyFactory(klass, proxyFactory);
    }

    @Override
    public <T> void registerHierarchyProxyFactory(Class<T> klass, ProxyFactory<T> proxyFactory) {
        this.proxiesContainer.registerHierarchyFactory(klass, proxyFactory);
    }

    @Override
    public void setRunMap(RunMap runMap) {
        this.runMap = runMap;
    }

    @Override
    public RunMap getRunMap() {
        return this.runMap;
    }

    @Override
    public <R, K> ResultInfo<R, K> computeTestResult(AbstractTest test, InjectTestResultCallable<R, K> callable) {
        Throwable throwableResult = null;
        Object callableResult = null;
        Object testResult = new TestResult(test).beginBenchmark();
        try {
            callableResult = callable.call((TestResult<K>)testResult);
        }
        catch (SkippedTestException e) {
            ((TestResult)testResult).markAsSkipped(e);
            throwableResult = e;
        }
        catch (Throwable e) {
            ((TestResult)testResult).markAsFailed(e);
            throwableResult = e;
        }
        if (Thread.interrupted() && throwableResult == null) {
            throwableResult = new InterruptedException("Timeout occurred.");
            ((TestResult)testResult).markAsFailed(throwableResult);
        }
        ((TestResult)testResult).endBenchmark();
        if (test instanceof AdHocTest) {
            ((TestResult)testResult).withShowInAggregatedView(test.getShowStepsResolved());
        }
        return new ImmutableResultInfo(testResult, callableResult, throwableResult);
    }

    @Override
    public <T> T measure(AbstractTest test, T object) throws Throwable {
        T proxyObject = this.proxiesContainer.getProxy(object, test, this);
        if (proxyObject == null) {
            proxyObject = this.createDefaultProxy(test, object);
        }
        return this.measure(test, object, proxyObject);
    }

    public <T> T measure(@Nullable UUID id, AbstractTest parent, String label, T object) throws Throwable {
        return this.measure((AbstractTest)new AdHocTest(id, parent, label), object);
    }

    @Override
    public <T> T measure(AbstractTest parent, String label, T object) throws Throwable {
        return this.measure((UUID)null, parent, label, object);
    }

    @Override
    public <T> T measure(AbstractTest test, T object, T proxy) throws Throwable {
        if (proxy instanceof Proxy) {
            Proxy p = (Proxy)proxy;
            p.setTest(test);
            p.setTarget(object);
            p.setBenchmark(this);
        }
        return proxy;
    }

    public <T> T measure(@Nullable UUID id, AbstractTest parent, String label, T object, T proxy) throws Throwable {
        return this.measure((AbstractTest)new AdHocTest(id, parent, label), object, proxy);
    }

    @Override
    public <T> T measure(AbstractTest parent, String label, T object, T proxy) throws Throwable {
        return this.measure(null, parent, label, object, proxy);
    }

    @Override
    public <T> T measure(AbstractTest test, Callable<T> callable) throws Throwable {
        ResultInfo result = this.computeTestResult(test, testResult -> callable.call());
        this.runMap.record(result.getTestResult());
        Throwable throwable = result.getThrowable();
        if (throwable != null) {
            throw throwable;
        }
        return (T)result.getReturnValue();
    }

    public <T> T measure(@Nullable UUID id, AbstractTest parent, String label, Callable<T> callable) throws Throwable {
        return this.measure((AbstractTest)new AdHocTest(id, parent, label), callable);
    }

    @Override
    public <T> T measure(AbstractTest parent, String label, Callable<T> callable) throws Throwable {
        return this.measure((UUID)null, parent, label, callable);
    }

    @Override
    public void measure(AbstractTest test, VoidCallable callable) throws Throwable {
        ResultInfo result = this.computeTestResult(test, testResult -> {
            callable.call();
            return null;
        });
        this.runMap.record(result.getTestResult());
        Throwable throwable = result.getThrowable();
        if (throwable != null) {
            throw throwable;
        }
    }

    public void measure(@Nullable UUID id, AbstractTest parent, String label, VoidCallable callable) throws Throwable {
        this.measure((AbstractTest)new AdHocTest(id, parent, label), callable);
    }

    @Override
    public void measure(AbstractTest parent, String label, VoidCallable callable) throws Throwable {
        this.measure((UUID)null, parent, label, callable);
    }

    @Override
    public <T, K> T measure(AbstractTest test, InjectTestResultCallable<T, K> callable) throws Throwable {
        ResultInfo result = this.computeTestResult(test, testResult -> callable.call(testResult));
        this.runMap.record(result.getTestResult());
        Throwable throwable = result.getThrowable();
        if (throwable != null) {
            throw throwable;
        }
        return (T)result.getReturnValue();
    }

    public <T, K> T measure(@Nullable UUID id, AbstractTest parent, String label, InjectTestResultCallable<T, K> callable) throws Throwable {
        return this.measure((AbstractTest)new AdHocTest(id, parent, label), callable);
    }

    @Override
    public <T, K> T measure(AbstractTest parent, String label, InjectTestResultCallable<T, K> callable) throws Throwable {
        return this.measure((UUID)null, parent, label, callable);
    }

    @Override
    public <K> void measure(AbstractTest test, VoidInjectTestResultCallable<K> callable) throws Throwable {
        ResultInfo result = this.computeTestResult(test, testResult -> {
            callable.call(testResult);
            return null;
        });
        this.runMap.record(result.getTestResult());
        Throwable throwable = result.getThrowable();
        if (throwable != null) {
            throw throwable;
        }
    }

    public <K> void measure(@Nullable UUID id, AbstractTest parent, String label, VoidInjectTestResultCallable<K> callable) throws Throwable {
        this.measure((AbstractTest)new AdHocTest(id, parent, label), callable);
    }

    @Override
    public <K> void measure(AbstractTest parent, String label, VoidInjectTestResultCallable<K> callable) throws Throwable {
        this.measure((UUID)null, parent, label, callable);
    }

    private <T> T createDefaultProxy(final AbstractTest test, final T object) throws Throwable {
        return (T)Mockito.mock(object.getClass(), new Answer(){

            public Object answer(final InvocationOnMock invocation) throws Throwable {
                return BenchmarkImpl.this.measure(test, new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        if (!Modifier.isPublic(invocation.getMethod().getModifiers())) {
                            invocation.getMethod().setAccessible(true);
                        }
                        return invocation.getMethod().invoke(object, ProxyHelpers.canonicArguments(invocation.getMethod(), invocation.getArguments()));
                    }
                });
            }
        });
    }

    public BenchmarkImpl clone() {
        BenchmarkImpl clone = new BenchmarkImpl();
        clone.proxiesContainer = this.proxiesContainer.clone();
        return clone;
    }
}

