/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.internal.core.benckmark;

import com.adobe.qe.toughday.api.annotations.labels.Nullable;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.api.core.benchmark.Benchmark;
import com.adobe.qe.toughday.api.core.benchmark.ProxyFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ProxiesContainer {
    ReadWriteLock containerLock = new ReentrantReadWriteLock();
    Map<Class, Class> proxies = new HashMap<Class, Class>();
    Map<Class, ProxyFactory> proxyFactories = new HashMap<Class, ProxyFactory>();
    Map<Class, ProxyFactory> proxyHierarchyFactories = new HashMap<Class, ProxyFactory>();
    Map<Class, Class> proxiesCache = new HashMap<Class, Class>();
    Map<Class, ProxyFactory> proxyFactoriesCache = new HashMap<Class, ProxyFactory>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T getProxy(T target, AbstractTest test, Benchmark benchmark) throws Exception {
        Class<?> targetClass = target.getClass();
        this.containerLock.readLock().lock();
        try {
            if (this.proxiesCache.containsKey(targetClass)) {
                Class proxyClass = this.proxiesCache.get(targetClass);
                T t = proxyClass != null ? (T)proxyClass.newInstance() : null;
                return t;
            }
            if (this.proxies.containsKey(targetClass)) {
                Class proxyClass = this.proxies.get(targetClass);
                this.addToCache(this.proxiesCache, targetClass, proxyClass);
                T t = proxyClass != null ? (T)proxyClass.newInstance() : null;
                return t;
            }
            if (this.proxyFactoriesCache.containsKey(targetClass)) {
                ProxyFactory proxyFactory = this.proxyFactoriesCache.get(targetClass);
                T t = proxyFactory != null ? (T)proxyFactory.createProxy(target, test, benchmark) : null;
                return t;
            }
            if (this.proxyFactories.containsKey(targetClass)) {
                ProxyFactory proxyFactory = this.proxyFactories.get(targetClass);
                this.addToCache(this.proxyFactoriesCache, targetClass, proxyFactory);
                T t = proxyFactory != null ? (T)proxyFactory.createProxy(target, test, benchmark) : null;
                return t;
            }
            for (Class<?> p = targetClass; p != null; p = p.getSuperclass()) {
                if (!this.proxyHierarchyFactories.containsKey(p)) continue;
                ProxyFactory proxyFactory = this.proxyHierarchyFactories.get(p);
                this.addToCache(this.proxyFactoriesCache, targetClass, proxyFactory);
                T t = proxyFactory != null ? (T)proxyFactory.createProxy(target, test, benchmark) : null;
                return t;
            }
            for (Class<?> p : targetClass.getInterfaces()) {
                if (!this.proxyHierarchyFactories.containsKey(p)) continue;
                ProxyFactory proxyFactory = this.proxyHierarchyFactories.get(p);
                this.addToCache(this.proxyFactoriesCache, targetClass, proxyFactory);
                T t = proxyFactory != null ? (T)proxyFactory.createProxy(target, test, benchmark) : null;
                return t;
            }
            this.addToCache(this.proxiesCache, targetClass, null);
            Class<?>[] classArray = null;
            return (T)classArray;
        }
        finally {
            this.containerLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void addToCache(Map<Class, T> cache, Class key, T value) {
        this.containerLock.readLock().unlock();
        this.containerLock.writeLock().lock();
        try {
            cache.put(key, value);
        }
        finally {
            this.containerLock.readLock().lock();
            this.containerLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProxiesContainer clone() {
        this.containerLock.readLock().lock();
        try {
            ProxiesContainer clone = new ProxiesContainer();
            for (Map.Entry<Class, Class> entry : this.proxies.entrySet()) {
                clone.registerClassProxy(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<Class, Object> entry : this.proxyFactories.entrySet()) {
                clone.registerClassProxyFactory(entry.getKey(), (ProxyFactory)entry.getValue());
            }
            for (Map.Entry<Class, Object> entry : this.proxyHierarchyFactories.entrySet()) {
                clone.registerHierarchyFactory(entry.getKey(), (ProxyFactory)entry.getValue());
            }
            ProxiesContainer proxiesContainer = clone;
            return proxiesContainer;
        }
        finally {
            this.containerLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, F extends T> void registerClassProxy(Class<T> klass, @Nullable Class<F> proxyClass) {
        if (proxyClass != null) {
            try {
                proxyClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException("Proxies need to be instantiated using a constructor without arguments");
            }
        }
        this.containerLock.writeLock().lock();
        try {
            this.proxiesCache.clear();
            this.proxyFactoriesCache.clear();
            this.proxies.put(klass, proxyClass);
            this.proxiesCache.put(klass, proxyClass);
        }
        finally {
            this.containerLock.writeLock().unlock();
        }
    }

    public <T> void registerClassProxyFactory(Class<T> klass, @Nullable ProxyFactory<T> proxyFactory) {
        this.containerLock.writeLock().lock();
        try {
            this.proxiesCache.clear();
            this.proxyFactoriesCache.clear();
            this.proxyFactories.put(klass, proxyFactory);
            this.proxyFactoriesCache.put(klass, proxyFactory);
        }
        finally {
            this.containerLock.writeLock().unlock();
        }
    }

    public <T> void registerHierarchyFactory(Class<T> klass, @Nullable ProxyFactory<T> proxyFactory) {
        this.containerLock.writeLock().lock();
        try {
            this.proxiesCache.clear();
            this.proxyFactoriesCache.clear();
            this.proxyHierarchyFactories.put(klass, proxyFactory);
            this.proxyFactoriesCache.put(klass, proxyFactory);
        }
        finally {
            this.containerLock.writeLock().unlock();
        }
    }
}

