/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.internal.core.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigParams
implements Serializable {
    private static final Logger LOGGER = LogManager.getLogger(ConfigParams.class);
    private Map<String, Object> globalParams = new HashMap<String, Object>();
    private Map<String, Object> publishModeParams = new HashMap<String, Object>();
    private Map<String, Object> runModeParams = new HashMap<String, Object>();
    private List<ClassMetaObject> itemsToAdd = new ArrayList<ClassMetaObject>();
    private List<NamedMetaObject> itemsToConfig = new ArrayList<NamedMetaObject>();
    private List<String> itemsToExclude = new ArrayList<String>();

    public static <T> T deepClone(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(byteArrayOutputStream);
            oos.writeObject(object);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(byteArrayInputStream);
            return (T)ois.readObject();
        }
        catch (Exception e) {
            LOGGER.error(e);
            return null;
        }
    }

    public void setGlobalParams(Map<String, Object> globalParams) {
        this.globalParams = globalParams;
    }

    public void setPublishModeParams(Map<String, Object> publishModeParams) {
        this.publishModeParams = publishModeParams;
    }

    public void setRunModeParams(Map<String, Object> runModeParams) {
        this.runModeParams = runModeParams;
    }

    public void configItem(String testName, Map<String, Object> params) {
        this.itemsToConfig.add(new NamedMetaObject(testName, params));
    }

    public void addItem(String itemName, Map<String, Object> params) {
        this.itemsToAdd.add(new ClassMetaObject(itemName, params));
    }

    public void exclude(String testName) {
        this.itemsToExclude.add(testName);
    }

    public Map<String, Object> getGlobalParams() {
        return this.globalParams;
    }

    public Map<String, Object> getPublishModeParams() {
        return this.publishModeParams;
    }

    public Map<String, Object> getRunModeParams() {
        return this.runModeParams;
    }

    public List<String> getItemsToExclude() {
        return this.itemsToExclude;
    }

    public List<NamedMetaObject> getItemsToConfig() {
        return this.itemsToConfig;
    }

    public List<ClassMetaObject> getItemsToAdd() {
        return this.itemsToAdd;
    }

    public void merge(ConfigParams other) {
        this.globalParams.putAll(other.getGlobalParams());
        this.itemsToAdd.addAll(other.getItemsToAdd());
        this.itemsToExclude.addAll(other.getItemsToExclude());
        this.itemsToConfig.addAll(other.getItemsToConfig());
        if (other.runModeParams.containsKey("type")) {
            this.runModeParams.clear();
        }
        this.runModeParams.putAll(other.runModeParams);
        if (other.publishModeParams.containsKey("type")) {
            this.publishModeParams.clear();
        }
        this.publishModeParams.putAll(other.publishModeParams);
    }

    public static class NamedMetaObject
    extends MetaObject {
        private String name;

        public NamedMetaObject(String name, Map<String, Object> parameters) {
            super(parameters);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class ClassMetaObject
    extends MetaObject {
        private String className;

        public ClassMetaObject(String className, Map<String, Object> parameters) {
            super(parameters);
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }
    }

    public static class MetaObject
    implements Serializable {
        private Map<String, Object> parameters;

        public MetaObject(Map<String, Object> parameters) {
            this.parameters = parameters;
        }

        public Map<String, Object> getParameters() {
            return this.parameters;
        }
    }
}

