/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.internal.core.config;

import com.adobe.qe.toughday.api.annotations.ConfigArgSet;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.api.core.Publisher;
import com.adobe.qe.toughday.internal.core.ReflectionsContainer;
import com.adobe.qe.toughday.internal.core.TestSuite;
import com.adobe.qe.toughday.internal.core.config.ConfigParams;
import com.adobe.qe.toughday.internal.core.config.ConfigurationParser;
import com.adobe.qe.toughday.internal.core.config.GlobalArgs;
import com.adobe.qe.toughday.internal.core.config.PredefinedSuites;
import com.adobe.qe.toughday.internal.core.config.ToughdayExtensionClassLoader;
import com.adobe.qe.toughday.internal.core.config.parsers.cli.CliParser;
import com.adobe.qe.toughday.internal.core.config.parsers.yaml.GenerateYamlConfiguration;
import com.adobe.qe.toughday.internal.core.config.parsers.yaml.YamlParser;
import com.adobe.qe.toughday.internal.core.engine.PublishMode;
import com.adobe.qe.toughday.internal.core.engine.RunMode;
import com.adobe.qe.toughday.metrics.Metric;
import com.adobe.qe.toughday.publishers.CSVPublisher;
import com.adobe.qe.toughday.publishers.ConsolePublisher;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.reflections.Reflections;

public class Configuration {
    private static final Logger LOGGER = LogManager.getLogger(Configuration.class);
    private static final String DEFAULT_RUN_MODE = "normal";
    private static final String DEFAULT_PUBLISH_MODE = "simple";
    PredefinedSuites predefinedSuites = new PredefinedSuites();
    private GlobalArgs globalArgs;
    private TestSuite suite;
    private RunMode runMode;
    private PublishMode publishMode;

    private void handleExtensions(ConfigParams configParams) {
        ArrayList<String> extensionList = new ArrayList<String>();
        ArrayList<ConfigParams.ClassMetaObject> itemsToAddCopy = new ArrayList<ConfigParams.ClassMetaObject>(configParams.getItemsToAdd());
        for (ConfigParams.ClassMetaObject itemToAdd : itemsToAddCopy) {
            if (!itemToAdd.getClassName().endsWith(".jar")) continue;
            configParams.getItemsToAdd().remove(itemToAdd);
            extensionList.add(itemToAdd.getClassName());
        }
        if (extensionList.isEmpty()) {
            return;
        }
        ReflectionsContainer.getInstance();
        List<JarFile> jarFiles = this.createJarFiles(extensionList);
        ClassLoader classLoader = null;
        try {
            classLoader = this.processJarFiles(jarFiles, this.formJarURLs(extensionList));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        Reflections reflections = new Reflections(classLoader);
        ReflectionsContainer.getInstance().merge(reflections);
    }

    private List<JarFile> createJarFiles(List<String> extensionList) {
        ArrayList<JarFile> jarFiles = new ArrayList<JarFile>();
        for (String extensionFileName : extensionList) {
            try {
                JarFile jarFile = new JarFile(extensionFileName);
                jarFiles.add(jarFile);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to find " + extensionFileName + " file.");
            }
        }
        return jarFiles;
    }

    private URL[] formJarURLs(List<String> extensionsFileNames) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String filename : extensionsFileNames) {
            try {
                urls.add(new URL("jar:file:" + filename + "!/"));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return urls.toArray(new URL[0]);
    }

    private ClassLoader processJarFiles(List<JarFile> jarFiles, URL[] urls) throws MalformedURLException {
        ToughdayExtensionClassLoader classLoader = new ToughdayExtensionClassLoader(urls, Thread.currentThread().getContextClassLoader());
        HashMap<String, String> newClasses = new HashMap<String, String>();
        Thread.currentThread().setContextClassLoader(classLoader);
        for (JarFile jar : jarFiles) {
            Enumeration<JarEntry> jarContent = jar.entries();
            while (jarContent.hasMoreElements()) {
                JarEntry jarEntry = jarContent.nextElement();
                if (jarEntry.isDirectory() || !jarEntry.getName().endsWith(".class")) continue;
                String className = jarEntry.getName().replace(".class", "");
                if (newClasses.containsKey(className = className.replaceAll("/", "."))) {
                    throw new IllegalStateException("A class named " + className + " already exists in the jar file named " + (String)newClasses.get(className));
                }
                if (ReflectionsContainer.getInstance().containsClass(className)) {
                    throw new IllegalStateException("A class named " + className + " already exists in toughday default package.");
                }
                newClasses.put(className, jar.getName());
                try {
                    classLoader.loadClass(className);
                }
                catch (Throwable e) {
                    LOGGER.error("Class " + className + " could not be loaded from your extension jar. If this is an extension class, you will not be able to use it.", e);
                }
            }
        }
        return classLoader;
    }

    public Configuration(String[] cmdLineArgs) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        Metric metric;
        ConfigParams configParams = this.collectConfigurations(cmdLineArgs);
        ConfigParams copyOfConfigParams = (ConfigParams)ConfigParams.deepClone(configParams);
        HashMap<String, Class> items = new HashMap<String, Class>();
        boolean anyMetricAdded = false;
        this.handleExtensions(configParams);
        Map<String, Object> globalArgsMeta = configParams.getGlobalParams();
        for (String string : CliParser.availableHelpOptions) {
            if (!globalArgsMeta.containsKey(string)) continue;
            return;
        }
        this.globalArgs = Configuration.createObject(GlobalArgs.class, globalArgsMeta);
        this.applyLogLevel(this.globalArgs.getLogLevel());
        this.runMode = this.getRunMode(configParams);
        this.publishMode = this.getPublishMode(configParams);
        this.suite = this.getTestSuite(globalArgsMeta);
        for (AbstractTest abstractTest : this.suite.getTests()) {
            items.put(abstractTest.getName(), abstractTest.getClass());
        }
        for (ConfigParams.ClassMetaObject classMetaObject : configParams.getItemsToAdd()) {
            if (ReflectionsContainer.getInstance().isTestClass(classMetaObject.getClassName())) {
                AbstractTest test = Configuration.createObject(ReflectionsContainer.getInstance().getTestClass(classMetaObject.getClassName()), classMetaObject.getParameters());
                int weight = classMetaObject.getParameters().containsKey("weight") ? (Integer)classMetaObject.getParameters().remove("weight") : 1;
                long timeout = classMetaObject.getParameters().containsKey("timeout") ? (long)((Integer)classMetaObject.getParameters().remove("timeout")).intValue() : -1L;
                long counter = classMetaObject.getParameters().containsKey("count") ? (long)((Integer)classMetaObject.getParameters().remove("count")).intValue() : -1L;
                this.suite.add(test, weight, timeout, counter);
                items.put(test.getName(), test.getClass());
                this.checkInvalidArgs(classMetaObject.getParameters(), new List[0]);
                continue;
            }
            if (ReflectionsContainer.getInstance().isPublisherClass(classMetaObject.getClassName())) {
                Publisher publisher = Configuration.createObject(ReflectionsContainer.getInstance().getPublisherClass(classMetaObject.getClassName()), classMetaObject.getParameters());
                items.put(publisher.getName(), publisher.getClass());
                this.checkInvalidArgs(classMetaObject.getParameters(), new List[0]);
                this.globalArgs.addPublisher(publisher);
                continue;
            }
            if (ReflectionsContainer.getInstance().isMetricClass(classMetaObject.getClassName())) {
                metric = Configuration.createObject(ReflectionsContainer.getInstance().getMetricClass(classMetaObject.getClassName()), classMetaObject.getParameters());
                items.put(metric.getName(), metric.getClass());
                this.checkInvalidArgs(classMetaObject.getParameters(), new List[0]);
                this.globalArgs.addMetric(metric);
                anyMetricAdded = true;
                continue;
            }
            if (classMetaObject.getClassName().equals("BASICMetrics")) {
                List<Metric> basicMetrics = Metric.basicMetrics;
                for (Metric metric2 : basicMetrics) {
                    this.globalArgs.addMetric(metric2);
                    items.put(metric2.getName(), metric2.getClass());
                }
                anyMetricAdded = true;
                continue;
            }
            if (classMetaObject.getClassName().equals("DEFAULTMetrics")) {
                List<Metric> defaultMetrics = Metric.defaultMetrics;
                for (Metric metric3 : defaultMetrics) {
                    this.globalArgs.addMetric(metric3);
                    items.put(metric3.getName(), metric3.getClass());
                }
                anyMetricAdded = true;
                continue;
            }
            throw new IllegalArgumentException("Unknown publisher, test or metric class: " + classMetaObject.getClassName());
        }
        if (this.globalArgs.getPublishers().size() == 0) {
            Publisher publisher = Configuration.createObject(ConsolePublisher.class, new HashMap<String, Object>());
            items.put(publisher.getName(), publisher.getClass());
            this.globalArgs.addPublisher(publisher);
            publisher = Configuration.createObject(CSVPublisher.class, (Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("append", "true");
                }
            });
            items.put(publisher.getName(), publisher.getClass());
            this.globalArgs.addPublisher(publisher);
        }
        if (this.suite.getTests().size() == 0) {
            this.suite = this.predefinedSuites.getDefaultSuite();
        }
        if (!anyMetricAdded) {
            Iterator<Object> defaultMetrics = Metric.defaultMetrics;
            Iterator iterator = defaultMetrics.iterator();
            while (iterator.hasNext()) {
                metric = (Metric)iterator.next();
                this.globalArgs.addMetric(metric);
            }
        }
        for (ConfigParams.NamedMetaObject namedMetaObject : configParams.getItemsToConfig()) {
            String name;
            if (this.suite.contains(namedMetaObject.getName())) {
                AbstractTest testObject = this.suite.getTest(namedMetaObject.getName());
                if (namedMetaObject.getParameters().containsKey("name")) {
                    this.suite.replaceName(testObject, String.valueOf(namedMetaObject.getParameters().remove("name")));
                }
                Configuration.setObjectProperties(testObject, namedMetaObject.getParameters(), false);
                items.put(testObject.getName(), testObject.getClass());
                if (namedMetaObject.getParameters().containsKey("weight")) {
                    this.suite.replaceWeight(testObject.getName(), (Integer)namedMetaObject.getParameters().remove("weight"));
                }
                if (namedMetaObject.getParameters().containsKey("timeout")) {
                    this.suite.replaceTimeout(testObject.getName(), ((Integer)namedMetaObject.getParameters().remove("timeout")).intValue());
                }
                if (namedMetaObject.getParameters().containsKey("count")) {
                    this.suite.replaceCount(testObject.getName(), ((Integer)namedMetaObject.getParameters().remove("count")).intValue());
                }
            } else if (this.globalArgs.containsPublisher(namedMetaObject.getName())) {
                Publisher publisherObject = this.globalArgs.getPublisher(namedMetaObject.getName());
                name = publisherObject.getName();
                Configuration.setObjectProperties(publisherObject, namedMetaObject.getParameters(), false);
                if (!name.equals(publisherObject.getName())) {
                    this.getGlobalArgs().updatePublisherName(name, publisherObject.getName());
                }
            } else if (this.globalArgs.containsMetric(namedMetaObject.getName())) {
                Metric metricObject = this.globalArgs.getMetric(namedMetaObject.getName());
                name = metricObject.getName();
                Configuration.setObjectProperties(metricObject, namedMetaObject.getParameters(), false);
                if (!name.equals(metricObject.getName())) {
                    this.getGlobalArgs().updateMetricName(name, metricObject.getName());
                }
            } else {
                throw new IllegalStateException("No test/publisher/metric found with name \"" + namedMetaObject.getName() + "\", so we can't configure it.");
            }
            this.checkInvalidArgs(namedMetaObject.getParameters(), new List[0]);
        }
        for (String string : configParams.getItemsToExclude()) {
            if (this.suite.contains(string)) {
                this.suite.remove(string);
                continue;
            }
            if (this.globalArgs.containsPublisher(string)) {
                this.globalArgs.removePublisher(string);
                continue;
            }
            if (this.getGlobalArgs().containsMetric(string)) {
                this.globalArgs.removeMetric(string);
                continue;
            }
            throw new IllegalStateException("No test/publisher/metric found with name \"" + string + "\", so we can't exclude it.");
        }
        this.checkInvalidArgs(globalArgsMeta, CliParser.parserArgs);
        for (AbstractTest abstractTest : this.suite.getTests()) {
            abstractTest.setGlobalArgs(this.globalArgs);
        }
        if (this.getGlobalArgs().getSaveConfig()) {
            GenerateYamlConfiguration generateYaml = new GenerateYamlConfiguration(copyOfConfigParams, items);
            generateYaml.createYamlConfigurationFile();
        }
    }

    public static String propertyFromMethod(String methodName) {
        return methodName.startsWith("set") || methodName.startsWith("get") ? StringUtils.lowerCase(methodName.substring(3)) : StringUtils.lowerCase(methodName);
    }

    public static <T> T setObjectProperties(T object, Map<String, Object> args, boolean applyDefaults) throws InvocationTargetException, IllegalAccessException {
        Class<?> classObject = object.getClass();
        LOGGER.info("Configuring object of class: " + classObject.getSimpleName() + " [" + classObject.getName() + "]");
        for (Method method : classObject.getMethods()) {
            ConfigArgSet annotation = method.getAnnotation(ConfigArgSet.class);
            if (annotation == null) continue;
            String property = Configuration.propertyFromMethod(method.getName());
            Object value = args.remove(property);
            if (value == null) {
                String defaultValue;
                if (annotation.required()) {
                    throw new IllegalArgumentException("Property \"" + property + "\" is required for class " + classObject.getSimpleName());
                }
                if (!applyDefaults || (defaultValue = annotation.defaultValue()).compareTo("") == 0) continue;
                LOGGER.info("\tSetting property \"" + property + "\" to default value: \"" + defaultValue + "\"");
                method.invoke(object, defaultValue);
                continue;
            }
            LOGGER.info("\tSetting property \"" + property + "\" to: \"" + value + "\"");
            method.invoke(object, value.toString());
        }
        return object;
    }

    public static <T> T createObject(Class<? extends T> classObject, Map<String, Object> args) throws IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException {
        Constructor<T> constructor = null;
        try {
            constructor = classObject.getConstructor(null);
        }
        catch (NoSuchMethodException e) {
            NoSuchMethodException explicitException = new NoSuchMethodException(classObject.getSimpleName() + " class must have a constructor without arguments");
            explicitException.initCause(e);
            throw explicitException;
        }
        T object = constructor.newInstance(new Object[0]);
        Configuration.setObjectProperties(object, args, true);
        return object;
    }

    private TestSuite getTestSuite(Map<String, Object> globalArgsMeta) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        String[] testSuiteNames;
        if (!globalArgsMeta.containsKey("suite")) {
            return Configuration.createObject(TestSuite.class, globalArgsMeta);
        }
        TestSuite testSuite = new TestSuite();
        for (String testSuiteName : testSuiteNames = String.valueOf(globalArgsMeta.remove("suite")).split(",")) {
            if (!this.predefinedSuites.containsKey(testSuiteName)) {
                throw new IllegalArgumentException("Unknown suite: " + testSuiteName);
            }
            testSuite.addAll((TestSuite)this.predefinedSuites.get(testSuiteName));
        }
        return testSuite;
    }

    private void checkInvalidArgs(Map<String, Object> args, List<Object> ... whitelisted) {
        HashMap<String, Object> argsCopy = new HashMap<String, Object>();
        argsCopy.putAll(args);
        args = argsCopy;
        for (int i = 0; i < whitelisted.length; ++i) {
            List<Object> whitelist = whitelisted[i];
            for (Object whitelistedArg : whitelist) {
                args.remove(whitelistedArg);
            }
        }
        if (args.size() == 0) {
            return;
        }
        for (String key : args.keySet()) {
            LOGGER.error("Invalid property \"" + key + "\"");
        }
        throw new IllegalStateException("There are invalid properties in the configuration. Please check thoughday.log.");
    }

    private RunMode getRunMode(ConfigParams configParams) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        Map<String, Object> runModeParams = configParams.getRunModeParams();
        if (runModeParams.size() != 0 && !runModeParams.containsKey("type")) {
            throw new IllegalStateException("The Run mode doesn't have a type");
        }
        String type = runModeParams.size() != 0 ? String.valueOf(runModeParams.get("type")) : DEFAULT_RUN_MODE;
        Class<? extends RunMode> runModeClass = ReflectionsContainer.getInstance().getRunModeClasses().get(type);
        if (runModeClass == null) {
            throw new IllegalStateException("A run mode with type \"" + type + "\" does not exist");
        }
        return Configuration.createObject(runModeClass, runModeParams);
    }

    private PublishMode getPublishMode(ConfigParams configParams) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        Map<String, Object> publishModeParams = configParams.getPublishModeParams();
        if (publishModeParams.size() != 0 && !publishModeParams.containsKey("type")) {
            throw new IllegalStateException("The Publish mode doesn't have a type");
        }
        String type = publishModeParams.size() != 0 ? String.valueOf(publishModeParams.get("type")) : DEFAULT_PUBLISH_MODE;
        Class<? extends PublishMode> publishModeClass = ReflectionsContainer.getInstance().getPublishModeClasses().get(type);
        if (publishModeClass == null) {
            throw new IllegalStateException("A publish mode with type \"" + type + "\" does not exist");
        }
        return Configuration.createObject(publishModeClass, publishModeParams);
    }

    private void applyLogLevel(Level level) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext(false);
        org.apache.logging.log4j.core.config.Configuration config = ctx.getConfiguration();
        for (LoggerConfig loggerConfig : config.getLoggers().values()) {
            if (loggerConfig.getName().equals("org.reflections.Reflections")) continue;
            loggerConfig.setLevel(level);
        }
        System.setProperty("toughday.log.level", level.name());
        ctx.updateLoggers();
    }

    private ConfigParams collectConfigurations(String[] cmdLineArgs) {
        ConfigParams configs = new YamlParser().parse(cmdLineArgs);
        configs.merge(new CliParser().parse(cmdLineArgs));
        return configs;
    }

    public HashMap<String, TestSuite> getPredefinedSuites() {
        return this.predefinedSuites;
    }

    public TestSuite getTestSuite() {
        return this.suite;
    }

    public GlobalArgs getGlobalArgs() {
        return this.globalArgs;
    }

    public RunMode getRunMode() {
        return this.runMode;
    }

    public PublishMode getPublishMode() {
        return this.publishMode;
    }

    private ConfigurationParser getConfigurationParser(String[] args) {
        return new CliParser();
    }
}

