/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.internal.core.config;

import com.adobe.qe.toughday.api.annotations.ConfigArgGet;
import com.adobe.qe.toughday.api.annotations.ConfigArgSet;
import com.adobe.qe.toughday.api.core.Publisher;
import com.adobe.qe.toughday.metrics.Metric;
import com.adobe.qe.toughday.metrics.Name;
import com.adobe.qe.toughday.metrics.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GlobalArgs
implements com.adobe.qe.toughday.api.core.config.GlobalArgs {
    private static final Logger LOGGER = LogManager.getLogger(GlobalArgs.class);
    public static final String DEFAULT_DURATION = "1d";
    public static final String DEFAULT_USER = "admin";
    public static final String DEFAULT_PASSWORD = "admin";
    public static final String DEFAULT_PORT_STRING = "4502";
    public static final String DEFAULT_PROTOCOL = "http";
    public static final int DEFAULT_PORT = Integer.parseInt("4502");
    public static final String DEFAULT_TIMEOUT_STRING = "180";
    public static final long DEFAULT_TIMEOUT = 180000L;
    public static final String DEFAULT_LOG_LEVEL_STRING = "INFO";
    public static final Level DEFAULT_LOG_LEVEL = Level.valueOf("INFO");
    public static final String DEFAULT_DRY_RUN = "false";
    public static final String DEFAULT_SAVE_CONFIG = "true";
    private String host;
    private int port;
    private String user = "admin";
    private String password = "admin";
    private long duration;
    private Map<String, Publisher> publishers;
    private Map<String, Metric> metrics;
    private long timeout = 180000L;
    private String protocol = "http";
    private String authMethod;
    private boolean installSampleContent = true;
    private String contextPath;
    private Level logLevel = DEFAULT_LOG_LEVEL;
    private boolean dryRun = Boolean.parseBoolean("false");
    private boolean saveConfig = Boolean.parseBoolean("true");
    private boolean showSteps = false;
    private boolean hostValidationEnabled = true;

    public GlobalArgs() {
        this.publishers = new HashMap<String, Publisher>();
        this.metrics = new LinkedHashMap<String, Metric>();
        this.port = DEFAULT_PORT;
        this.duration = GlobalArgs.parseDurationToSeconds(DEFAULT_DURATION);
    }

    private static long unitToSeconds(char unit) {
        long factor = 1L;
        switch (unit) {
            case 'd': {
                factor *= 24L;
            }
            case 'h': {
                factor *= 60L;
            }
            case 'm': {
                factor *= 60L;
            }
            case 's': {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown duration unit: " + unit);
            }
        }
        return factor *= 1L;
    }

    public static long parseDurationToSeconds(String duration) {
        long finalDuration = 0L;
        long intermDuration = 0L;
        if (duration.matches("^[0-9]+$")) {
            throw new IllegalArgumentException("Time unit is not specified");
        }
        for (char c : duration.toCharArray()) {
            if (Character.isDigit(c)) {
                intermDuration = intermDuration * 10L + (long)(c - 48);
                continue;
            }
            finalDuration += intermDuration * GlobalArgs.unitToSeconds(c);
            intermDuration = 0L;
        }
        return finalDuration;
    }

    public void updatePublisherName(String oldName, String newName) {
        this.publishers.put(newName, this.publishers.remove(oldName));
    }

    public void updateMetricName(String oldName, String newName) {
        this.metrics.put(newName, this.metrics.remove(oldName));
    }

    public void addMetric(Metric metric) {
        if (this.metrics.containsKey(metric.getName())) {
            LOGGER.warn("A metric with this name was already added. Only the last one is taken into consideration.");
        }
        this.metrics.put(metric.getName(), metric);
    }

    public void addPublisher(Publisher publisher) {
        if (this.publishers.containsKey(publisher.getName())) {
            throw new IllegalStateException("There is already a publisher named \"" + publisher.getName() + "\"." + "Please provide a different name using the \"name\" property.");
        }
        this.publishers.put(publisher.getName(), publisher);
    }

    public Publisher getPublisher(String publisherName) {
        if (!this.publishers.containsKey(publisherName)) {
            throw new IllegalStateException("Could not find a publisher with the name \"" + publisherName + "\" to configure it.");
        }
        return this.publishers.get(publisherName);
    }

    public Metric getMetric(String metricName) {
        if (!this.metrics.containsKey(metricName)) {
            throw new IllegalStateException("Could not find a metric with the name \"" + metricName + "\" to configure it.");
        }
        return this.metrics.get(metricName);
    }

    public boolean containsPublisher(String publisherName) {
        return this.publishers.containsKey(publisherName);
    }

    public boolean containsMetric(String metricName) {
        return this.metrics.containsKey(metricName);
    }

    public void removePublisher(String publisherName) {
        Publisher publisher = this.publishers.remove(publisherName);
        if (publisher == null) {
            throw new IllegalStateException("Could not exclude publisher \"" + publisherName + "\", because there was no publisher configured with that name");
        }
    }

    public void removeMetric(String metricName) {
        Metric metric = this.metrics.remove(metricName);
        if (metric == null) {
            throw new IllegalStateException("Could not exclude metric \"" + metricName + "\", because there was no metric configured with that name");
        }
    }

    @Override
    @ConfigArgGet
    public long getDuration() {
        return this.duration;
    }

    @ConfigArgSet(required=false, desc="How long the tests will run. Can be expressed in s(econds), m(inutes), h(ours), and/or d(ays). Example: 1h30m.", defaultValue="1d", order=6)
    public void setDuration(String durationString) {
        this.duration = GlobalArgs.parseDurationToSeconds(durationString);
    }

    public Collection<Metric> getMetrics() {
        ArrayList<Metric> requiredMetrics = new ArrayList<Metric>();
        requiredMetrics.add(new Name());
        requiredMetrics.add(new Timestamp());
        requiredMetrics.addAll(this.metrics.values());
        return requiredMetrics;
    }

    public Collection<Publisher> getPublishers() {
        return this.publishers.values();
    }

    @Override
    @ConfigArgGet
    public long getTimeout() {
        return this.timeout;
    }

    @ConfigArgSet(required=false, desc="How long a test will run before it will be interrupted and marked as failed. Expressed in seconds", defaultValue="180", order=7)
    public void setTimeout(String timeout) {
        this.timeout = Integer.parseInt(timeout) * 1000;
    }

    @Override
    @ConfigArgGet
    public String getHost() {
        return this.host;
    }

    @ConfigArgSet(required=true, desc="The host name/ip which will be targeted", order=1)
    public void setHost(String host) {
        this.host = host;
    }

    @Override
    @ConfigArgGet
    public int getPort() {
        return this.port;
    }

    @ConfigArgSet(required=false, desc="The port of the host", defaultValue="4502", order=2)
    public void setPort(String port) {
        this.port = Integer.parseInt(port);
    }

    @Override
    @ConfigArgGet
    public String getUser() {
        return this.user;
    }

    @ConfigArgSet(required=false, desc="User name for the instance", defaultValue="admin", order=3)
    public void setUser(String user) {
        this.user = user;
    }

    @Override
    @ConfigArgGet
    public String getPassword() {
        return this.password;
    }

    @ConfigArgSet(required=false, desc="Password for the given user", defaultValue="admin", order=4)
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    @ConfigArgGet
    public String getProtocol() {
        return this.protocol;
    }

    @ConfigArgSet(required=false, desc="Authentication Method", defaultValue="basic")
    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    @Override
    @ConfigArgGet
    public String getAuthMethod() {
        return this.authMethod;
    }

    @ConfigArgSet(required=false, desc="What type of protocol to use for the host", defaultValue="http")
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Override
    @ConfigArgGet
    public boolean getInstallSampleContent() {
        return this.installSampleContent;
    }

    @ConfigArgSet(required=false, desc="Install ToughDay 2 Sample Content.", defaultValue="true")
    public void setInstallSampleContent(String installSampleContent) {
        this.installSampleContent = Boolean.valueOf(installSampleContent);
    }

    @ConfigArgSet(required=false, desc="Enable/Disable Host Validation", defaultValue="true")
    public void setHostValidationEnabled(String hostValidationEnabled) {
        this.hostValidationEnabled = Boolean.valueOf(hostValidationEnabled);
    }

    @Override
    @ConfigArgGet
    public String getContextPath() {
        return this.contextPath;
    }

    @ConfigArgSet(required=false, desc="Context path.")
    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    @Override
    @ConfigArgGet
    public Level getLogLevel() {
        return this.logLevel;
    }

    @ConfigArgSet(required=false, defaultValue="INFO", desc="Log level for ToughDay Engine")
    public void setLogLevel(String logLevel) {
        this.logLevel = Level.valueOf(logLevel);
    }

    @Override
    @ConfigArgGet
    public boolean getDryRun() {
        return this.dryRun;
    }

    @ConfigArgSet(required=false, defaultValue="false", desc="If true, prints the resulting configuration and does not run any tests.")
    public void setDryRun(String dryRun) {
        this.dryRun = Boolean.valueOf(dryRun);
    }

    @ConfigArgSet(required=false, defaultValue="true", desc="If true, saves the current configuration into a yaml configuration file.")
    public void setSaveConfig(String saveConfig) {
        this.saveConfig = Boolean.valueOf(saveConfig);
    }

    @Override
    @ConfigArgGet
    public boolean getSaveConfig() {
        return this.saveConfig;
    }

    @ConfigArgSet(required=false, defaultValue="false", desc="Show test steps in the aggregated publish. (They are always shown in the detailed publish)")
    public void setShowSteps(String showTestSteps) {
        this.showSteps = Boolean.parseBoolean(showTestSteps);
    }

    @Override
    @ConfigArgGet
    public boolean getShowSteps() {
        return this.showSteps;
    }

    @Override
    @ConfigArgGet
    public boolean getHostValidationEnabled() {
        return this.hostValidationEnabled;
    }
}

