/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.internal.core.config;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;

public class ToughdayExtensionClassLoader
extends URLClassLoader {
    private ClassLoader system = ToughdayExtensionClassLoader.getSystemClassLoader();

    public ToughdayExtensionClassLoader(URL[] classpath, ClassLoader parent) {
        super(classpath, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                if (this.system != null) {
                    try {
                        c = this.system.loadClass(name);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (c == null) {
                    try {
                        c = this.findClass(name);
                    }
                    catch (ClassNotFoundException e) {
                        c = super.loadClass(name, resolve);
                    }
                }
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        if (this.system != null) {
            url = this.system.getResource(name);
        }
        if (url == null && (url = this.findResource(name)) == null) {
            url = super.getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> systemUrls = null;
        if (this.system != null) {
            systemUrls = this.system.getResources(name);
        }
        Enumeration<URL> localUrls = this.findResources(name);
        Enumeration<URL> parentUrls = null;
        if (this.getParent() != null) {
            parentUrls = this.getParent().getResources(name);
        }
        final ArrayList<URL> urls = new ArrayList<URL>();
        if (systemUrls != null) {
            while (systemUrls.hasMoreElements()) {
                urls.add(systemUrls.nextElement());
            }
        }
        if (localUrls != null) {
            while (localUrls.hasMoreElements()) {
                urls.add(localUrls.nextElement());
            }
        }
        if (parentUrls != null) {
            while (parentUrls.hasMoreElements()) {
                urls.add(parentUrls.nextElement());
            }
        }
        return new Enumeration<URL>(){
            Iterator<URL> iter;
            {
                this.iter = urls.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.iter.next();
            }
        };
    }
}

