/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.internal.core.config.parsers.cli;

import com.adobe.qe.toughday.api.annotations.ConfigArgSet;
import com.adobe.qe.toughday.api.annotations.Description;
import com.adobe.qe.toughday.api.annotations.Name;
import com.adobe.qe.toughday.api.annotations.Tag;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.api.core.Publisher;
import com.adobe.qe.toughday.internal.core.ReflectionsContainer;
import com.adobe.qe.toughday.internal.core.SuiteSetup;
import com.adobe.qe.toughday.internal.core.TestSuite;
import com.adobe.qe.toughday.internal.core.config.Actions;
import com.adobe.qe.toughday.internal.core.config.ConfigParams;
import com.adobe.qe.toughday.internal.core.config.Configuration;
import com.adobe.qe.toughday.internal.core.config.ConfigurationParser;
import com.adobe.qe.toughday.internal.core.config.GlobalArgs;
import com.adobe.qe.toughday.internal.core.config.ParserArgHelp;
import com.adobe.qe.toughday.internal.core.config.PredefinedSuites;
import com.adobe.qe.toughday.internal.core.engine.Engine;
import com.adobe.qe.toughday.internal.core.engine.PublishMode;
import com.adobe.qe.toughday.internal.core.engine.RunMode;
import com.adobe.qe.toughday.metrics.Metric;
import com.google.common.base.Joiner;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CliParser
implements ConfigurationParser {
    private static final Logger LOGGER = LogManager.getLogger(CliParser.class);
    private static final String HELP_HEADER_FORMAT_WITH_TAGS = "   %-42s %-75s %-20s   %s";
    private static final String HELP_HEADER_FORMAT_NO_TAGS = "   %-42s %-75s   %s";
    private static final String TEST_CLASS_HELP_HEADER = String.format("   %-42s %-75s %-20s   %s", "Class", "Fully qualified domain name", "Tags", "Description");
    private static final String PUBLISH_CLASS_HELP_HEADER;
    private static final String METRIC_CLASS_HELP_HEADER;
    private static Method[] globalArgMethods;
    private static final String SUITE_HELP_HEADER;
    private static Map<Integer, Map<String, ConfigArgSet>> availableGlobalArgs;
    private static List<ParserArgHelp> parserArgHelps;
    public static final List<Object> parserArgs;
    public static final List<String> availableHelpOptions;
    public static final List<String> helpOptionsParameters;

    private static Object getObjectFromString(String string) {
        if (string == null) {
            return string;
        }
        try {
            GlobalArgs.parseDurationToSeconds(string);
            return string;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (NumberUtils.isNumber(string)) {
                try {
                    return Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        return Long.valueOf(string);
                    }
                    catch (NumberFormatException numberFormatException2) {
                        try {
                            return Float.valueOf(string);
                        }
                        catch (NumberFormatException numberFormatException3) {
                            try {
                                return Double.valueOf(string);
                            }
                            catch (NumberFormatException numberFormatException4) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            if (string.equals("true")) {
                return true;
            }
            if (string.equals("false")) {
                return false;
            }
            return string;
        }
    }

    private void parseAndAddProperty(String propertyAndValue, HashMap<String, Object> args) {
        String[] res = this.parseProperty(propertyAndValue);
        String propertyValueAsString = res[1];
        Object propertyValue = CliParser.getObjectFromString(propertyValueAsString);
        args.put(res[0], propertyValue);
    }

    private String[] parseProperty(String propertyAndValue) {
        String[] optionValue = propertyAndValue.split("=", 2);
        if (optionValue.length != 1 && optionValue.length != 2) {
            throw new IllegalArgumentException("Properties must have the following form: --property=value or --property. Found: " + propertyAndValue);
        }
        String prop = optionValue[0].trim();
        String val = optionValue.length == 2 ? optionValue[1] : "true";
        return new String[]{prop, val};
    }

    private HashMap<String, Object> parseObjectProperties(int startIndex, String[] cmdLineArgs) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        for (int j = startIndex; j < cmdLineArgs.length && !cmdLineArgs[j].startsWith("--"); ++j) {
            this.parseAndAddProperty(cmdLineArgs[j], args);
        }
        return args;
    }

    @Override
    public ConfigParams parse(String[] cmdLineArgs) {
        HashMap<String, Object> globalArgs = new HashMap<String, Object>();
        ConfigParams configParams = new ConfigParams();
        for (int i = 0; i < cmdLineArgs.length; ++i) {
            if (!cmdLineArgs[i].startsWith("--")) continue;
            String arg = cmdLineArgs[i].substring(2);
            if (Actions.isAction(arg)) {
                Actions action = Actions.fromString(arg);
                String identifier = cmdLineArgs[i + 1];
                HashMap<String, Object> args = this.parseObjectProperties(i + 2, cmdLineArgs);
                action.apply(configParams, identifier, args);
                continue;
            }
            if (arg.equals("publishmode")) {
                configParams.setPublishModeParams(this.parseObjectProperties(i + 1, cmdLineArgs));
                continue;
            }
            if (arg.equals("runmode")) {
                configParams.setRunModeParams(this.parseObjectProperties(i + 1, cmdLineArgs));
                continue;
            }
            String[] res = this.parseProperty(arg);
            String key = res[0];
            Object val = CliParser.getObjectFromString(res[1]);
            boolean found = false;
            for (Map<String, ConfigArgSet> args : availableGlobalArgs.values()) {
                if (!args.containsKey(key)) continue;
                found = true;
                break;
            }
            if (!(found || parserArgs.contains(key) || availableHelpOptions.contains(key) || helpOptionsParameters.contains(key) || key.equals("suite") || key.equals("suitesetup"))) {
                throw new IllegalArgumentException("Unrecognized argument --" + key);
            }
            globalArgs.put(key, val);
        }
        configParams.setGlobalParams(globalArgs);
        return configParams;
    }

    private String getSuiteSetupDescription() {
        String suiteSetupDesc = "Setup step for the test suite, where \"val\" can be: ";
        String suiteSetupList = new String();
        for (Class<? extends SuiteSetup> suiteSetupClass : ReflectionsContainer.getInstance().getSuiteSetupClasses().values()) {
            suiteSetupList = suiteSetupList + " " + suiteSetupClass.getSimpleName();
        }
        return suiteSetupDesc + (suiteSetupList.isEmpty() ? "(none)" : suiteSetupList);
    }

    public void printHelp() {
        this.printShortHelp(true);
        CliParser.printExtraHelp();
    }

    private static <T> Collection<T> unique(Collection<T> collection, boolean allowNull) {
        HashSet<T> hashSet = new HashSet<T>(collection);
        if (!allowNull) {
            hashSet.remove(null);
        }
        return hashSet;
    }

    public static void printTestClasses(TestFilter filter) {
        System.out.println();
        System.out.println("Available test classes:");
        System.out.println(TEST_CLASS_HELP_HEADER);
        for (Class<? extends AbstractTest> testClass : filter.filterTests(CliParser.unique(ReflectionsContainer.getInstance().getTestClasses().values(), false))) {
            CliParser.printClass(testClass, false, true, false);
        }
    }

    public static void printPublisherClasses() {
        System.out.println();
        System.out.println("Available publisher classes:");
        System.out.println(PUBLISH_CLASS_HELP_HEADER);
        for (Class<? extends Publisher> publisherClass : CliParser.unique(ReflectionsContainer.getInstance().getPublisherClasses().values(), false)) {
            CliParser.printClass(publisherClass, false, false, false);
        }
    }

    public static void printMetricClasses() {
        String basicMetrics = "Name, Timestamp, Passed, Failed, Skipped";
        String defaultMetrics = "Name, Timestamp, Passed, Failed, Skipped, Average, Median, StdDev, 90p, 99p, 99.9p, Min, Max";
        System.out.println();
        System.out.println("Available metric classes:");
        System.out.println(METRIC_CLASS_HELP_HEADER);
        for (Class<? extends Metric> metricClass : new HashSet<Class<? extends Metric>>(ReflectionsContainer.getInstance().getMetricClasses().values())) {
            CliParser.printClass(metricClass, false, false, false);
        }
        System.out.println();
        System.out.println("Available metric categories:");
        System.out.println(String.format(" - %-40s - %s", "BASICMetrics", "Name, Timestamp, Passed, Failed, Skipped"));
        System.out.println(String.format(" - %-40s - %s", "DEFAULTMetrics", "Name, Timestamp, Passed, Failed, Skipped, Average, Median, StdDev, 90p, 99p, 99.9p, Min, Max"));
    }

    public static void printExtraHelp() {
        CliParser.printTestClasses(new AllowAllFilter());
        CliParser.printPublisherClasses();
        CliParser.printMetricClasses();
    }

    public boolean printHelp(String[] cmdLineArgs) {
        if (cmdLineArgs.length == 0) {
            return false;
        }
        if (cmdLineArgs[0].equals("--help_full")) {
            this.printHelp();
            return true;
        }
        if (cmdLineArgs[0].equals("--help_tests")) {
            CliParser.printTestClasses(new AllowAllFilter());
            return true;
        }
        if (cmdLineArgs[0].equals("--help_publish")) {
            CliParser.printPublisherClasses();
            return true;
        }
        if (cmdLineArgs[0].equals("--help_metrics")) {
            CliParser.printMetricClasses();
            return true;
        }
        if (cmdLineArgs[0].equals("--help") && cmdLineArgs.length > 1) {
            if (ReflectionsContainer.getInstance().isTestClass(cmdLineArgs[1])) {
                Class<? extends AbstractTest> testClass = ReflectionsContainer.getInstance().getTestClass(cmdLineArgs[1]);
                System.out.println(TEST_CLASS_HELP_HEADER);
                CliParser.printClass(testClass, true, true, false);
            } else if (ReflectionsContainer.getInstance().isPublisherClass(cmdLineArgs[1])) {
                Class<? extends Publisher> publisherClass = ReflectionsContainer.getInstance().getPublisherClass(cmdLineArgs[1]);
                System.out.println(PUBLISH_CLASS_HELP_HEADER);
                CliParser.printClass(publisherClass, true, false, false);
            } else if (ReflectionsContainer.getInstance().isMetricClass(cmdLineArgs[1])) {
                Class<? extends Metric> metricClass = ReflectionsContainer.getInstance().getMetricClass(cmdLineArgs[1]);
                CliParser.printClass(metricClass, true, false, false);
            } else if (cmdLineArgs[1].startsWith("--suite=")) {
                System.out.println(SUITE_HELP_HEADER);
                CliParser.printTestSuite(new PredefinedSuites(), cmdLineArgs[1].split("=")[1], true, true);
            } else if (cmdLineArgs[1].startsWith("--tag=")) {
                CliParser.printTagHelp(cmdLineArgs[1].split("=")[1]);
            } else {
                if (cmdLineArgs[1].equals("--runmode")) {
                    if (cmdLineArgs.length < 3) {
                        throw new IllegalArgumentException("Wrong help command format.");
                    }
                    String[] tmp = cmdLineArgs[2].split("=");
                    if (!tmp[0].equals("type")) {
                        throw new IllegalArgumentException("Cannot print information about a run mode if no type is specified");
                    }
                    Class<? extends RunMode> klass = ReflectionsContainer.getInstance().getRunModeClasses().get(tmp[1]);
                    if (klass == null) {
                        throw new IllegalArgumentException("No run mode found with type: \"" + tmp[1] + "\"");
                    }
                    CliParser.printClass(klass, true, false, true);
                    return true;
                }
                if (cmdLineArgs[1].equals("--publishmode")) {
                    if (cmdLineArgs.length < 3) {
                        throw new IllegalArgumentException("Wrong help command format.");
                    }
                    String[] tmp = cmdLineArgs[2].split("=");
                    if (!tmp[0].equals("type")) {
                        throw new IllegalArgumentException("Cannot print information about a publish mode if no type is specified");
                    }
                    Class<? extends PublishMode> klass = ReflectionsContainer.getInstance().getPublishModeClasses().get(tmp[1]);
                    if (klass == null) {
                        throw new IllegalArgumentException("No publish mode found with type: \"" + tmp[1] + "\"");
                    }
                    CliParser.printClass(klass, true, false, true);
                    return true;
                }
                System.out.println("Could not find any test or publisher \"" + cmdLineArgs[1] + "\"");
            }
            return true;
        }
        for (String cmdLineArg : cmdLineArgs) {
            if (!cmdLineArg.equals("--help")) continue;
            this.printShortHelp();
            return true;
        }
        return false;
    }

    public void printShortHelp(boolean printSuitesTests) {
        Description description;
        System.out.println("Usage: java -jar toughday.jar [--help | --help_full | --help_tests | --help_publish] [<global arguments> | <actions>]");
        System.out.println("Running the jar with no parameters or '--help' prints the help.");
        System.out.println("Use '--help_full' to print full help.");
        System.out.println("Use '--help_tests' to print all the test classes.");
        System.out.println("Use '--help_publish' to print all the publisher classes.");
        System.out.println("Use '--help $TestClass/$PublisherClass' to view all configurable properties for that test/publisher");
        System.out.println("Use '--help --suite=$SuiteName' to find information about a test suite");
        System.out.println("Use '--help --tag=$Tag' to find all items that have a the specified tag");
        System.out.println("The above options can also be used with [--add extension.jar]");
        System.out.println("Use '--help --runmode/publishmode type=$Mode' to find information about a run/publish mode");
        System.out.println("\r\nExamples: \r\n");
        System.out.println("\t java -jar toughday.jar --host=localhost --port=4502");
        System.out.println("\t java -jar toughday.jar --runmode type=normal concurrency=20 --host=localhost --port=4502");
        System.out.println("\t java -jar toughday.jar --host=localhost --add extension.jar --add com.adobe.qe.toughday.tests.extensionTest");
        System.out.println("\t java -jar toughday.jar --suite=toughday --add BASICMetrics --add Average decimals=3 --exclude Failed");
        System.out.println("\r\nGlobal arguments:");
        for (Integer n : availableGlobalArgs.keySet()) {
            Map<String, ConfigArgSet> paramGroup = availableGlobalArgs.get(n);
            for (String param : paramGroup.keySet()) {
                System.out.printf("\t--%-32s\t Default: %s - %s\r\n", param + "=val", paramGroup.get(param).defaultValue(), paramGroup.get(param).desc());
            }
        }
        for (ParserArgHelp parserArgHelp : parserArgHelps) {
            System.out.printf("\t--%-32s\t Default: %s - %s\r\n", parserArgHelp.name() + "=val", parserArgHelp.defaultValue(), parserArgHelp.description());
        }
        System.out.printf("\t%-32s\t %s\r\n", "--suite=val", "Default: toughday - Where \"val\" can be one or a list (separated by commas) of the predefined suites");
        System.out.println("\r\nAvailable run modes (--runmode):");
        for (Map.Entry entry : ReflectionsContainer.getInstance().getRunModeClasses().entrySet()) {
            description = ((Class)entry.getValue()).getAnnotation(Description.class);
            System.out.printf("\ttype=%-71s %s\r\n", entry.getKey(), description != null ? description.desc() : "");
        }
        System.out.println("\r\nAvailable publish modes (--publishmode):");
        for (Map.Entry entry : ReflectionsContainer.getInstance().getPublishModeClasses().entrySet()) {
            description = ((Class)entry.getValue()).getAnnotation(Description.class);
            System.out.printf("\ttype=%-71s %s\r\n", entry.getKey(), description != null ? description.desc() : "");
        }
        System.out.println("\r\nAvailable actions:");
        for (Iterator<Object> iterator : Actions.values()) {
            System.out.printf("\t--%-71s %s\r\n", iterator.value() + " " + iterator.actionParams(), iterator.actionDescription());
        }
        CliParser.printTestSuites(new AllowAllFilter(), printSuitesTests);
    }

    private static void printTagHelp(String tag) {
        if (StringUtils.isEmpty(tag)) {
            throw new IllegalArgumentException("Tag was empty");
        }
        TagFilter tagFilter = new TagFilter(tag);
        CliParser.printTestSuites(tagFilter, false);
        CliParser.printTestClasses(tagFilter);
    }

    public void printShortHelp() {
        this.printShortHelp(false);
    }

    private static void printClassProperty(String name, boolean required, String defaultValue, String description) {
        System.out.println(String.format("\t%-32s %-64s %-32s", name + "=val" + (required ? "" : " (optional)"), defaultValue, description));
    }

    private static void printClass(Class klass, boolean printProperties, boolean printTags, boolean lowerCaseClass) {
        Annotation d;
        String name = lowerCaseClass ? klass.getSimpleName().toLowerCase() : klass.getSimpleName();
        String full_name = lowerCaseClass ? klass.getName().toLowerCase() : klass.getName();
        String desc = "";
        String tags = "";
        if (klass.isAnnotationPresent(Name.class)) {
            d = klass.getAnnotation(Name.class);
            name = name + " [" + d.name() + "]";
        }
        if (klass.isAnnotationPresent(Description.class)) {
            d = klass.getAnnotation(Description.class);
            desc = d.desc();
        }
        if (klass.isAnnotationPresent(Tag.class)) {
            Tag tag = klass.getAnnotation(Tag.class);
            tags = Joiner.on(", ").join(tag.tags());
        }
        if (!printTags) {
            System.out.println(String.format(" - %-42s %-75s - %s", name, full_name, desc));
        } else {
            System.out.println(String.format(" - %-42s %-75s %-20s - %s", name, full_name, tags, desc));
        }
        if (printProperties) {
            System.out.println();
            System.out.println(String.format("\t%-32s %-64s %-32s", "Property", "Default", "Description"));
            for (Method method : klass.getMethods()) {
                if (method.getAnnotation(ConfigArgSet.class) == null) continue;
                ConfigArgSet annotation = method.getAnnotation(ConfigArgSet.class);
                CliParser.printClassProperty(Configuration.propertyFromMethod(method.getName()), annotation.required(), annotation.defaultValue(), annotation.desc());
            }
            if (AbstractTest.class.isAssignableFrom(klass)) {
                CliParser.printClassProperty("weight", false, "1", "The weight of this test");
                CliParser.printClassProperty("timeout", false, String.valueOf(180000L), "How long a test will run before it will be interrupted and marked as failed. Expressed in seconds");
                CliParser.printClassProperty("count", false, "none", "The approximate number of times this test should run");
            }
        }
    }

    private static void printTestSuites(SuiteFilter filter, boolean withTests) {
        PredefinedSuites predefinedSuites = new PredefinedSuites();
        System.out.println("\r\nPredefined suites");
        System.out.println(SUITE_HELP_HEADER);
        for (String testSuiteName : filter.filterSuites(predefinedSuites).keySet()) {
            CliParser.printTestSuite(predefinedSuites, testSuiteName, withTests, false);
        }
    }

    private static void printTestSuite(PredefinedSuites predefinedSuites, String testSuiteName, boolean withTests, boolean withTestProperties) {
        TestSuite testSuite = (TestSuite)predefinedSuites.get(testSuiteName);
        if (testSuite == null) {
            System.out.println("Cannot find a test predefined test suite named " + testSuiteName);
            return;
        }
        System.out.println(String.format(" - %-40s %-40s - %s", testSuiteName, Joiner.on(", ").join(testSuite.getTags()), testSuite.getDescription()));
        if (withTests) {
            for (AbstractTest test : testSuite.getTests()) {
                System.out.printf("\t%-32s\r\n", test.getFullName() + " [" + test.getClass().getSimpleName() + "]");
                if (!withTestProperties) continue;
                try {
                    Engine.printObject(testSuite, System.out, test);
                }
                catch (Exception e) {
                    LOGGER.error("Exception while printing the test suite.", (Throwable)e);
                }
            }
        }
    }

    static {
        METRIC_CLASS_HELP_HEADER = PUBLISH_CLASS_HELP_HEADER = String.format(HELP_HEADER_FORMAT_NO_TAGS, "Class", "Fully qualified domain name", "Description");
        globalArgMethods = GlobalArgs.class.getMethods();
        SUITE_HELP_HEADER = String.format("   %-40s %-40s   %s", "Suite", "Tags", "Description");
        availableGlobalArgs = new HashMap<Integer, Map<String, ConfigArgSet>>();
        parserArgHelps = new ArrayList<ParserArgHelp>();
        parserArgs = new ArrayList<Object>();
        availableHelpOptions = Collections.unmodifiableList(new ArrayList<String>(){
            {
                this.add("help");
                this.add("help_full");
                this.add("help_tests");
                this.add("help_publish");
                this.add("help_metrics");
            }
        });
        helpOptionsParameters = Collections.unmodifiableList(new ArrayList<String>(){
            {
                this.add("tag");
            }
        });
        for (Method method : globalArgMethods) {
            if (method.getAnnotation(ConfigArgSet.class) == null) continue;
            ConfigArgSet annotation = method.getAnnotation(ConfigArgSet.class);
            int order = annotation.order();
            if (null == availableGlobalArgs.get(order)) {
                availableGlobalArgs.put(order, new HashMap());
            }
            Map<String, ConfigArgSet> globalArgMap = availableGlobalArgs.get(order);
            globalArgMap.put(Configuration.propertyFromMethod(method.getName()), annotation);
        }
        for (Class clazz : ReflectionsContainer.getSubTypesOf(ConfigurationParser.class)) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.getType().isAssignableFrom(ParserArgHelp.class)) continue;
                try {
                    ParserArgHelp parserArg = (ParserArgHelp)field.get(null);
                    parserArgHelps.add(parserArg);
                    parserArgs.add(parserArg.name());
                }
                catch (Exception e) {
                    throw new IllegalStateException("All parser arg help objects must be public and static", e);
                }
            }
        }
    }

    private static class AllowAllFilter
    implements TestFilter,
    SuiteFilter {
        private AllowAllFilter() {
        }

        @Override
        public Map<String, TestSuite> filterSuites(Map<String, TestSuite> testSuites) {
            return testSuites;
        }

        @Override
        public Collection<Class<? extends AbstractTest>> filterTests(Collection<Class<? extends AbstractTest>> testClasses) {
            return testClasses;
        }
    }

    private static class TagFilter
    implements TestFilter,
    SuiteFilter {
        private String tag;

        public TagFilter(String tag) {
            this.tag = tag;
        }

        @Override
        public Collection<Class<? extends AbstractTest>> filterTests(Collection<Class<? extends AbstractTest>> testClasses) {
            ArrayList<Class<? extends AbstractTest>> filteredTestClasses = new ArrayList<Class<? extends AbstractTest>>();
            for (Class<? extends AbstractTest> testClass : testClasses) {
                if (!testClass.isAnnotationPresent(Tag.class) || !Arrays.asList(testClass.getAnnotation(Tag.class).tags()).contains(this.tag)) continue;
                filteredTestClasses.add(testClass);
            }
            return filteredTestClasses;
        }

        @Override
        public Map<String, TestSuite> filterSuites(Map<String, TestSuite> testSuites) {
            HashMap<String, TestSuite> filteredTestSuites = new HashMap<String, TestSuite>();
            for (Map.Entry<String, TestSuite> entry : testSuites.entrySet()) {
                if (!entry.getValue().getTags().contains(this.tag)) continue;
                filteredTestSuites.put(entry.getKey(), entry.getValue());
            }
            return filteredTestSuites;
        }
    }

    static interface SuiteFilter {
        public Map<String, TestSuite> filterSuites(Map<String, TestSuite> var1);
    }

    static interface TestFilter {
        public Collection<Class<? extends AbstractTest>> filterTests(Collection<Class<? extends AbstractTest>> var1);
    }
}

