/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.internal.core.config.parsers.yaml;

import com.adobe.qe.toughday.internal.core.ReflectionsContainer;
import com.adobe.qe.toughday.internal.core.config.ConfigParams;
import com.adobe.qe.toughday.internal.core.config.parsers.yaml.YamlDumpAction;
import com.adobe.qe.toughday.internal.core.config.parsers.yaml.YamlDumpAddAction;
import com.adobe.qe.toughday.internal.core.config.parsers.yaml.YamlDumpConfigAction;
import com.adobe.qe.toughday.internal.core.config.parsers.yaml.YamlDumpExcludeAction;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class GenerateYamlConfiguration {
    private ConfigParams configParams;
    private Map<String, Class> itemsIdentifiers;
    private List<YamlDumpAction> yamlTestActions;
    private List<YamlDumpAction> yamlPublisherActions;
    private List<YamlDumpAction> yamlMetricActions;
    private List<YamlDumpAction> yamlExtensionActions;
    private static final String DEFAULT_YAML_CONFIGURATION_FILENAME = "toughday_";
    private static final String DEFAULT_YAML_EXTENSION = ".yaml";
    private static final SimpleDateFormat TIME_STAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");

    public GenerateYamlConfiguration(ConfigParams configParams, Map<String, Class> items) {
        this.configParams = configParams;
        this.itemsIdentifiers = items;
        this.yamlTestActions = new ArrayList<YamlDumpAction>();
        this.yamlPublisherActions = new ArrayList<YamlDumpAction>();
        this.yamlMetricActions = new ArrayList<YamlDumpAction>();
        this.yamlExtensionActions = new ArrayList<YamlDumpAction>();
        this.createActionsForItems();
    }

    public Map<String, Object> getGlobals() {
        Map<String, Object> globals = this.configParams.getGlobalParams();
        globals.remove("configfile");
        return globals;
    }

    public Map<String, Object> getPublishmode() {
        return this.configParams.getPublishModeParams();
    }

    public Map<String, Object> getRunmode() {
        return this.configParams.getRunModeParams();
    }

    public List<YamlDumpAction> getTests() {
        return this.yamlTestActions;
    }

    public List<YamlDumpAction> getPublishers() {
        return this.yamlPublisherActions;
    }

    public List<YamlDumpAction> getMetrics() {
        return this.yamlMetricActions;
    }

    public List<YamlDumpAction> getExtensions() {
        return this.yamlExtensionActions;
    }

    private void createActionsForItems() {
        for (ConfigParams.ClassMetaObject classMetaObject : this.configParams.getItemsToAdd()) {
            YamlDumpAddAction addAction = new YamlDumpAddAction(classMetaObject.getClassName(), classMetaObject.getParameters());
            if (ReflectionsContainer.getInstance().isTestClass(classMetaObject.getClassName())) {
                this.yamlTestActions.add(addAction);
                continue;
            }
            if (ReflectionsContainer.getInstance().isPublisherClass(classMetaObject.getClassName())) {
                this.yamlPublisherActions.add(addAction);
                continue;
            }
            if (ReflectionsContainer.getInstance().isMetricClass(classMetaObject.getClassName()) || classMetaObject.getClassName().equals("BASICMetrics") || classMetaObject.getClassName().equals("DEFAULTMetrics")) {
                this.yamlMetricActions.add(addAction);
                continue;
            }
            if (!classMetaObject.getClassName().endsWith(".jar")) continue;
            this.yamlExtensionActions.add(addAction);
        }
        for (ConfigParams.NamedMetaObject namedMetaObject : this.configParams.getItemsToConfig()) {
            YamlDumpConfigAction configAction = new YamlDumpConfigAction(namedMetaObject.getName(), namedMetaObject.getParameters());
            if (ReflectionsContainer.getInstance().isTestClass(this.itemsIdentifiers.get(namedMetaObject.getName()).getSimpleName())) {
                this.yamlTestActions.add(configAction);
                continue;
            }
            if (ReflectionsContainer.getInstance().isPublisherClass(this.itemsIdentifiers.get(namedMetaObject.getName()).getSimpleName())) {
                this.yamlPublisherActions.add(configAction);
                continue;
            }
            if (!ReflectionsContainer.getInstance().isMetricClass(this.itemsIdentifiers.get(namedMetaObject.getName()).getSimpleName())) continue;
            this.yamlMetricActions.add(configAction);
        }
        for (String string : this.configParams.getItemsToExclude()) {
            YamlDumpExcludeAction excludeAction = new YamlDumpExcludeAction(string);
            if (ReflectionsContainer.getInstance().isTestClass(this.itemsIdentifiers.get(string).getSimpleName())) {
                this.yamlTestActions.add(excludeAction);
                continue;
            }
            if (ReflectionsContainer.getInstance().isPublisherClass(this.itemsIdentifiers.get(string).getSimpleName())) {
                this.yamlPublisherActions.add(excludeAction);
                continue;
            }
            if (!ReflectionsContainer.getInstance().isMetricClass(this.itemsIdentifiers.get(string).getSimpleName())) continue;
            this.yamlMetricActions.add(excludeAction);
        }
    }

    private void configureYamlRepresenterToExcludeClassTags(Representer representer) {
        representer.addClassTag(GenerateYamlConfiguration.class, Tag.MAP);
        for (Class<YamlDumpAction> klass : ReflectionsContainer.getSubTypesOf(YamlDumpAction.class)) {
            representer.addClassTag(klass, Tag.MAP);
        }
    }

    public void createYamlConfigurationFile() {
        String timestamp = TIME_STAMP_FORMAT.format(new Date());
        String filename = DEFAULT_YAML_CONFIGURATION_FILENAME + timestamp + DEFAULT_YAML_EXTENSION;
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(filename);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        Constructor constructor = new Constructor(GenerateYamlConfiguration.class);
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        dumperOptions.setAllowReadOnlyProperties(true);
        Representer representer = new Representer(){

            @Override
            protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
                Method method = null;
                try {
                    method = propertyValue.getClass().getMethod("isEmpty", new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                if (method == null) {
                    return super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
                }
                try {
                    if (Boolean.valueOf(method.invoke(propertyValue, new Object[0]).toString()).booleanValue()) {
                        return null;
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                return super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
            }
        };
        this.configureYamlRepresenterToExcludeClassTags(representer);
        Yaml yaml = new Yaml(constructor, representer, dumperOptions);
        String yamlObjectRepresentation = yaml.dump(this);
        try {
            bufferedWriter.write(yamlObjectRepresentation);
            bufferedWriter.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            fileWriter.close();
            bufferedWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

