/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.internal.core.engine;

import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.api.core.MetricResult;
import com.adobe.qe.toughday.api.core.Publisher;
import com.adobe.qe.toughday.api.core.RunMap;
import com.adobe.qe.toughday.internal.core.RunMapImpl;
import com.adobe.qe.toughday.internal.core.engine.AsyncEngineWorker;
import com.adobe.qe.toughday.internal.core.engine.Engine;
import com.adobe.qe.toughday.internal.core.engine.RunMode;
import com.adobe.qe.toughday.metrics.Metric;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class AsyncResultAggregator
extends AsyncEngineWorker {
    private final Engine engine;
    private RunMode.RunContext context;

    public AsyncResultAggregator(Engine engine, RunMode.RunContext context) {
        this.engine = engine;
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean aggregateResults() {
        Collection<RunMap> localRunMaps;
        Collection<RunMap> collection = localRunMaps = this.context.getRunMaps();
        synchronized (collection) {
            for (RunMap localRunMap : localRunMaps) {
                Map<AbstractTest, Long> counts = this.engine.getPublishMode().aggregateAndReinitialize(localRunMap);
                Map<AbstractTest, AtomicLong> globalCounts = this.engine.getCounts();
                for (Map.Entry<AbstractTest, AtomicLong> entry : globalCounts.entrySet()) {
                    globalCounts.get(entry.getKey()).addAndGet(counts.get(entry.getKey()));
                }
            }
        }
        return this.context.isRunFinished();
    }

    public Map<String, List<MetricResult>> filterResults() {
        LinkedHashMap<String, List<MetricResult>> results = new LinkedHashMap<String, List<MetricResult>>();
        RunMapImpl runMap = this.engine.getGlobalRunMap();
        Collection<AbstractTest> tests = runMap.getTests();
        for (AbstractTest testInstance : tests) {
            ArrayList<MetricResult> metricResults = new ArrayList<MetricResult>();
            for (Metric metric : this.engine.getGlobalArgs().getMetrics()) {
                metricResults.add(metric.getResult(runMap.getRecord(testInstance)));
            }
            results.put(testInstance.getFullName(), metricResults);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            long elapsed = 0L;
            while (!this.isFinished()) {
                long sleepMillis = 1000L - elapsed;
                if (sleepMillis > 0L) {
                    Thread.sleep(sleepMillis);
                } else {
                    Engine.LOG.warn("Publishers are taking more than 1 second to complete. This may affect the results that you are seeing.");
                }
                long start = System.nanoTime();
                boolean testsFinished = this.aggregateResults();
                if (testsFinished) {
                    this.finishExecution();
                }
                Map<String, List<MetricResult>> results = this.filterResults();
                this.engine.getPublishMode().publish(this.engine.getGlobalRunMap().getCurrentTestResults());
                this.engine.getPublishMode().publishIntermediateResults(results);
                this.engine.getPublishMode().getGlobalRunMap().clearCurrentTestResults();
                elapsed = (System.nanoTime() - start) / 1000000L;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Engine.LOG.error("InterruptedException(s) should not reach this point", (Throwable)e);
        }
        catch (Throwable e) {
            Engine.LOG.error("Unexpected exception caught", e);
        }
        finally {
            this.stopPublishers();
        }
        this.aggregateResults();
    }

    private void stopPublishers() {
        for (Publisher publisher : this.engine.getGlobalArgs().getPublishers()) {
            publisher.finish();
        }
    }
}

