/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.internal.core.engine;

import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.internal.core.TestSuite;
import com.adobe.qe.toughday.internal.core.engine.AsyncEngineWorker;
import com.adobe.qe.toughday.internal.core.engine.AsyncTestWorker;
import com.adobe.qe.toughday.internal.core.engine.Engine;
import com.adobe.qe.toughday.internal.core.engine.RunMode;
import java.util.Collection;

public class AsyncTimeoutChecker
extends AsyncEngineWorker {
    private Engine engine;
    private final Thread mainThread;
    private RunMode.RunContext context;
    private long minTimeout;
    private TestSuite testSuite;

    public AsyncTimeoutChecker(Engine engine, TestSuite testSuite, RunMode.RunContext context, Thread mainThread) {
        this.engine = engine;
        this.mainThread = mainThread;
        this.context = context;
        this.testSuite = testSuite;
        this.minTimeout = engine.getGlobalArgs().getTimeout();
        for (AbstractTest test : testSuite.getTests()) {
            if (testSuite.getTimeout(test) == null) continue;
            this.minTimeout = Math.min(this.minTimeout, testSuite.getTimeout(test));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptWorkerIfTimeout(AsyncTestWorker worker) {
        long timeout;
        AbstractTest currentTest = worker.getCurrentTest();
        if (currentTest == null) {
            return;
        }
        Long testTimeout = this.testSuite.getTimeout(currentTest);
        long l = timeout = testTimeout != null ? testTimeout.longValue() : this.engine.getGlobalArgs().getTimeout();
        if (!worker.getMutex().tryLock()) {
            return;
        }
        try {
            if ((System.nanoTime() - worker.getLastTestStart()) / 1000000L > timeout && currentTest == worker.getCurrentTest()) {
                worker.getWorkerThread().interrupt();
            }
        }
        finally {
            worker.getMutex().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.isFinished()) {
                Collection<AsyncTestWorker> testWorkers;
                Thread.sleep(Math.round(Math.ceil((double)this.minTimeout * 0.03)));
                Collection<AsyncTestWorker> collection = testWorkers = this.context.getTestWorkers();
                synchronized (collection) {
                    for (AsyncTestWorker worker : testWorkers) {
                        this.interruptWorkerIfTimeout(worker);
                    }
                }
                if (!this.context.isRunFinished()) continue;
                this.finishExecution();
                if (!this.engine.areTestsRunning()) continue;
                this.mainThread.interrupt();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Engine.LOG.info("Timeout thread interrupted");
        }
        catch (Throwable e) {
            Engine.LOG.error("Unexpected exception caught", e);
        }
    }
}

