/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.internal.core.engine;

import com.adobe.qe.toughday.Main;
import com.adobe.qe.toughday.api.annotations.ConfigArgGet;
import com.adobe.qe.toughday.api.annotations.Setup;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.api.core.AssumptionUtils;
import com.adobe.qe.toughday.api.core.Publisher;
import com.adobe.qe.toughday.api.core.RunnersContainer;
import com.adobe.qe.toughday.internal.core.ReflectionsContainer;
import com.adobe.qe.toughday.internal.core.RunMapImpl;
import com.adobe.qe.toughday.internal.core.SuiteSetup;
import com.adobe.qe.toughday.internal.core.TestSuite;
import com.adobe.qe.toughday.internal.core.config.Configuration;
import com.adobe.qe.toughday.internal.core.config.GlobalArgs;
import com.adobe.qe.toughday.internal.core.engine.AsyncResultAggregator;
import com.adobe.qe.toughday.internal.core.engine.AsyncTimeoutChecker;
import com.adobe.qe.toughday.internal.core.engine.PublishMode;
import com.adobe.qe.toughday.internal.core.engine.RunMode;
import com.adobe.qe.toughday.metrics.Metric;
import com.adobe.qe.toughday.tests.sequential.AEMTestBase;
import com.adobe.qe.toughday.tests.utils.PackageManagerClient;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Engine {
    protected static final Logger LOG = LogManager.getLogger(Engine.class);
    public static final int RESULT_AGGREATION_DELAY = 1000;
    protected static final int WAIT_TERMINATION_FACTOR = 30;
    protected static final double TIMEOUT_CHECK_FACTOR = 0.03;
    protected static Random _rnd = new Random();
    private final Configuration configuration;
    private GlobalArgs globalArgs;
    private ExecutorService engineExecutorService = Executors.newFixedThreadPool(2);
    private Map<AbstractTest, AtomicLong> counts = new HashMap<AbstractTest, AtomicLong>();
    private final ReentrantReadWriteLock engineSync = new ReentrantReadWriteLock();
    private PublishMode publishMode;
    private RunMode runMode;
    private volatile boolean testsRunning;

    public Engine(Configuration configuration) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        this.configuration = configuration;
        this.globalArgs = configuration.getGlobalArgs();
        this.runMode = configuration.getRunMode();
        this.publishMode = configuration.getPublishMode();
        this.publishMode.setEngine(this);
        for (AbstractTest test : configuration.getTestSuite().getTests()) {
            this.add(test);
        }
    }

    public RunMapImpl getGlobalRunMap() {
        return this.publishMode.getGlobalRunMap();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public GlobalArgs getGlobalArgs() {
        return this.globalArgs;
    }

    public Map<AbstractTest, AtomicLong> getCounts() {
        return this.counts;
    }

    public PublishMode getPublishMode() {
        return this.publishMode;
    }

    public boolean areTestsRunning() {
        return this.testsRunning;
    }

    private Engine add(AbstractTest test) throws IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchMethodException {
        this.createRunners(test);
        this.addToRunMap(test);
        return this;
    }

    private Engine addToRunMap(AbstractTest test) {
        this.publishMode.getGlobalRunMap().addTest(test);
        this.counts.put(test, new AtomicLong(0L));
        if (test.includeChildren()) {
            for (AbstractTest child : test.getChildren()) {
                this.addToRunMap(child);
            }
        }
        return this;
    }

    private Engine createRunners(AbstractTest test) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        RunnersContainer.getInstance().addRunner(test);
        for (AbstractTest child : test.getChildren()) {
            this.createRunners(child);
        }
        return this;
    }

    public void runTests() {
        try {
            this.run();
        }
        catch (Exception e) {
            LOG.error("Failure in tests execution ", (Throwable)e);
        }
    }

    public static void printConfiguration(Configuration configuration, PrintStream out) throws InvocationTargetException, IllegalAccessException {
        out.println("#################### Configuration ######################");
        out.println("Global configuration:");
        Engine.printObject(configuration.getTestSuite(), out, configuration.getGlobalArgs());
        out.println("Run mode configuration: ");
        Engine.printObject(configuration.getTestSuite(), out, configuration.getRunMode());
        out.println("Publish mode configuration: ");
        Engine.printObject(configuration.getTestSuite(), out, configuration.getPublishMode());
        out.println("Tests:");
        for (AbstractTest test : configuration.getTestSuite().getTests()) {
            Engine.printObject(configuration.getTestSuite(), out, test);
        }
        out.println("Publishers:");
        for (Publisher publisher : configuration.getGlobalArgs().getPublishers()) {
            Engine.printObject(configuration.getTestSuite(), out, publisher);
        }
        out.println("Metrics:");
        for (Metric metric : configuration.getGlobalArgs().getMetrics()) {
            Engine.printObject(configuration.getTestSuite(), out, metric);
        }
        out.println("#########################################################");
    }

    public static void installToughdayContentPackage(GlobalArgs globalArgs) throws Exception {
        Engine.logGlobal("Installing ToughDay 2 Content Package...");
        PackageManagerClient packageManagerClient = AEMTestBase.createClient(globalArgs).adaptTo(PackageManagerClient.class);
        String tdContentPackageGroup = "com.adobe.qe.toughday";
        String tdContentPackageName = ReflectionsContainer.getInstance().getToughdayContentPackage();
        if (packageManagerClient.isPackageCreated(tdContentPackageName, tdContentPackageGroup)) {
            packageManagerClient.deletePackage(tdContentPackageName, tdContentPackageGroup, new int[0]);
        }
        packageManagerClient.uploadPackage(Engine.class.getClassLoader().getResourceAsStream(tdContentPackageName), tdContentPackageName);
        packageManagerClient.installPackage(tdContentPackageName, tdContentPackageGroup, new int[0]);
        Engine.logGlobal("Finished installing ToughDay 2 Content Package.");
    }

    public static void printObject(TestSuite testSuite, PrintStream out, Object obj) throws InvocationTargetException, IllegalAccessException {
        Class<?> objectClass = obj.getClass();
        out.println("- Configuration for object of class " + objectClass.getSimpleName() + " [" + objectClass.getName() + "]");
        out.println(String.format("\t%-32s %-64s", "Property", "Value"));
        for (Method method : objectClass.getMethods()) {
            if (!method.isAnnotationPresent(ConfigArgGet.class)) continue;
            ConfigArgGet configArg = method.getAnnotation(ConfigArgGet.class);
            Engine.printObjectProperty(out, StringUtils.isEmpty(configArg.name()) ? Configuration.propertyFromMethod(method.getName()) : configArg.name(), method.invoke(obj, new Object[0]));
        }
        if (AbstractTest.class.isAssignableFrom(objectClass)) {
            AbstractTest test = (AbstractTest)obj;
            Long count = testSuite.getCount(test);
            Long timeout = testSuite.getTimeout(test);
            Integer weight = testSuite.getWeightMap().get(test);
            Engine.printObjectProperty(out, "weight", weight != null ? weight : 1);
            Engine.printObjectProperty(out, "timeout", timeout != null ? timeout : 180000L);
            Engine.printObjectProperty(out, "count", count != null ? count : "none");
        }
        out.println();
        out.println();
    }

    public static void printObjectProperty(PrintStream out, String propertyName, Object propertyValue) {
        out.println(String.format("\t%-32s %-64s", propertyName, propertyValue));
    }

    public static String getCurrentDateTime() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS z").format(Calendar.getInstance().getTime());
    }

    public void runSetup(AbstractTest test) throws Exception {
        LinkedList<Object> setupMethods = new LinkedList<Object>();
        Class<?> currentClass = test.getClass();
        while (!currentClass.getName().equals(AbstractTest.class.getName())) {
            for (Method method : currentClass.getDeclaredMethods()) {
                if (method.getAnnotation(Setup.class) == null) continue;
                AssumptionUtils.validateAnnotatedMethod(method, Setup.class);
                setupMethods.addFirst(method);
            }
            currentClass = currentClass.getSuperclass();
        }
        test.benchmark().setRunMap(this.getGlobalRunMap());
        for (Method method : setupMethods) {
            method.setAccessible(true);
            method.invoke((Object)test, new Object[0]);
            method.setAccessible(false);
        }
        test.benchmark().setRunMap(null);
        for (AbstractTest abstractTest : test.getChildren()) {
            this.runSetup(abstractTest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() throws Exception {
        if (this.globalArgs.getInstallSampleContent() && !this.globalArgs.getDryRun()) {
            Engine.printConfiguration(this.configuration, new PrintStream(new LogStream(LOG)));
            Engine.installToughdayContentPackage(this.globalArgs);
        }
        Engine.logGlobal(String.format("Running tests for %s seconds or until count for all tests has been reached", this.configuration.getGlobalArgs().getDuration()));
        Engine.logGlobal("Test execution started at: " + Engine.getCurrentDateTime());
        if (this.globalArgs.getDryRun()) {
            System.out.println("NOTE: This is just a dry run. No test is actually executed.");
            Engine.printConfiguration(this.getConfiguration(), System.out);
            return;
        }
        TestSuite testSuite = this.configuration.getTestSuite();
        for (SuiteSetup setupStep : testSuite.getSetupStep()) {
            setupStep.setup();
        }
        for (AbstractTest test : testSuite.getTests()) {
            this.runSetup(test);
        }
        this.publishMode.getGlobalRunMap().reinitStartTimes();
        final AsyncResultAggregator resultAggregator = new AsyncResultAggregator(this, this.runMode.getRunContext());
        this.engineExecutorService.execute(resultAggregator);
        final AsyncTimeoutChecker timeoutChecker = new AsyncTimeoutChecker(this, this.configuration.getTestSuite(), this.runMode.getRunContext(), Thread.currentThread());
        this.engineExecutorService.execute(timeoutChecker);
        Thread shutdownHook = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    List<Thread> threadsList;
                    Engine.this.runMode.finishExecutionAndAwait();
                    String finishTime = Engine.getCurrentDateTime();
                    List<Thread> list = threadsList = AbstractTest.getExtraThreads();
                    synchronized (list) {
                        for (Thread t : threadsList) {
                            t.interrupt();
                        }
                    }
                    timeoutChecker.finishExecution();
                    resultAggregator.finishExecution();
                    resultAggregator.aggregateResults();
                    Engine.this.publishMode.publish(Engine.this.getGlobalRunMap().getCurrentTestResults());
                    Engine.this.publishMode.publishFinalResults(resultAggregator.filterResults());
                    Engine.this.shutdownAndAwaitTermination(Engine.this.runMode.getExecutorService());
                    Engine.this.shutdownAndAwaitTermination(Engine.this.engineExecutorService);
                }
                catch (Throwable e) {
                    System.out.println("Exception in shutdown hook!");
                    e.printStackTrace();
                }
                Engine.logGlobal("Test execution finished at: " + Engine.getCurrentDateTime());
                LogManager.shutdown();
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        this.testsRunning = true;
        this.runMode.runTests(this);
        try {
            Thread.sleep(this.globalArgs.getDuration() * 1000L);
        }
        catch (InterruptedException e) {
            LOG.info("Engine Interrupted", (Throwable)e);
        }
        finally {
            this.testsRunning = false;
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
            shutdownHook.run();
        }
    }

    public ReentrantReadWriteLock getEngineSync() {
        return this.engineSync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AbstractTest getNextTest(TestSuite testSuite, Map<AbstractTest, AtomicLong> counts, ReentrantReadWriteLock engineSync) throws InterruptedException {
        block8: while (testSuite.getTests().size() != 0) {
            engineSync.readLock().lock();
            try {
                int randomNumber = _rnd.nextInt(testSuite.getTotalWeight());
                for (AbstractTest test : testSuite.getTests()) {
                    int testWeight = testSuite.getWeightMap().get(test);
                    long testRuns = counts.get(test).get();
                    Long maxRuns = testSuite.getCount(test);
                    if (null != maxRuns && testRuns > maxRuns) {
                        engineSync.readLock().unlock();
                        engineSync.writeLock().lock();
                        try {
                            if (!testSuite.contains(test.getName())) continue block8;
                            testSuite.remove(test);
                            continue block8;
                        }
                        finally {
                            engineSync.writeLock().unlock();
                            engineSync.readLock().lock();
                            continue block8;
                        }
                    }
                    if (randomNumber < testWeight) {
                        AbstractTest abstractTest = test;
                        return abstractTest;
                    }
                    randomNumber -= testWeight;
                }
            }
            finally {
                engineSync.readLock().unlock();
            }
        }
        return null;
    }

    public static void logGlobal(String message) {
        LOG.info(message);
        LogManager.getLogger(Main.class).info(message);
    }

    protected void shutdownAndAwaitTermination(ExecutorService pool) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(30000L, TimeUnit.MILLISECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(30000L, TimeUnit.MILLISECONDS)) {
                    LOG.error("Thread pool did not terminate. Process must be killed");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private static class LogStream
    extends OutputStream {
        Logger logger;
        String mem = "";

        public LogStream(Logger logger) {
            this.logger = logger;
        }

        @Override
        public void write(int b) {
            byte[] bytes = new byte[]{(byte)(b & 0xFF)};
            this.mem = this.mem + new String(bytes);
            if (this.mem.endsWith("\n")) {
                this.mem = this.mem.substring(0, this.mem.length() - 1);
                this.flush();
            }
        }

        @Override
        public void flush() {
            this.logger.info(this.mem);
            this.mem = "";
        }
    }
}

