/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.internal.core.engine.runmodes;

import com.adobe.qe.toughday.api.annotations.ConfigArgGet;
import com.adobe.qe.toughday.api.annotations.ConfigArgSet;
import com.adobe.qe.toughday.api.annotations.Description;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.api.core.AbstractTestRunner;
import com.adobe.qe.toughday.api.core.RunMap;
import com.adobe.qe.toughday.api.core.RunnersContainer;
import com.adobe.qe.toughday.internal.core.engine.AsyncEngineWorker;
import com.adobe.qe.toughday.internal.core.engine.AsyncTestWorker;
import com.adobe.qe.toughday.internal.core.engine.Engine;
import com.adobe.qe.toughday.internal.core.engine.RunMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(desc="Generates a constant load of test executions, regardless of their execution time.")
public class ConstantLoad
implements RunMode {
    private static final Logger LOG = LoggerFactory.getLogger(ConstantLoad.class);
    private static final String DEFAULT_LOAD_STRING = "50";
    private static final int DEFAULT_LOAD = Integer.parseInt("50");
    private AtomicBoolean loggedWarning = new AtomicBoolean(false);
    private ExecutorService executorService = Executors.newCachedThreadPool();
    private Collection<AsyncTestWorker> testWorkers = Collections.synchronizedSet(new HashSet());
    private AsyncTestWorkerScheduler scheduler;
    private final List<RunMap> runMaps = new ArrayList<RunMap>();
    private int load = DEFAULT_LOAD;

    @ConfigArgSet(required=false, defaultValue="50", desc="Set the load, in requests per second for the \"constantload\" runmode.")
    public void setLoad(String load) {
        this.load = Integer.parseInt(load);
    }

    @ConfigArgGet
    public int getLoad() {
        return this.load;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runTests(Engine engine) throws Exception {
        for (int i = 0; i < this.load; ++i) {
            List<RunMap> list = this.runMaps;
            synchronized (list) {
                this.runMaps.add(engine.getGlobalRunMap().newInstance());
                continue;
            }
        }
        this.scheduler = new AsyncTestWorkerScheduler(engine);
        this.executorService.execute(this.scheduler);
    }

    @Override
    public RunMode.RunContext getRunContext() {
        return new RunMode.RunContext(){

            @Override
            public Collection<AsyncTestWorker> getTestWorkers() {
                return ConstantLoad.this.testWorkers;
            }

            @Override
            public Collection<RunMap> getRunMaps() {
                return ConstantLoad.this.runMaps;
            }

            @Override
            public boolean isRunFinished() {
                return ConstantLoad.this.scheduler.isFinished();
            }
        };
    }

    @Override
    public void finishExecutionAndAwait() {
        this.scheduler.finishExecution();
        for (AsyncTestWorker testWorker : this.testWorkers) {
            testWorker.finishExecution();
        }
        boolean allExited = false;
        while (!allExited) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            allExited = true;
            for (AsyncTestWorker testWorker : this.testWorkers) {
                if (testWorker.hasExited() || !testWorker.getMutex().tryLock()) continue;
                allExited = false;
                testWorker.getWorkerThread().interrupt();
                testWorker.getMutex().unlock();
            }
        }
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    private class AsyncTestWorkerScheduler
    extends AsyncEngineWorker {
        private Engine engine;

        public AsyncTestWorkerScheduler(Engine engine) {
            this.engine = engine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this.isFinished()) {
                    int i;
                    ArrayList<AbstractTest> nextRound = new ArrayList<AbstractTest>();
                    long start = System.nanoTime();
                    for (i = 0; i < ConstantLoad.this.load; ++i) {
                        AbstractTest nextTest = Engine.getNextTest(this.engine.getConfiguration().getTestSuite(), this.engine.getCounts(), this.engine.getEngineSync());
                        if (null == nextTest) {
                            LOG.info("Constant load scheduler thread finished, because there were no more tests to execute.");
                            this.finishExecution();
                            return;
                        }
                        nextRound.add(nextTest.clone());
                    }
                    for (i = 0; i < ConstantLoad.this.load && !this.isFinished(); ++i) {
                        AsyncTestWorkerImpl worker = new AsyncTestWorkerImpl((AbstractTest)nextRound.get(i), (RunMap)ConstantLoad.this.runMaps.get(i));
                        try {
                            ConstantLoad.this.executorService.execute(worker);
                        }
                        catch (OutOfMemoryError e) {
                            if (ConstantLoad.this.loggedWarning.getAndSet(true)) break;
                            LOG.warn("The desired load could not be achieved. We are creating as many threads as possible.");
                            break;
                        }
                        Collection collection = ConstantLoad.this.testWorkers;
                        synchronized (collection) {
                            ConstantLoad.this.testWorkers.add(worker);
                            continue;
                        }
                    }
                    long elapsed = System.nanoTime() - start;
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                this.finishExecution();
                LOG.warn("Constant load scheduler thread was interrupted.");
            }
        }
    }

    private class AsyncTestWorkerImpl
    extends AsyncTestWorker {
        private AbstractTest test;
        private RunMap runMap;
        private boolean exited = false;

        public AsyncTestWorkerImpl(AbstractTest test, RunMap runMap) {
            this.test = test;
            this.runMap = runMap;
        }

        @Override
        public void run() {
            this.mutex.lock();
            this.lastTestStart = System.nanoTime();
            this.workerThread = Thread.currentThread();
            this.currentTest = this.test;
            this.mutex.unlock();
            try {
                AbstractTestRunner runner = RunnersContainer.getInstance().getRunner(this.test);
                runner.runTest(this.test, this.runMap);
            }
            catch (Throwable e) {
                LOG.warn("Exceptions from tests should not reach this point", e);
            }
            this.mutex.lock();
            this.currentTest = null;
            this.exited = true;
            ConstantLoad.this.testWorkers.remove(this);
            Thread.interrupted();
            this.mutex.unlock();
        }

        @Override
        public boolean hasExited() {
            return this.exited;
        }
    }
}

