/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.internal.core.engine.runmodes;

import com.adobe.qe.toughday.api.annotations.ConfigArgGet;
import com.adobe.qe.toughday.api.annotations.ConfigArgSet;
import com.adobe.qe.toughday.api.annotations.Description;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.api.core.AbstractTestRunner;
import com.adobe.qe.toughday.api.core.RunMap;
import com.adobe.qe.toughday.api.core.RunnersContainer;
import com.adobe.qe.toughday.api.core.TestId;
import com.adobe.qe.toughday.internal.core.TestSuite;
import com.adobe.qe.toughday.internal.core.config.Configuration;
import com.adobe.qe.toughday.internal.core.config.GlobalArgs;
import com.adobe.qe.toughday.internal.core.engine.AsyncTestWorker;
import com.adobe.qe.toughday.internal.core.engine.Engine;
import com.adobe.qe.toughday.internal.core.engine.RunMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(desc="Runs tests normally.")
public class Normal
implements RunMode {
    private static final Logger LOG = LoggerFactory.getLogger(Normal.class);
    public static final String DEFAULT_CONCURRENCY_STRING = "200";
    public static final int DEFAULT_CONCURRENCY = Integer.parseInt("200");
    public static final String DEFAULT_WAIT_TIME_STRING = "300";
    public static final long DEFAULT_WAIT_TIME = Long.parseLong("300");
    private ExecutorService testsExecutorService;
    private final List<AsyncTestWorker> testWorkers = new ArrayList<AsyncTestWorker>();
    private final List<RunMap> runMaps = new ArrayList<RunMap>();
    private int concurrency = DEFAULT_CONCURRENCY;
    private long waitTime = DEFAULT_WAIT_TIME;

    @ConfigArgSet(required=false, desc="The number of concurrent threads that Tough Day will use", defaultValue="200", order=5)
    public void setConcurrency(String concurrencyString) {
        this.concurrency = Integer.parseInt(concurrencyString);
    }

    @ConfigArgSet(required=false, desc="The wait time between two consecutive test runs for a specific thread. Expressed in milliseconds", defaultValue="300", order=7)
    public void setWaitTime(String waitTime) {
        this.waitTime = Integer.parseInt(waitTime);
    }

    @ConfigArgGet
    public int getConcurrency() {
        return this.concurrency;
    }

    @ConfigArgGet
    public long getWaitTime() {
        return this.waitTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runTests(Engine engine) throws Exception {
        Configuration configuration = engine.getConfiguration();
        TestSuite testSuite = configuration.getTestSuite();
        GlobalArgs globalArgs = configuration.getGlobalArgs();
        this.testsExecutorService = Executors.newFixedThreadPool(this.concurrency);
        for (int i = 0; i < this.concurrency; ++i) {
            AsyncTestWorkerImpl testWorker = new AsyncTestWorkerImpl(engine, testSuite, engine.getGlobalRunMap().newInstance());
            try {
                this.testsExecutorService.execute(testWorker);
            }
            catch (OutOfMemoryError e) {
                LOG.warn("Could not create the required number of threads. Number of created threads : " + String.valueOf(i - 1) + ".");
                break;
            }
            List<Object> list = this.testWorkers;
            synchronized (list) {
                this.testWorkers.add(testWorker);
            }
            list = this.runMaps;
            synchronized (list) {
                this.runMaps.add(testWorker.getLocalRunMap());
                continue;
            }
        }
    }

    @Override
    public RunMode.RunContext getRunContext() {
        return new RunMode.RunContext(){

            @Override
            public Collection<AsyncTestWorker> getTestWorkers() {
                return Normal.this.testWorkers;
            }

            @Override
            public Collection<RunMap> getRunMaps() {
                return Normal.this.runMaps;
            }

            @Override
            public boolean isRunFinished() {
                for (AsyncTestWorker testWorker : Normal.this.testWorkers) {
                    if (testWorker.isFinished()) continue;
                    return false;
                }
                return true;
            }
        };
    }

    @Override
    public void finishExecutionAndAwait() {
        for (AsyncTestWorker testWorker : this.testWorkers) {
            testWorker.finishExecution();
        }
        boolean allExited = false;
        while (!allExited) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            allExited = true;
            for (AsyncTestWorker testWorker : this.testWorkers) {
                if (testWorker.hasExited() || !testWorker.getMutex().tryLock()) continue;
                allExited = false;
                testWorker.getWorkerThread().interrupt();
                testWorker.getMutex().unlock();
            }
        }
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.testsExecutorService;
    }

    private class AsyncTestWorkerImpl
    extends AsyncTestWorker {
        protected final Engine engine;
        private HashMap<TestId, AbstractTest> localTests;
        private TestSuite testSuite;
        private RunMap localRunMap;
        private boolean exited = false;

        public AsyncTestWorkerImpl(Engine engine, TestSuite testSuite, RunMap localRunMap) {
            this.engine = engine;
            this.testSuite = testSuite;
            this.localTests = new HashMap();
            for (AbstractTest test : testSuite.getTests()) {
                AbstractTest localTest = test.clone();
                this.localTests.put(localTest.getId(), localTest);
            }
            this.localRunMap = localRunMap;
        }

        @Override
        public void run() {
            this.workerThread = Thread.currentThread();
            LOG.debug("Thread running: " + this.workerThread);
            this.mutex.lock();
            try {
                while (!this.isFinished()) {
                    this.currentTest = Engine.getNextTest(this.testSuite, this.engine.getCounts(), this.engine.getEngineSync());
                    if (null == this.currentTest) {
                        LOG.info("Thread " + this.workerThread + " died! :(");
                        this.finishExecution();
                        continue;
                    }
                    this.currentTest = this.localTests.get(this.currentTest.getId());
                    AbstractTestRunner runner = RunnersContainer.getInstance().getRunner(this.currentTest);
                    this.lastTestStart = System.nanoTime();
                    this.mutex.unlock();
                    try {
                        runner.runTest(this.currentTest, this.localRunMap);
                    }
                    catch (Throwable e) {
                        LOG.warn("Exceptions from tests should not reach this point", e);
                    }
                    this.mutex.lock();
                    Thread.interrupted();
                    Thread.sleep(Normal.this.waitTime);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.error("InterruptedException(s) should not reach this point", (Throwable)e);
            }
            catch (Throwable e) {
                LOG.error("Unexpected exception caught", e);
            }
            finally {
                this.mutex.unlock();
                this.exited = true;
            }
        }

        public RunMap getLocalRunMap() {
            return this.localRunMap;
        }

        @Override
        public boolean hasExited() {
            return this.exited;
        }
    }
}

