/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.metrics;

import com.adobe.qe.toughday.api.annotations.ConfigArgGet;
import com.adobe.qe.toughday.api.annotations.ConfigArgSet;
import com.adobe.qe.toughday.api.core.MetricResult;
import com.adobe.qe.toughday.api.core.RunMap;
import com.adobe.qe.toughday.metrics.Average;
import com.adobe.qe.toughday.metrics.Failed;
import com.adobe.qe.toughday.metrics.Max;
import com.adobe.qe.toughday.metrics.Median;
import com.adobe.qe.toughday.metrics.MetricResultImpl;
import com.adobe.qe.toughday.metrics.Min;
import com.adobe.qe.toughday.metrics.Passed;
import com.adobe.qe.toughday.metrics.Percentile;
import com.adobe.qe.toughday.metrics.RealTP;
import com.adobe.qe.toughday.metrics.Skipped;
import com.adobe.qe.toughday.metrics.StdDev;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public abstract class Metric {
    protected String name = this.getClass().getSimpleName();
    protected int decimals = 6;
    private static final int DEFAULT_DECIMALS = 6;
    public static final List<Metric> basicMetrics = Collections.unmodifiableList(new ArrayList<Metric>(){
        {
            this.add(new Passed());
            this.add(new Failed());
            this.add(new Skipped());
        }
    });
    public static final List<Metric> defaultMetrics = Collections.unmodifiableList(new ArrayList<Metric>(){
        {
            this.addAll(basicMetrics);
            this.add(new Average());
            this.add(new Median());
            this.add(new StdDev());
            this.add(new Percentile().setValue("90p"));
            this.add(new Percentile().setValue("99p"));
            this.add(new Percentile().setValue("99.9p"));
            this.add(new Min());
            this.add(new Max());
            this.add(new RealTP());
        }
    });

    public MetricResult getResult(RunMap.TestStatistics testStatistics) {
        return new MetricResultImpl<Object>(this.getName(), this.getValue(testStatistics), this.getFormat(), this.getUnitOfMeasure());
    }

    public abstract Object getValue(RunMap.TestStatistics var1);

    @ConfigArgSet(required=false, desc="The name of the metric.")
    public Metric setName(String name) {
        this.name = name;
        return this;
    }

    @ConfigArgSet(required=false, desc="Number of decimals.", defaultValue="6")
    public Metric setDecimals(String decimals) {
        this.decimals = Integer.parseInt(decimals);
        return this;
    }

    @ConfigArgGet
    public String getName() {
        return this.name;
    }

    @ConfigArgGet
    public int getDecimals() {
        return this.decimals;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Metric && this.getName().equals(((Metric)o).getName());
    }

    public abstract String getFormat();

    public abstract String getUnitOfMeasure();

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.name).toHashCode();
    }
}

