/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.metrics;

import com.adobe.qe.toughday.api.annotations.ConfigArgSet;
import com.adobe.qe.toughday.api.annotations.Description;
import com.adobe.qe.toughday.api.core.RunMap;
import com.adobe.qe.toughday.metrics.Metric;

@Description(desc="Percentile.")
public class Percentile
extends Metric {
    private double value;

    @ConfigArgSet(required=true, desc="The value at which percentile will be calculated.")
    public Percentile setValue(String value) {
        this.value = Double.valueOf(value.substring(0, value.length() - 1));
        if (this.name.equals(this.getClass().getSimpleName())) {
            this.name = value + "p";
        }
        return this;
    }

    @Override
    public Object getValue(RunMap.TestStatistics testStatistics) {
        return testStatistics.getValueAtPercentile(this.value);
    }

    @Override
    public String getFormat() {
        return "%d";
    }

    @Override
    public String getUnitOfMeasure() {
        return "ms";
    }
}

