/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.publishers;

import com.adobe.qe.toughday.api.annotations.ConfigArgGet;
import com.adobe.qe.toughday.api.annotations.ConfigArgSet;
import com.adobe.qe.toughday.api.annotations.Description;
import com.adobe.qe.toughday.api.core.MetricResult;
import com.adobe.qe.toughday.api.core.Publisher;
import com.adobe.qe.toughday.api.core.benchmark.TestResult;
import com.google.gson.Gson;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(desc="Publish statistics to a csv file")
public class CSVPublisher
extends Publisher {
    private static final Logger LOG = LoggerFactory.getLogger(CSVPublisher.class);
    public static final String DEFAULT_FILE_PATH = "results.csv";
    private static final String DEFAULT_RAW_FILE_PATH = "results.raw.csv";
    private static final String RAW_FORMAT = "%s,%s,%s,%s,%s,%s,%s";
    private static final String[] RAW_HEADER = new String[]{"Name", "Status", "Thread", "Start Timestamp", "End Timestamp", "Duration", "Data"};
    private Gson GSON = new Gson();
    private String header;
    private String aggregatedFormat;
    private boolean append = true;
    private boolean created = false;
    private PrintWriter resultsPrintWriter;
    private BufferedWriter resultsWriter;
    private String filePath = "results.csv";
    private PrintWriter rawResultsWriter;
    private String rawFilePath = "results.raw.csv";

    @ConfigArgSet(required=false, desc="The filename to write results to", defaultValue="results.csv")
    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    @ConfigArgGet
    public String getFilePath() {
        return this.filePath;
    }

    @ConfigArgSet(required=false, desc="Append instead of rewrite", defaultValue="true")
    public void setAppend(String value) {
        this.append = Boolean.valueOf(value);
    }

    @ConfigArgGet
    public boolean getAppend() {
        return this.append;
    }

    @ConfigArgSet(required=false, desc="The filename to write the raw results to", defaultValue="results.raw.csv")
    public void setRawFilePath(String rawResultsFilePath) {
        this.rawFilePath = rawResultsFilePath;
    }

    @ConfigArgGet
    public String getRawFilePath() {
        return this.rawFilePath;
    }

    @Override
    @ConfigArgSet(required=false, defaultValue="false", desc="Enable the aggregated result publishing")
    public void setAggregatedPublish(String aggregatedPublish) {
        super.setAggregatedPublish(aggregatedPublish);
    }

    @Override
    protected void doPublishAggregatedIntermediate(Map<String, List<MetricResult>> results) {
        if (this.header == null) {
            this.createHeaderFormat(results.values().iterator().next());
        }
        this.publishAggregated(results);
    }

    @Override
    protected void doPublishAggregatedFinal(Map<String, List<MetricResult>> results) {
        this.publishAggregated(results);
    }

    public void publishAggregated(Map<String, List<MetricResult>> testsResults) {
        try {
            if (!this.created || !this.append) {
                this.resultsPrintWriter = new PrintWriter(this.filePath);
                this.created = true;
                this.resultsWriter = new BufferedWriter(this.resultsPrintWriter);
                this.resultsWriter.write(this.header);
                this.resultsWriter.newLine();
                this.resultsWriter.flush();
            }
            for (String testName : testsResults.keySet()) {
                ArrayList results = new ArrayList();
                List<MetricResult> testResultInfos = testsResults.get(testName);
                for (MetricResult resultInfo : testResultInfos) {
                    results.add(resultInfo.getValue());
                }
                this.resultsWriter.write(String.format(this.aggregatedFormat, results.toArray()));
                this.resultsWriter.newLine();
            }
            this.resultsWriter.flush();
            this.resultsPrintWriter.flush();
            if (!this.append) {
                this.resultsWriter.close();
                this.resultsPrintWriter.close();
            }
        }
        catch (IOException e) {
            LOG.error("Could not publish aggregated results", e);
        }
    }

    @Override
    protected void doPublishRaw(Collection<TestResult> testResults) {
        try {
            if (this.rawResultsWriter == null) {
                this.rawResultsWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.rawFilePath)));
                this.rawResultsWriter.println(String.format(RAW_FORMAT, RAW_HEADER));
            }
            for (TestResult testResult : testResults) {
                Object data = testResult.getData();
                this.rawResultsWriter.println(String.format(RAW_FORMAT, testResult.getTestFullName(), testResult.getStatus().toString(), testResult.getThreadId(), testResult.getFormattedStartTimestamp(), testResult.getFormattedEndTimestamp(), testResult.getDuration(), StringEscapeUtils.escapeCsv(data != null ? this.GSON.toJson(data) : "")));
            }
            this.rawResultsWriter.flush();
        }
        catch (IOException e) {
            LOG.error("Could not publish results", e);
        }
    }

    @Override
    public void finish() {
        this.rawResultsWriter.flush();
    }

    private void createHeaderFormat(List<MetricResult> resultsList) {
        this.header = "";
        this.aggregatedFormat = "";
        for (MetricResult resultInfo : resultsList) {
            if (!this.header.isEmpty()) {
                this.header = this.header + ",";
                this.aggregatedFormat = this.aggregatedFormat + ",";
            }
            this.header = this.header + resultInfo.getName();
            this.aggregatedFormat = this.aggregatedFormat + resultInfo.getFormat();
        }
    }
}

