/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.publishers;

import com.adobe.qe.toughday.api.annotations.ConfigArgGet;
import com.adobe.qe.toughday.api.annotations.ConfigArgSet;
import com.adobe.qe.toughday.api.annotations.Description;
import com.adobe.qe.toughday.api.core.MetricResult;
import com.adobe.qe.toughday.api.core.Publisher;
import com.adobe.qe.toughday.api.core.benchmark.TestResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(desc="Publisher for writing at standard output.")
public class ConsolePublisher
extends Publisher {
    private static final Logger LOG = LoggerFactory.getLogger(ConsolePublisher.class);
    private boolean begun = false;
    private boolean finished = false;
    private boolean clearScreen = true;
    private boolean rawPublishCalled = false;
    private final CleanerThread cleaner;
    private Scanner sc;
    private AtomicInteger extraLines;

    @Override
    @ConfigArgSet(required=false, defaultValue="false", desc="Enable the raw result publishing")
    public void setRawPublish(String rawPublish) {
        super.setRawPublish(rawPublish);
    }

    public ConsolePublisher() {
        this.setRawPublish(Boolean.FALSE.toString());
        this.sc = new Scanner(System.in);
        this.extraLines = new AtomicInteger(0);
        this.cleaner = new CleanerThread();
        this.cleaner.start();
    }

    @ConfigArgSet(required=false, defaultValue="true", desc="Clear the screen before printing each stat")
    public void setClear(String clearScreen) {
        this.clearScreen = Boolean.parseBoolean(clearScreen);
    }

    @ConfigArgGet
    public boolean getClear() {
        return this.clearScreen;
    }

    private void alignMetrics() {
        System.out.println();
        System.out.printf("%-35s", " ");
    }

    private void publishAggregated(Map<String, List<MetricResult>> results) {
        int METRIC_LENGTH = 12;
        int METRICS_PER_LINE_LIMIT = 3;
        int nrMetrics = results.values().iterator().next().size() - 1;
        int nrLinesPerTest = nrMetrics / 3 + 2;
        int nrStats = results.size() * nrLinesPerTest;
        String FORMAT = "%-37s | ";
        if (this.begun && this.clearScreen) {
            for (int i = 0; i < nrStats + this.extraLines.get(); ++i) {
                System.out.print("\u001b[1A\u001b[2K");
            }
        }
        for (String testName : results.keySet()) {
            System.out.printf("%-35.35s", testName);
            List<MetricResult> metricResults = results.get(testName);
            metricResults.remove(0);
            int metricsPerLineCounter = 0;
            for (MetricResult resultInfo : metricResults) {
                String metricIdentifier = resultInfo.getName();
                String padding = StringUtils.repeat(' ', 12 - metricIdentifier.length());
                String resultFormat = resultInfo.getFormat();
                String unitOfMeasure = resultInfo.getUnitOfMeasure();
                System.out.printf("%-37s | ", metricIdentifier + ":" + padding + String.format(resultFormat, resultInfo.getValue()) + " " + unitOfMeasure);
                if (++metricsPerLineCounter != 3) continue;
                this.alignMetrics();
                metricsPerLineCounter = 0;
            }
            System.out.println();
            System.out.println();
        }
        this.begun = true;
        this.extraLines.set(0);
    }

    @Override
    protected void doPublishAggregatedIntermediate(Map<String, List<MetricResult>> results) {
        this.publishAggregated(results);
    }

    @Override
    protected void doPublishAggregatedFinal(Map<String, List<MetricResult>> results) {
        this.clearScreen = false;
        System.out.println("********************************************************************");
        System.out.println("                       FINAL RESULTS");
        System.out.println("********************************************************************");
        this.publishAggregated(results);
    }

    @Override
    protected void doPublishRaw(Collection<TestResult> testResults) {
        if (!this.rawPublishCalled) {
            System.out.println("Raw publish is not supported in " + this.getClass().getSimpleName());
            this.rawPublishCalled = true;
        }
    }

    @Override
    public void finish() {
        this.finished = true;
        this.cleaner.interrupt();
    }

    private static String getFriendlyDuration(long millis) {
        if (millis < 0L) {
            return "0 s";
        }
        long days = TimeUnit.MILLISECONDS.toDays(millis);
        long hours = TimeUnit.MILLISECONDS.toHours(millis -= TimeUnit.DAYS.toMillis(days));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis -= TimeUnit.MINUTES.toMillis(minutes));
        StringBuilder sb = new StringBuilder(64);
        if (days > 0L) {
            sb.append(days).append(" d ");
        }
        if (hours > 0L) {
            sb.append(hours).append(" h ");
        }
        if (minutes > 0L) {
            sb.append(minutes).append(" m ");
        }
        sb.append(seconds);
        sb.append(" s");
        return sb.toString();
    }

    private void clear() {
        System.out.print("\u001b[H\u001b[2J");
        System.out.flush();
    }

    class CleanerThread
    extends Thread {
        CleanerThread() {
        }

        @Override
        public void run() {
            InputStreamReader isr = new InputStreamReader(System.in);
            BufferedReader in = new BufferedReader(isr);
            try {
                while (!ConsolePublisher.this.finished && !this.isInterrupted()) {
                    while (!in.ready()) {
                        if (ConsolePublisher.this.finished) {
                            this.interrupt();
                            break;
                        }
                        CleanerThread.sleep(200L);
                    }
                    if (ConsolePublisher.this.finished) {
                        this.interrupt();
                        break;
                    }
                    if (in.readLine() == null) continue;
                    ConsolePublisher.this.extraLines.incrementAndGet();
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

