/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.structural;

import com.adobe.qe.toughday.api.annotations.ConfigArgGet;
import com.adobe.qe.toughday.api.annotations.ConfigArgSet;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.api.core.Publisher;
import com.adobe.qe.toughday.structural.TestAnnotatedMethod;
import com.adobe.qe.toughday.structural.TestConfigGetAnnotatedMethod;
import com.adobe.qe.toughday.structural.TestConfigSetAnnotatedMethod;
import com.adobe.qe.toughday.structural.TestConstructor;
import com.adobe.qe.toughday.structural.TestTDConstraints;
import java.lang.reflect.Method;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.junit.experimental.categories.Category;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

@Category(value={TestTDConstraints.class})
public class TestSuiteStructural
extends TestCase {
    public static TestSuite suite() {
        Reflections reflections = new Reflections("", new Scanner[0]);
        TestSuite suite = new TestSuite();
        for (Class<AbstractTest> clazz : reflections.getSubTypesOf(AbstractTest.class)) {
            suite.addTest((Test)new TestConstructor("test", clazz));
            for (Method method : clazz.getDeclaredMethods()) {
                if (method.getAnnotation(ConfigArgSet.class) != null) {
                    suite.addTest((Test)new TestConfigSetAnnotatedMethod("testModifier", method));
                    suite.addTest((Test)new TestConfigSetAnnotatedMethod("testArguments", method));
                }
                if (method.getAnnotation(ConfigArgGet.class) != null) {
                    suite.addTest((Test)new TestConfigGetAnnotatedMethod("testModifier", method));
                    suite.addTest((Test)new TestConfigGetAnnotatedMethod("testArguments", method));
                }
                if (!TestAnnotatedMethod.hasAnnotation(method)) continue;
                suite.addTest((Test)new TestAnnotatedMethod("testModifier", method));
                suite.addTest((Test)new TestAnnotatedMethod("testArguments", method));
            }
        }
        for (Class<Object> clazz : reflections.getSubTypesOf(Publisher.class)) {
            suite.addTest((Test)new TestConstructor("test", clazz));
            for (Method method : clazz.getDeclaredMethods()) {
                if (method.getAnnotation(ConfigArgSet.class) != null) {
                    suite.addTest((Test)new TestConfigSetAnnotatedMethod("testModifier", method));
                    suite.addTest((Test)new TestConfigSetAnnotatedMethod("testArguments", method));
                }
                if (method.getAnnotation(ConfigArgGet.class) == null) continue;
                suite.addTest((Test)new TestConfigGetAnnotatedMethod("testModifier", method));
                suite.addTest((Test)new TestConfigGetAnnotatedMethod("testArguments", method));
            }
        }
        return suite;
    }
}

