/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.tests.composite;

import com.adobe.qe.toughday.api.annotations.ConfigArgGet;
import com.adobe.qe.toughday.api.annotations.ConfigArgSet;
import com.adobe.qe.toughday.api.annotations.Description;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.api.core.CompositeTest;
import com.adobe.qe.toughday.tests.sequential.CreatePageTreeTest;
import com.adobe.qe.toughday.tests.sequential.PublishPageTest;

@Description(desc="This test creates pages hierarchically and activates them. Each child on each level has \"base\" children. Each author thread fills in a level in the pages tree, up to base^level")
public class ActivatePagesTreeTest
extends CompositeTest {
    private CreatePageTreeTest createPageTreeTest;
    private PublishPageTest publishPageTest;

    public ActivatePagesTreeTest() {
        this(true);
    }

    public ActivatePagesTreeTest(boolean createChildren) {
        if (createChildren) {
            this.createPageTreeTest = new CreatePageTreeTest();
            this.publishPageTest = new PublishPageTest();
            this.addChild(this.createPageTreeTest);
            this.addChild(this.publishPageTest);
        }
    }

    @Override
    public AbstractTest newInstance() {
        return new ActivatePagesTreeTest(false);
    }

    @ConfigArgSet(required=false, defaultValue="toughday_tree_title", desc="The title of the page. Internally, this is incremented")
    public void setTitle(String title) {
        this.createPageTreeTest.setTitle(title);
    }

    @ConfigArgGet
    public String getTitle() {
        return this.createPageTreeTest.getTitle();
    }

    @ConfigArgSet(required=false, defaultValue="/content/toughday", desc="The path prefix for all pages.")
    public void setParentPath(String parentPath) {
        this.createPageTreeTest.setParentPath(parentPath);
    }

    @ConfigArgGet
    public String getParentPath() {
        return this.createPageTreeTest.getParentPath();
    }

    @ConfigArgSet(required=false, defaultValue="/conf/toughday-templates/settings/wcm/templates/toughday-template", desc="Template for all the pages created.")
    public void setTemplate(String template) {
        this.createPageTreeTest.setTemplate(template);
    }

    @ConfigArgGet
    public String getTemplate() {
        return this.createPageTreeTest.getTemplate();
    }

    @ConfigArgSet(required=false, desc="How many direct child pages will a page have.", defaultValue="10")
    public void setBase(String base) {
        this.createPageTreeTest.setBase(base);
    }

    @ConfigArgGet
    public int getBase() {
        return this.createPageTreeTest.getBase();
    }

    @ConfigArgSet(required=false, defaultValue="false", desc="Publish references along with the page")
    public void setWithReferences(String withReferences) {
        this.publishPageTest.setWithReferences(withReferences);
    }

    @ConfigArgGet
    public boolean getWithReferences() {
        return this.publishPageTest.getWithReferences();
    }
}

