/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.tests.composite;

import com.adobe.qe.toughday.api.annotations.ConfigArgGet;
import com.adobe.qe.toughday.api.annotations.ConfigArgSet;
import com.adobe.qe.toughday.api.annotations.Description;
import com.adobe.qe.toughday.api.annotations.Tag;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.api.core.CompositeTest;
import com.adobe.qe.toughday.tests.sequential.CreatePageTest;
import com.adobe.qe.toughday.tests.sequential.DeletePageTest;
import com.adobe.qe.toughday.tests.sequential.image.DeleteImageTest;
import com.adobe.qe.toughday.tests.sequential.image.UploadImageTest;

@Tag(tags={"author"})
@Description(desc="Authoring test. Steps: create page, upload asset, delete page, delete asset.")
public class AuthoringTest
extends CompositeTest {
    public static final String DEFAULT_PAGE_TITLE = "toughday_title";
    public static final String DEFAULT_ASSET_NAME = "toughday_png_asset";
    public static final String DEFAULT_MIME_TYPE = "image/png";
    public static final String DEFAULT_RESOURCE_PATH = "image.png";
    private CreatePageTest createPageTest;
    private UploadImageTest uploadAssetTest;
    private DeletePageTest deletePageTest;
    private DeleteImageTest deleteAssetTest;

    public AuthoringTest() {
        this(true);
    }

    public AuthoringTest(boolean createChildren) {
        if (createChildren) {
            this.createPageTest = new CreatePageTest();
            this.createPageTest.setGlobalArgs(this.getGlobalArgs());
            this.uploadAssetTest = new UploadImageTest();
            this.uploadAssetTest.setGlobalArgs(this.getGlobalArgs());
            this.deletePageTest = new DeletePageTest();
            this.deletePageTest.setGlobalArgs(this.getGlobalArgs());
            this.deleteAssetTest = new DeleteImageTest();
            this.deleteAssetTest.setGlobalArgs(this.getGlobalArgs());
            this.addChild(this.createPageTest);
            this.addChild(this.uploadAssetTest);
            this.addChild(this.deletePageTest);
            this.addChild(this.deleteAssetTest);
            this.deletePageTest.setForce(Boolean.toString(true));
            this.deleteAssetTest.setForce(Boolean.toString(true));
            this.setPageTitle(DEFAULT_PAGE_TITLE);
            this.setPageTemplate("/conf/toughday-templates/settings/wcm/templates/toughday-template");
            this.setParentPath("/content/toughday");
            this.setImageName(DEFAULT_ASSET_NAME);
            this.setMimeType(DEFAULT_MIME_TYPE);
            this.setResourcePath(DEFAULT_RESOURCE_PATH);
        }
    }

    @Override
    public AbstractTest newInstance() {
        return new AuthoringTest(false);
    }

    @ConfigArgSet(required=false, defaultValue="/conf/toughday-templates/settings/wcm/templates/toughday-template")
    public AuthoringTest setPageTemplate(String template) {
        this.createPageTest.setTemplate(template);
        return this;
    }

    @ConfigArgGet
    public String getPageTemplate() {
        return this.createPageTest.getTemplate();
    }

    @ConfigArgSet(required=false, defaultValue="/content/toughday", desc="The path prefix for all pages.")
    public AuthoringTest setParentPath(String parentPath) {
        this.createPageTest.setParentPath(parentPath);
        this.deletePageTest.setParentPath(parentPath);
        this.uploadAssetTest.setParentPath(parentPath);
        this.deleteAssetTest.setParentPath(parentPath);
        return this;
    }

    @ConfigArgGet
    public String getParentPath() {
        return this.createPageTest.getTemplate();
    }

    @ConfigArgSet(required=false, defaultValue="image.png")
    public AuthoringTest setResourcePath(String resourcePath) {
        this.uploadAssetTest.setResourcePath(resourcePath);
        return this;
    }

    @ConfigArgGet
    public String getResourcePath() {
        return this.uploadAssetTest.getResourcePath();
    }

    @ConfigArgSet(required=false, defaultValue="image/png")
    public AuthoringTest setMimeType(String mimeType) {
        this.uploadAssetTest.setMimeType(mimeType);
        return this;
    }

    @ConfigArgGet
    public String getMimeType() {
        return this.uploadAssetTest.getMimeType();
    }

    @ConfigArgSet(required=false, defaultValue="toughday_title", desc="The title of the page. Internally, this is incremented")
    public AuthoringTest setPageTitle(String title) {
        this.createPageTest.setTitle(title);
        this.deletePageTest.setTitle(title);
        return this;
    }

    @ConfigArgGet
    public String getPageTitle() {
        return this.createPageTest.getTitle();
    }

    @ConfigArgSet(required=false, defaultValue="toughday_png_asset")
    public AuthoringTest setImageName(String name) {
        this.uploadAssetTest.setFileName(name);
        this.deleteAssetTest.setTitle(name);
        return this;
    }

    @ConfigArgGet
    public String getImageName() {
        return this.uploadAssetTest.getFileName();
    }
}

