/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.tests.composite;

import com.adobe.qe.toughday.api.annotations.ConfigArgGet;
import com.adobe.qe.toughday.api.annotations.ConfigArgSet;
import com.adobe.qe.toughday.api.annotations.Description;
import com.adobe.qe.toughday.api.annotations.Tag;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.api.core.CompositeTest;
import com.adobe.qe.toughday.tests.sequential.CreatePageTreeTest;
import com.adobe.qe.toughday.tests.sequential.image.UploadImageTest;

@Tag(tags={"author"})
@Description(desc="Authoring test. Steps: create page, upload asset.")
public class AuthoringTreeTest
extends CompositeTest {
    public static final String DEFAULT_PAGE_TITLE = "toughday_tree_title";
    public static final String DEFAULT_ASSET_NAME = "toughday_png_asset";
    public static final String DEFAULT_MIME_TYPE = "image/png";
    public static final String DEFAULT_RESOURCE_PATH = "image.png";
    private CreatePageTreeTest createPageTest;
    private UploadImageTest uploadImageTest;

    public AuthoringTreeTest() {
        this(true);
    }

    public AuthoringTreeTest(boolean createChildren) {
        if (createChildren) {
            this.createPageTest = new CreatePageTreeTest();
            this.createPageTest.setGlobalArgs(this.getGlobalArgs());
            this.uploadImageTest = new UploadImageTest();
            this.uploadImageTest.setGlobalArgs(this.getGlobalArgs());
            this.addChild(this.createPageTest);
            this.addChild(this.uploadImageTest);
            this.setPageTitle(DEFAULT_PAGE_TITLE);
            this.setImageName(DEFAULT_ASSET_NAME);
            this.setMimeType(DEFAULT_MIME_TYPE);
            this.setResourcePath(DEFAULT_RESOURCE_PATH);
        }
    }

    @Override
    public AbstractTest newInstance() {
        return new AuthoringTreeTest(false);
    }

    @ConfigArgSet(required=false, defaultValue="/conf/toughday-templates/settings/wcm/templates/toughday-template")
    public AuthoringTreeTest setPageTemplate(String template) {
        this.createPageTest.setTemplate(template);
        return this;
    }

    @ConfigArgGet
    public String getPageTemplate() {
        return this.createPageTest.getTemplate();
    }

    @ConfigArgSet(required=false, defaultValue="/content/toughday", desc="The path prefix for all pages.")
    public AuthoringTreeTest setParentPath(String parentPath) {
        this.createPageTest.setParentPath(parentPath);
        this.uploadImageTest.setParentPath(parentPath);
        return this;
    }

    @ConfigArgGet
    public String getParentPath() {
        return this.createPageTest.getParentPath();
    }

    @ConfigArgSet(required=false, defaultValue="image.png")
    public AuthoringTreeTest setResourcePath(String resourcePath) {
        this.uploadImageTest.setResourcePath(resourcePath);
        return this;
    }

    @ConfigArgGet
    public String getResourcePath() {
        return this.uploadImageTest.getResourcePath();
    }

    @ConfigArgSet(required=false, defaultValue="image/png")
    public AuthoringTreeTest setMimeType(String mimeType) {
        this.uploadImageTest.setMimeType(mimeType);
        return this;
    }

    @ConfigArgGet
    public String getMimeType() {
        return this.uploadImageTest.getMimeType();
    }

    @ConfigArgSet(required=false, defaultValue="toughday_tree_title", desc="The title of the page. Internally, this is incremented")
    public AuthoringTreeTest setPageTitle(String title) {
        this.createPageTest.setTitle(title);
        return this;
    }

    @ConfigArgGet
    public String getPageTitle() {
        return this.createPageTest.getTitle();
    }

    @ConfigArgSet(required=false, defaultValue="toughday_png_asset")
    public AuthoringTreeTest setImageName(String name) {
        this.uploadImageTest.setFileName(name);
        return this;
    }

    @ConfigArgGet
    public String getImageName() {
        return this.uploadImageTest.getFileName();
    }

    @ConfigArgSet(required=false, defaultValue="10")
    public AuthoringTreeTest setBase(String base) {
        this.createPageTest.setBase(base);
        return this;
    }

    @ConfigArgGet
    public int getBase() {
        return this.createPageTest.getBase();
    }
}

