/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.tests.composite;

import com.adobe.qe.toughday.api.annotations.ConfigArgGet;
import com.adobe.qe.toughday.api.annotations.ConfigArgSet;
import com.adobe.qe.toughday.api.annotations.Description;
import com.adobe.qe.toughday.api.annotations.Tag;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.api.core.CompositeTest;
import com.adobe.qe.toughday.tests.sequential.CreateFolderTreeTest;
import com.adobe.qe.toughday.tests.sequential.image.UploadImageTest;

@Tag(tags={"author"})
@Description(desc="This test creates folders with assets hierarchically. Each child on each level has \"base\" folder children and \"base\" asset children")
public class CreateAssetTreeTest
extends CompositeTest {
    private CreateFolderTreeTest createFolderTreeTest;
    private UploadImageTest uploadImageTest;

    public CreateAssetTreeTest() {
        this(true);
    }

    public CreateAssetTreeTest(boolean createChildren) {
        if (createChildren) {
            this.createFolderTreeTest = new CreateFolderTreeTest();
            this.uploadImageTest = new UploadImageTest();
            this.createFolderTreeTest.setGlobalArgs(this.getGlobalArgs());
            this.uploadImageTest.setGlobalArgs(this.getGlobalArgs());
            this.addChild(this.createFolderTreeTest);
            this.addChild(this.uploadImageTest);
        }
    }

    @Override
    public AbstractTest newInstance() {
        return new CreateAssetTreeTest(false);
    }

    @ConfigArgSet(required=false, defaultValue="toughday", desc="The title of the folders. Internally, this is incremented")
    public CreateAssetTreeTest setFolderTitle(String title) {
        this.createFolderTreeTest.setTitle(title);
        return this;
    }

    @ConfigArgGet
    public String getFolderTitle() {
        return this.createFolderTreeTest.getTitle();
    }

    @ConfigArgSet(required=false, defaultValue="toughday_png_asset", desc="The title of the assets. Internally, this is incremented")
    public CreateAssetTreeTest setAssetTitle(String title) {
        this.uploadImageTest.setFileName(title);
        return this;
    }

    @ConfigArgGet
    public String getAssetTitle() {
        return this.uploadImageTest.getFileName();
    }

    @ConfigArgSet(required=false, defaultValue="/content/dam/toughday", desc="The path prefix for the asset tree.")
    public CreateAssetTreeTest setParentPath(String parentPath) {
        this.createFolderTreeTest.setParentPath(parentPath);
        return this;
    }

    @ConfigArgGet
    public String getParentPath() {
        return this.createFolderTreeTest.getParentPath();
    }

    @ConfigArgSet(required=false, defaultValue="image.png", desc="The image resource path either in the classpath or the filesystem")
    public void setAssetResourcePath(String resourcePath) {
        this.uploadImageTest.setResourcePath(resourcePath);
    }

    @ConfigArgGet
    public String getAssetResourcePath() {
        return this.uploadImageTest.getResourcePath();
    }

    @ConfigArgSet(required=false, defaultValue="10")
    public CreateAssetTreeTest setBase(String base) {
        this.createFolderTreeTest.setBase(base);
        return this;
    }

    @ConfigArgGet
    public int getBase() {
        return this.createFolderTreeTest.getBase();
    }
}

