/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.tests.composite;

import com.adobe.qe.toughday.api.annotations.ConfigArgGet;
import com.adobe.qe.toughday.api.annotations.ConfigArgSet;
import com.adobe.qe.toughday.api.annotations.Description;
import com.adobe.qe.toughday.api.annotations.Tag;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.api.core.CompositeTest;
import com.adobe.qe.toughday.tests.sequential.CreateFolderTreeTest;
import com.adobe.qe.toughday.tests.sequential.UploadPDFTest;

@Tag(tags={"author"})
@Description(desc="This test creates folders and PDFs hierarchically. Each child on each level has \"base\" folder children and \"base\" asset children")
public class CreatePDFTreeTest
extends CompositeTest {
    private CreateFolderTreeTest createFolderTreeTest;
    private UploadPDFTest uploadPDFTest;

    public CreatePDFTreeTest() {
        this(true);
    }

    public CreatePDFTreeTest(boolean createChildren) {
        if (createChildren) {
            this.createFolderTreeTest = new CreateFolderTreeTest();
            try {
                this.uploadPDFTest = new UploadPDFTest();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.createFolderTreeTest.setGlobalArgs(this.getGlobalArgs());
            this.uploadPDFTest.setGlobalArgs(this.getGlobalArgs());
            this.addChild(this.createFolderTreeTest);
            this.addChild(this.uploadPDFTest);
        }
    }

    @Override
    public AbstractTest newInstance() {
        return new CreatePDFTreeTest(false);
    }

    @ConfigArgSet(required=false, defaultValue="toughday", desc="The title of the folders. Internally, this is incremented")
    public AbstractTest setFolderTitle(String title) {
        this.createFolderTreeTest.setTitle(title);
        return this;
    }

    @ConfigArgGet
    public String getFolderTitle() {
        return this.createFolderTreeTest.getTitle();
    }

    @ConfigArgSet(required=false, defaultValue="toughday_pdf_asset", desc="The title of the PDF. Internally, this is incremented")
    public AbstractTest setPDFTitle(String title) {
        this.uploadPDFTest.setFileName(title);
        return this;
    }

    @ConfigArgGet
    public String getPDFTitle() {
        return this.uploadPDFTest.getFileName();
    }

    @ConfigArgSet(required=false, defaultValue="/content/dam/toughday", desc="The path prefix for the PDF tree.")
    public AbstractTest setParentPath(String parentPath) {
        this.createFolderTreeTest.setParentPath(parentPath);
        return this;
    }

    @ConfigArgGet
    public String getParentPath() {
        return this.createFolderTreeTest.getParentPath();
    }

    @ConfigArgSet(required=false, defaultValue="document.pdf", desc="The PDF resource path either in the classpath or the filesystem")
    public void setPDFResourcePath(String resourcePath) {
        this.uploadPDFTest.setResourcePath(resourcePath);
    }

    @ConfigArgGet
    public String getPDFResourcePath() {
        return this.uploadPDFTest.getResourcePath();
    }

    @ConfigArgSet(required=false, defaultValue="10")
    public void setBase(String base) {
        this.createFolderTreeTest.setBase(base);
    }

    @ConfigArgGet
    public int getBase() {
        return this.createFolderTreeTest.getBase();
    }
}

