/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.tests.composite;

import com.adobe.qe.toughday.api.annotations.ConfigArgGet;
import com.adobe.qe.toughday.api.annotations.ConfigArgSet;
import com.adobe.qe.toughday.api.annotations.Description;
import com.adobe.qe.toughday.api.annotations.Tag;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.api.core.CompositeTest;
import com.adobe.qe.toughday.tests.sequential.CreatePageTreeTest;
import com.adobe.qe.toughday.tests.sequential.tags.AddTagToResourceTest;
import com.adobe.qe.toughday.tests.sequential.tags.CreateTagTreeTest;

@Tag(tags={"author"})
@Description(desc="This test creates tags and pages hierarchically. Each page gets assigned two tags. One from the corresponding node in the tag tree and one that is the same for the whole page tree. Each child on each level has \"base\" children. Each author thread fills in a level in the tag tree, up to base^level")
public class CreateTaggedPagesTree
extends CompositeTest {
    private CreateTagTreeTest createTagTreeTest;
    private CreatePageTreeTest createPageTreeTest;
    private AddTagToResourceTest addTagToResourceTest;

    public CreateTaggedPagesTree() {
        this(true);
    }

    public CreateTaggedPagesTree(boolean createChildren) {
        if (createChildren) {
            this.createTagTreeTest = new CreateTagTreeTest();
            this.createPageTreeTest = new CreatePageTreeTest();
            this.addTagToResourceTest = new AddTagToResourceTest();
            this.createTagTreeTest.setGlobalArgs(this.getGlobalArgs());
            this.createPageTreeTest.setGlobalArgs(this.getGlobalArgs());
            this.addTagToResourceTest.setGlobalArgs(this.getGlobalArgs());
            this.addChild(this.createTagTreeTest);
            this.addChild(this.createPageTreeTest);
            this.addChild(this.addTagToResourceTest);
        }
    }

    @Override
    public AbstractTest newInstance() {
        return new CreateTaggedPagesTree(false);
    }

    @ConfigArgSet(required=false, defaultValue="toughday_tree_title", desc="The title of the page. Internally, this is incremented")
    public AbstractTest setPageTitle(String title) {
        this.createPageTreeTest.setTitle(title);
        return this;
    }

    @ConfigArgGet
    public String getPageTitle() {
        return this.createPageTreeTest.getTitle();
    }

    @ConfigArgSet(required=false, defaultValue="/content/toughday", desc="The path prefix for all pages.")
    public AbstractTest setParentPath(String parentPath) {
        this.createPageTreeTest.setParentPath(parentPath);
        return this;
    }

    @ConfigArgGet
    public String getParentPath() {
        return this.createPageTreeTest.getParentPath();
    }

    @ConfigArgSet(required=false, defaultValue="/conf/toughday-templates/settings/wcm/templates/toughday-template", desc="The title of the pages. Internally, this will be incremented")
    public AbstractTest setTemplate(String template) {
        this.createPageTreeTest.setTemplate(template);
        return this;
    }

    @ConfigArgGet
    public String getTemplate() {
        return this.createPageTreeTest.getTemplate();
    }

    @ConfigArgSet(required=false, defaultValue="ToughDay", desc="The title of the tags. Internally, this will be incremented")
    public AbstractTest setTagTitle(String title) {
        this.createTagTreeTest.setTitle(title);
        return this;
    }

    @ConfigArgGet
    public String getTagTitle() {
        return this.createTagTreeTest.getTitle();
    }

    @ConfigArgSet(required=false, defaultValue="10")
    public AbstractTest setBase(String base) {
        this.createPageTreeTest.setBase(base);
        this.createTagTreeTest.setBase(base);
        return this;
    }

    @ConfigArgGet
    public int getBase() {
        return this.createPageTreeTest.getBase();
    }
}

