/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.tests.sequential;

import com.adobe.qe.toughday.api.core.SequentialTest;
import com.adobe.qe.toughday.api.core.config.GlobalArgs;
import com.adobe.qe.toughday.tests.utils.SlingClientsProxyFactory;
import java.net.URI;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.ssl.SSLContexts;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.interceptors.FormBasedAuthInterceptor;

public abstract class AEMTestBase
extends SequentialTest {
    private SlingClient defaultClient;

    public AEMTestBase() {
        this.benchmark().registerHierarchyProxyFactory(SlingClient.class, new SlingClientsProxyFactory());
    }

    public SlingClient getDefaultClient() throws Exception {
        if (this.defaultClient == null) {
            this.defaultClient = AEMTestBase.createClient(this.getGlobalArgs());
        }
        return this.defaultClient;
    }

    public static SlingClient.Builder createClientBuilder(GlobalArgs args) throws Exception {
        URIBuilder uriBuilder = new URIBuilder().setScheme(args.getProtocol()).setHost(args.getHost()).setPort(args.getPort());
        if (args.getContextPath() != null) {
            URI cp = URI.create("/").resolve(args.getContextPath());
            uriBuilder.setPath(cp.getPath());
        }
        SlingClient.Builder builder = SlingClient.Builder.create(uriBuilder.build(), args.getUser(), args.getPassword());
        if (!args.getHostValidationEnabled()) {
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, new TrustSelfSignedStrategy()).build();
            SSLConnectionSocketFactory sslFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)new NoopHostnameVerifier());
            builder.httpClientBuilder().setSSLSocketFactory(sslFactory);
        }
        if (!args.getAuthMethod().equals("basic")) {
            if (args.getAuthMethod().equals("login-token")) {
                Registry<AuthSchemeProvider> authSchemeRegistry = RegistryBuilder.create().build();
                builder.httpClientBuilder().setDefaultAuthSchemeRegistry(authSchemeRegistry);
                builder.setPreemptiveAuth(false).addInterceptorFirst(new FormBasedAuthInterceptor("login-token"));
            } else {
                throw new IllegalArgumentException("Unsupported authentication method: " + args.getAuthMethod());
            }
        }
        return builder;
    }

    public static SlingClient createClient(GlobalArgs args) throws Exception {
        return AEMTestBase.createClientBuilder(args).build();
    }

    public static SlingClient.Builder createClientBuilder(GlobalArgs args, String user, String password) throws Exception {
        SlingClient.Builder builder = AEMTestBase.createClientBuilder(args);
        builder.setUser(user);
        builder.setPassword(password);
        return builder;
    }
}

