/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.tests.sequential;

import com.adobe.qe.toughday.api.annotations.After;
import com.adobe.qe.toughday.api.annotations.Before;
import com.adobe.qe.toughday.api.annotations.ConfigArgGet;
import com.adobe.qe.toughday.api.annotations.ConfigArgSet;
import com.adobe.qe.toughday.api.annotations.Description;
import com.adobe.qe.toughday.api.annotations.Name;
import com.adobe.qe.toughday.api.annotations.Setup;
import com.adobe.qe.toughday.api.annotations.Tag;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.api.core.FluentLogging;
import com.adobe.qe.toughday.tests.sequential.AEMTestBase;
import com.adobe.qe.toughday.tests.utils.TreePhaser;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.logging.log4j.Level;
import org.apache.sling.testing.clients.util.FormEntityBuilder;

@Tag(tags={"author"})
@Name(name="create_folder_tree")
@Description(desc="This test creates folders hierarchically. Each child on each level has \"base\" children. Each author thread fills in a level in the folder tree, up to base^level")
public class CreateFolderTreeTest
extends AEMTestBase {
    public static final String FOLDER_RESOURCE_TYPE = "sling:Folder";
    public static final String DEFAULT_PARENT_PATH = "/content/dam/toughday";
    public static final String DEFAULT_TITLE = "toughday";
    private TreePhaser phaser;
    private String rootParentPath = "/content/dam/toughday";
    private String title = "toughday";
    private String resourceType = "sling:Folder";
    private int nextChild;
    private String parentPath;
    private String nodeName;
    private boolean failed = false;

    public CreateFolderTreeTest() {
        this.phaser = new TreePhaser();
        AbstractTest.addExtraThread(this.phaser.mon);
    }

    protected CreateFolderTreeTest(TreePhaser phaser, String parentPath, String title, String resourceType) {
        this.phaser = phaser;
        this.rootParentPath = parentPath;
        this.title = title;
        this.resourceType = resourceType;
    }

    @Setup
    private void setup() {
        try {
            String isolatedRoot = "tree_" + RandomStringUtils.randomAlphanumeric(5);
            this.createFolder(isolatedRoot, this.rootParentPath + "/");
            this.rootParentPath = this.rootParentPath + "/" + isolatedRoot;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Before
    private void before() {
        this.phaser.register();
        this.nextChild = this.phaser.getNextNode();
        this.parentPath = this.rootParentPath + TreePhaser.computeParentPath(this.nextChild, this.phaser.getLevel(), this.phaser.getBase(), this.title);
        this.nodeName = TreePhaser.computeNodeName(this.nextChild, this.phaser.getBase(), this.title);
        this.failed = false;
    }

    @Override
    public void test() throws Throwable {
        FluentLogging.create(this.logger()).before(Level.DEBUG, "{}: Trying to create folder={}{}", Thread.currentThread().getId(), this.parentPath, this.nodeName).onThrowable(Level.WARN, "{}: Failed to create folder={}{}", Thread.currentThread().getId(), this.parentPath, this.nodeName).onThrowable(Level.DEBUG, Thread.currentThread().getId() + "ERROR: ", true).run(() -> this.createFolder());
    }

    @After
    private void after() {
        for (int i = 0; i < 5; ++i) {
            try {
                if (!this.failed || this.benchmark().measure((AbstractTest)this, "Check Folder Created", this.getDefaultClient()).exists(this.parentPath + this.nodeName)) {
                    this.logger().debug("{}: Successfully created folder={}{}", (Object)Thread.currentThread().getId(), (Object)this.parentPath, (Object)this.nodeName);
                    break;
                }
                this.logger().debug("{}: Retrying to create folder={}{}", (Object)Thread.currentThread().getId(), (Object)this.parentPath, (Object)this.nodeName);
                this.createFolder();
                continue;
            }
            catch (Throwable e) {
                this.logger().warn("{}: Failed to create after retry folder={}{}", (Object)Thread.currentThread().getId(), (Object)this.parentPath, (Object)this.nodeName);
                this.logger().debug(Thread.currentThread().getId() + "ERROR: ", e);
            }
        }
        this.communicate("parentPath", this.parentPath);
        this.phaser.arriveAndDeregister();
    }

    private void createFolder() throws Throwable {
        this.createFolder(this.nodeName, this.parentPath);
    }

    private void createFolder(String nodeName, String parentPath) throws Throwable {
        FormEntityBuilder feb = FormEntityBuilder.create().addParameter(":name", nodeName).addParameter("./jcr:primaryType", this.resourceType);
        this.benchmark().measure((AbstractTest)this, "Create Folder", this.getDefaultClient()).doPost(parentPath, (HttpEntity)feb.build(), 201);
    }

    @Override
    public AbstractTest newInstance() {
        return new CreateFolderTreeTest(this.phaser, this.rootParentPath, this.title, this.resourceType);
    }

    @ConfigArgSet(required=false, defaultValue="toughday", desc="The title of the page. Internally, this is incremented")
    public AbstractTest setTitle(String title) {
        this.title = title.toLowerCase();
        return this;
    }

    @ConfigArgGet
    public String getTitle() {
        return this.title;
    }

    @ConfigArgSet(required=false, defaultValue="/content/dam/toughday", desc="The path prefix for all pages.")
    public AbstractTest setParentPath(String parentPath) {
        this.rootParentPath = StringUtils.stripEnd(parentPath, "/");
        return this;
    }

    @ConfigArgGet
    public String getParentPath() {
        return this.rootParentPath;
    }

    @ConfigArgSet(required=false, desc="How many direct child folders will a folder have.", defaultValue="10")
    public AbstractTest setBase(String base) {
        this.phaser.setBase(Integer.parseInt(base));
        return this;
    }

    @ConfigArgGet
    public int getBase() {
        return this.phaser.getBase();
    }

    @ConfigArgSet(required=false, desc="Reasource type for folders.", defaultValue="sling:Folder")
    public AbstractTest setResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @ConfigArgGet
    public String getResourceType() {
        return this.resourceType;
    }
}

