/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.tests.sequential;

import com.adobe.qe.toughday.api.annotations.ConfigArgGet;
import com.adobe.qe.toughday.api.annotations.ConfigArgSet;
import com.adobe.qe.toughday.api.annotations.Description;
import com.adobe.qe.toughday.api.annotations.Tag;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.tests.sequential.AEMTestBase;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.sling.testing.clients.util.FormEntityBuilder;

@Tag(tags={"author"})
@Description(desc="This test creates pages under the same parent path. Due to OAK limitations, performance will decrease over time. If you are not looking for this specific scenario, please consider using CreatePageTreeTest.")
public class CreatePageTest
extends AEMTestBase {
    private String rootParentPath = "/content/toughday";
    private String template = "/conf/toughday-templates/settings/wcm/templates/toughday-template";
    private String title = "toughday_title";
    public static ThreadLocal<String> lastCreated = new ThreadLocal();
    public static final AtomicInteger nextNumber = new AtomicInteger(0);
    public static final String CMD_CREATE_PAGE = "createPage";
    public static final String DEFAULT_PARENT_PATH = "/content/toughday";
    public static final String DEFAULT_TEMPLATE = "/conf/toughday-templates/settings/wcm/templates/toughday-template";

    public CreatePageTest() {
    }

    protected CreatePageTest(String parentPath, String template, String title) {
        this.rootParentPath = parentPath;
        this.template = template;
        this.title = title;
    }

    @Override
    public void test() throws Throwable {
        String nextTitle = this.title + nextNumber.getAndIncrement();
        lastCreated.set(nextTitle);
        FormEntityBuilder feb = FormEntityBuilder.create().addParameter("cmd", CMD_CREATE_PAGE).addParameter("parentPath", this.rootParentPath).addParameter("title", nextTitle).addParameter("template", this.template);
        try {
            this.logger().debug("{}: Trying to create page={}{}, with template={}", (Object)Thread.currentThread().getId(), (Object)this.rootParentPath, (Object)nextTitle, (Object)this.template);
            this.benchmark().measure((AbstractTest)this, "Create Page", this.getDefaultClient()).doPost("/bin/wcmcommand", (HttpEntity)feb.build(), 200);
        }
        catch (Throwable e) {
            this.logger().warn("{}: Failed to create page={}{}, with template={}", (Object)Thread.currentThread().getId(), (Object)this.rootParentPath, (Object)nextTitle, (Object)this.template);
            this.logger().debug(Thread.currentThread().getName() + "ERROR: ", e);
            throw e;
        }
        this.logger().debug("{}: Successfully created page={}{}, with template={}", (Object)Thread.currentThread().getId(), (Object)this.rootParentPath, (Object)nextTitle, (Object)this.template);
    }

    @Override
    public AbstractTest newInstance() {
        return new CreatePageTest(this.rootParentPath, this.template, this.title);
    }

    @ConfigArgSet(required=false, defaultValue="toughday_title", desc="The title of the page. Internally, this is incremented")
    public AbstractTest setTitle(String title) {
        this.title = title.toLowerCase();
        return this;
    }

    @ConfigArgGet
    public String getTitle() {
        return this.title;
    }

    @ConfigArgSet(required=false, defaultValue="/content/toughday", desc="The path prefix for all pages.")
    public AbstractTest setParentPath(String parentPath) {
        this.rootParentPath = StringUtils.stripEnd(parentPath, "/");
        return this;
    }

    @ConfigArgGet
    public String getParentPath() {
        return this.rootParentPath;
    }

    @ConfigArgSet(required=false, defaultValue="/conf/toughday-templates/settings/wcm/templates/toughday-template", desc="The template of the page.")
    public AbstractTest setTemplate(String template) {
        this.template = template;
        return this;
    }

    @ConfigArgGet
    public String getTemplate() {
        return this.template;
    }
}

