/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.tests.sequential;

import com.adobe.qe.toughday.api.annotations.After;
import com.adobe.qe.toughday.api.annotations.Before;
import com.adobe.qe.toughday.api.annotations.ConfigArgGet;
import com.adobe.qe.toughday.api.annotations.ConfigArgSet;
import com.adobe.qe.toughday.api.annotations.Description;
import com.adobe.qe.toughday.api.annotations.Setup;
import com.adobe.qe.toughday.api.annotations.Tag;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.api.core.FluentLogging;
import com.adobe.qe.toughday.tests.sequential.AEMTestBase;
import com.adobe.qe.toughday.tests.utils.TreePhaser;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.logging.log4j.Level;
import org.apache.sling.testing.clients.util.FormEntityBuilder;

@Tag(tags={"author"})
@Description(desc="This test creates pages hierarchically. Each child on each level has \"base\" children. Each author thread fills in a level in the pages tree, up to base^level")
public class CreatePageTreeTest
extends AEMTestBase {
    private final TreePhaser phaser;
    public String rootParentPath = "/content/toughday";
    private String template = "/conf/toughday-templates/settings/wcm/templates/toughday-template";
    private String title = "toughday_tree_title";
    private Integer nextChild;
    private String parentPath;
    private String nodeName;
    private boolean failed = false;

    public CreatePageTreeTest() {
        this.phaser = new TreePhaser();
    }

    protected CreatePageTreeTest(TreePhaser phaser, String parentPath, String template, String title) {
        this.phaser = phaser;
        this.rootParentPath = parentPath;
        this.template = template;
        this.title = title;
    }

    @Setup
    private void setupContent() {
        String isolatedFolder = "toughday" + UUID.randomUUID();
        try {
            this.getDefaultClient().createFolder(isolatedFolder, isolatedFolder, this.rootParentPath, new int[0]);
            this.rootParentPath = this.rootParentPath + "/" + isolatedFolder;
        }
        catch (Throwable e) {
            this.logger().debug("Could not create isolated folder for running " + this.getFullName());
        }
    }

    @Before
    private void setup() {
        this.phaser.register();
        this.nextChild = this.phaser.getNextNode();
        this.parentPath = TreePhaser.computeParentPath(this.nextChild, this.phaser.getLevel(), this.phaser.getBase(), this.title, this.rootParentPath);
        this.nodeName = TreePhaser.computeNodeName(this.nextChild, this.phaser.getBase(), this.title);
        this.failed = false;
    }

    @Override
    public void test() throws Throwable {
        FluentLogging.create(this.logger()).before(Level.DEBUG, "{}: Trying to create page={}{}, with template={}", Thread.currentThread().getName(), this.parentPath, this.nodeName, this.template).onThrowable(Level.WARN, "{}: Failed to create page={}{}, with template={}", Thread.currentThread().getName(), this.parentPath, this.nodeName, this.template).onThrowable(Level.DEBUG, Thread.currentThread().getName() + ": ERROR: ", true).run(() -> this.createPage());
    }

    @After
    private void after() {
        for (int i = 0; i < 5; ++i) {
            try {
                if (!this.failed || this.benchmark().measure((AbstractTest)this, "Check Page Created", this.getDefaultClient()).exists(this.parentPath + this.nodeName)) {
                    this.logger().debug("{}: Successfully created page={}{}, with template={}", (Object)Thread.currentThread().getName(), (Object)this.parentPath, (Object)this.nodeName, (Object)this.template);
                    break;
                }
                this.logger().debug("{}: Retrying to create page={}{}, with template={}", (Object)Thread.currentThread().getName(), (Object)this.parentPath, (Object)this.nodeName, (Object)this.template);
                this.createPage();
                continue;
            }
            catch (Throwable e) {
                this.logger().warn("{}: Failed to create after retry page={}{}, with template={}", (Object)Thread.currentThread().getName(), (Object)this.parentPath, (Object)this.nodeName, (Object)this.template, (Object)e.getMessage());
                this.logger().debug(Thread.currentThread().getName() + "ERROR: ", e);
            }
        }
        this.phaser.arriveAndDeregister();
    }

    private void createPage() throws Throwable {
        FormEntityBuilder feb = FormEntityBuilder.create().addParameter("cmd", "createPage").addParameter("parentPath", this.parentPath).addParameter("label", this.nodeName).addParameter("title", this.title).addParameter("template", this.template);
        UrlEncodedFormEntity entity = feb.build();
        this.benchmark().measure((AbstractTest)this, "CreatePage", this.getDefaultClient()).doPost("/bin/wcmcommand", (HttpEntity)entity, 200);
        this.communicate("resource", this.parentPath + this.nodeName);
    }

    @Override
    public AbstractTest newInstance() {
        return new CreatePageTreeTest(this.phaser, this.rootParentPath, this.template, this.title);
    }

    @ConfigArgSet(required=false, defaultValue="toughday_tree_title", desc="The title of the page. Internally, this is incremented")
    public AbstractTest setTitle(String title) {
        this.title = title.toLowerCase();
        return this;
    }

    @ConfigArgGet
    public String getTitle() {
        return this.title;
    }

    @ConfigArgSet(required=false, defaultValue="/content/toughday", desc="The path prefix for all pages.")
    public AbstractTest setParentPath(String parentPath) {
        this.rootParentPath = StringUtils.stripEnd(parentPath, "/");
        return this;
    }

    @ConfigArgGet
    public String getParentPath() {
        return this.rootParentPath;
    }

    @ConfigArgSet(required=false, defaultValue="/conf/toughday-templates/settings/wcm/templates/toughday-template", desc="Template for all the pages created.")
    public AbstractTest setTemplate(String template) {
        this.template = template;
        return this;
    }

    @ConfigArgGet
    public String getTemplate() {
        return this.template;
    }

    @ConfigArgSet(required=false, desc="How many direct child pages will a page have.", defaultValue="10")
    public AbstractTest setBase(String base) {
        this.phaser.setBase(Integer.parseInt(base));
        return this;
    }

    @ConfigArgGet
    public int getBase() {
        return this.phaser.getBase();
    }
}

