/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.tests.sequential;

import com.adobe.qe.toughday.api.annotations.ConfigArgGet;
import com.adobe.qe.toughday.api.annotations.ConfigArgSet;
import com.adobe.qe.toughday.api.annotations.Description;
import com.adobe.qe.toughday.api.annotations.Tag;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.api.core.SkippedTestException;
import com.adobe.qe.toughday.tests.sequential.AEMTestBase;
import com.adobe.qe.toughday.tests.sequential.CreatePageTest;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.util.FormEntityBuilder;

@Tag(tags={"author"})
@Description(desc="Test for deleting pages.")
public class DeletePageTest
extends AEMTestBase {
    private static final String CMD_DELETE_PAGE = "deletePage";
    private String parentPath = "/content/toughday";
    private String title = "toughday_title";
    private boolean force = true;

    public DeletePageTest() {
    }

    public DeletePageTest(String parentPath, boolean force, String title) {
        this.parentPath = parentPath;
        this.force = force;
        this.title = title;
    }

    protected String getNextTitle() throws SkippedTestException {
        return CreatePageTest.lastCreated.get();
    }

    @Override
    public void test() throws Throwable {
        String nextTitle = this.getNextTitle();
        if (nextTitle == null) {
            throw new SkippedTestException(new ClientException("No page created (by CreatePageTest). Marking as skipped."));
        }
        FormEntityBuilder feb = FormEntityBuilder.create().addParameter("cmd", CMD_DELETE_PAGE).addParameter("force", Boolean.valueOf(this.force).toString()).addParameter("shallow", Boolean.toString(false)).addParameter("path", this.parentPath + "/" + nextTitle);
        try {
            this.logger().debug("{}: Trying to delete={}/{}", (Object)Thread.currentThread().getName(), (Object)this.parentPath, (Object)nextTitle);
            this.benchmark().measure((AbstractTest)this, "Delete Page", this.getDefaultClient()).doPost("/bin/wcmcommand", (HttpEntity)feb.build(), 200);
        }
        catch (Throwable e) {
            this.logger().warn("{}: Failed to delete={}/{}", (Object)Thread.currentThread().getName(), (Object)this.parentPath, (Object)nextTitle);
            this.logger().debug(Thread.currentThread().getName() + ": ERROR: ", e);
            throw e;
        }
        this.logger().debug("{}: Successfully deleted={}/{}", (Object)Thread.currentThread().getName(), (Object)this.parentPath, (Object)nextTitle);
    }

    @Override
    public AbstractTest newInstance() {
        return new DeletePageTest(this.parentPath, this.force, this.title);
    }

    @ConfigArgSet(required=false, defaultValue="/content/toughday", desc="The parent path of the page to be deleted. E.g. The one created by CreatePageTest")
    public DeletePageTest setParentPath(String parentPath) {
        this.parentPath = parentPath.endsWith("/") ? StringUtils.stripEnd(parentPath, "/") : parentPath;
        return this;
    }

    @ConfigArgSet(required=false, defaultValue="true", desc="true/ false; Whether to force delete the page.")
    public DeletePageTest setForce(String force) {
        this.force = Boolean.parseBoolean(force);
        return this;
    }

    @ConfigArgSet(required=false, defaultValue="toughday_title", desc="The title of the page to be deleted. e.g. The one from CreatePageTest")
    public DeletePageTest setTitle(String title) {
        this.title = title;
        return this;
    }

    public DeletePageTest setNext(AtomicInteger next) {
        return this;
    }

    @ConfigArgGet
    public boolean getForce() {
        return this.force;
    }

    @ConfigArgGet
    public String getTitle() {
        return this.title;
    }

    @ConfigArgGet
    public String getParentPath() {
        return this.parentPath;
    }
}

