/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.tests.sequential;

import com.adobe.qe.toughday.api.annotations.ConfigArgGet;
import com.adobe.qe.toughday.api.annotations.ConfigArgSet;
import com.adobe.qe.toughday.api.annotations.Description;
import com.adobe.qe.toughday.api.annotations.Tag;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.tests.sequential.AEMTestBase;

@Tag(tags={"author", "publish"})
@Description(desc="GET a specific page.")
public class GetTest
extends AEMTestBase {
    public static final String DEFAULT_PATH = "/crx/de";
    private String path = "/crx/de";

    @ConfigArgSet(required=false, defaultValue="/crx/de", desc="The path at which to perform a GET request")
    public AbstractTest setPath(String path) {
        this.path = path;
        return this;
    }

    @ConfigArgGet
    public String getPath() {
        return this.path;
    }

    @Override
    public void test() throws Throwable {
        try {
            this.logger().debug("{}: Trying to GET path={}", (Object)Thread.currentThread().getName(), (Object)this.path);
            this.benchmark().measure((AbstractTest)this, "GET page", this.getDefaultClient()).doGet(this.path, 200);
        }
        catch (Throwable e) {
            this.logger().warn("{}: Failed to GET path={}", (Object)Thread.currentThread().getName(), (Object)this.path);
            this.logger().debug(Thread.currentThread().getName() + ": ERROR :", e);
            throw e;
        }
    }

    @Override
    public AbstractTest newInstance() {
        GetTest test = new GetTest();
        test.setPath(this.path);
        return test;
    }
}

