/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.tests.sequential;

import com.adobe.qe.toughday.api.annotations.ConfigArgGet;
import com.adobe.qe.toughday.api.annotations.ConfigArgSet;
import com.adobe.qe.toughday.api.annotations.Description;
import com.adobe.qe.toughday.api.annotations.Internal;
import com.adobe.qe.toughday.api.annotations.Tag;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.tests.sequential.AEMTestBase;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.apache.sling.testing.clients.util.HttpUtils;

@Internal
@Tag(tags={"author"})
@Description(desc="Publishes a page")
public class PublishPageTest
extends AEMTestBase {
    private static final String REFERENCES_SERVLET = "/libs/wcm/core/content/reference.json?_charset_=utf-8";
    private static final Gson GSON = new Gson();
    public static final String DEFAULT_WITH_REFERENCES = "false";
    private boolean withReferences = Boolean.parseBoolean("false");

    public PublishPageTest() {
    }

    public PublishPageTest(boolean withReferences) {
        this.withReferences = withReferences;
    }

    @Override
    public void test() throws Throwable {
        String pagePath = this.getCommunication("resource", null);
        if (pagePath == null) {
            throw new Exception("No page was created. Cannot activate it");
        }
        this.logger().debug("{}: Trying to publish page={}", (Object)Thread.currentThread().getName(), (Object)pagePath);
        try {
            this.publish(pagePath, this.withReferences, 200);
        }
        catch (Throwable e) {
            this.logger().warn("{}: Failed to publish page={}: {}", (Object)Thread.currentThread().getName(), (Object)pagePath, (Object)e.getMessage());
            this.logger().debug(Thread.currentThread().getName() + ": ERROR: ", e);
            throw e;
        }
        this.logger().debug("{}: Successfully published page={}", (Object)Thread.currentThread().getId(), (Object)pagePath);
    }

    @Override
    public AbstractTest newInstance() {
        return new PublishPageTest(this.withReferences);
    }

    private List<String> getPageReferences(String pagePath) throws Throwable {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter("_charset_", "UTF-8").addParameter("path", pagePath);
        SlingHttpResponse content = this.benchmark().measure((AbstractTest)this, "GetPageReferences", this.getDefaultClient()).doPost(REFERENCES_SERVLET, (HttpEntity)form.build(), 200);
        ArrayList<String> paths = new ArrayList<String>();
        JsonArray references = GSON.fromJson(content.getContent(), JsonObject.class).get("assets").getAsJsonArray();
        for (JsonElement reference : references) {
            paths.add(((JsonObject)reference).get("path").getAsString());
        }
        return paths;
    }

    private SlingHttpResponse publish(String pagePath, boolean withReferences, int ... expectedStatus) throws Throwable {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter("_charset_", "UTF-8").addParameter("cmd", "Activate").addParameter("path", pagePath);
        if (withReferences) {
            List<String> references = this.getPageReferences(pagePath);
            for (String reference : references) {
                form.addParameter("path", reference);
            }
        }
        return this.benchmark().measure((AbstractTest)this, "Publish", this.getDefaultClient()).doPost("/bin/replicate", (HttpEntity)form.build(), HttpUtils.getExpectedStatus(200, expectedStatus));
    }

    @ConfigArgSet(required=false, defaultValue="false", desc="Publish references along with the page")
    public PublishPageTest setWithReferences(String withReferences) {
        this.withReferences = Boolean.parseBoolean(withReferences);
        return this;
    }

    @ConfigArgGet
    public boolean getWithReferences() {
        return this.withReferences;
    }
}

