/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.tests.sequential;

import com.adobe.qe.toughday.api.annotations.After;
import com.adobe.qe.toughday.api.annotations.Before;
import com.adobe.qe.toughday.api.annotations.ConfigArgGet;
import com.adobe.qe.toughday.api.annotations.ConfigArgSet;
import com.adobe.qe.toughday.api.annotations.Description;
import com.adobe.qe.toughday.api.annotations.Tag;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.tests.sequential.AEMTestBase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.sling.testing.clients.ClientException;

@Tag(tags={"author"})
@Description(desc="Test for uploading PDF assets under the same path.Due to OAK limitations, performance will decrease over time.If you are not looking for this specific scenario, please consider using CreatePDFTreeTest.")
public class UploadPDFTest
extends AEMTestBase {
    public static final String DEFAULT_PARENT_PATH = "/content/dam/toughday";
    public static final String PDF_CONTENT_TYPE = "application/pdf";
    public static final String DEFAULT_PDF_NAME = "toughday_pdf_asset";
    public static final String DEFAULT_PDF_PATH = "document.pdf";
    private String fileName = "toughday_pdf_asset";
    private String resourcePath = "document.pdf";
    private String parentPath = "/content/dam/toughday";
    private String currentID;
    private File currentFile;

    public UploadPDFTest() throws IOException {
        PDDocument doc = new PDDocument();
        PDPageContentStream pdStream = new PDPageContentStream(doc, new PDPage(), PDPageContentStream.AppendMode.APPEND, true, true);
        pdStream.setFont(PDType1Font.HELVETICA_BOLD, 10.0f);
        pdStream.close();
        doc.close();
    }

    private UploadPDFTest(String fileName, String resourcePath, String parentPath) {
        this.resourcePath = resourcePath;
        this.parentPath = parentPath;
        this.fileName = fileName;
    }

    @Before
    private void before() throws ClientException, IOException {
        this.currentID = UUID.randomUUID().toString();
        String nextFileName = this.fileName + this.currentID + ".pdf";
        PDDocument doc = PDDocument.load(UploadPDFTest.getPDF(this.resourcePath));
        UploadPDFTest.addNoise(doc, this.currentID);
        this.currentFile = new File(this.workspace, nextFileName);
        doc.save(this.currentFile);
        doc.close();
    }

    @Override
    public void test() throws Throwable {
        MultipartEntityBuilder multiPartEntity = MultipartEntityBuilder.create();
        try {
            multiPartEntity.addPart("file", new FileBody(this.currentFile));
            multiPartEntity.addPart("_charset_", new StringBody("utf-8"));
            multiPartEntity.addPart("fileName", new StringBody(this.currentFile.getName(), Charset.forName("utf-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new ClientException("Could not create Multipart Post!", e);
        }
        String currentParentPath = StringUtils.stripEnd(this.getCommunication("parentPath", this.parentPath), "/");
        try {
            this.logger().debug("{}: Trying to upload pdf={}/{}", (Object)Thread.currentThread().getName(), (Object)currentParentPath, (Object)this.currentFile.getName());
            this.benchmark().measure((AbstractTest)this, "UploadPDF", this.getDefaultClient()).doPost(currentParentPath + ".createasset.html", multiPartEntity.build(), 200);
        }
        catch (Throwable e) {
            this.logger().warn("{}: Failed to upload pdf={}/{}", (Object)Thread.currentThread().getName(), (Object)currentParentPath, (Object)this.currentFile.getName());
            this.logger().debug(Thread.currentThread().getName() + ": ERROR: ", e);
            throw e;
        }
        this.logger().debug("{}: Successfully uploaded pdf={}/{}", (Object)Thread.currentThread().getName(), (Object)currentParentPath, (Object)this.currentFile.getName());
    }

    @After
    private void after() {
        this.currentFile.delete();
    }

    @Override
    public AbstractTest newInstance() {
        return new UploadPDFTest(this.fileName, this.resourcePath, this.parentPath);
    }

    @ConfigArgSet(required=false, defaultValue="toughday_pdf_asset", desc="The name of the file to be created")
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @ConfigArgGet
    public String getFileName() {
        return this.fileName;
    }

    @ConfigArgSet(required=false, defaultValue="document.pdf", desc="The image resource path either in the classpath or the filesystem")
    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    @ConfigArgGet
    public String getResourcePath() {
        return this.resourcePath;
    }

    @ConfigArgSet(required=false, defaultValue="/content/dam/toughday", desc="The path where the image is uploaded")
    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    @ConfigArgGet
    public String getParentPath() {
        return this.parentPath;
    }

    public static InputStream getPDF(String filename) throws ClientException {
        InputStream in;
        block2: {
            try {
                in = new FileInputStream(filename);
            }
            catch (FileNotFoundException e) {
                in = UploadPDFTest.class.getClassLoader().getResourceAsStream(filename);
                if (null != in) break block2;
                throw new ClientException("Could not find " + filename + " in classpath or in path");
            }
        }
        return in;
    }

    private static void addNoise(PDDocument doc, String ID2) throws IOException {
        for (PDPage page : doc.getPages()) {
            PDPageContentStream pdStream = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.APPEND, true, true);
            pdStream.setFont(PDType1Font.HELVETICA_BOLD, 10.0f);
            pdStream.beginText();
            pdStream.showText(ID2);
            pdStream.endText();
            pdStream.close();
        }
    }
}

