/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.tests.sequential.image;

import com.adobe.qe.toughday.api.annotations.After;
import com.adobe.qe.toughday.api.annotations.Before;
import com.adobe.qe.toughday.api.annotations.ConfigArgGet;
import com.adobe.qe.toughday.api.annotations.ConfigArgSet;
import com.adobe.qe.toughday.api.annotations.Description;
import com.adobe.qe.toughday.api.annotations.Tag;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.tests.sequential.AEMTestBase;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.sling.testing.clients.ClientException;

@Tag(tags={"author"})
@Description(desc="Test for uploading assets under the same path. Due to OAK limitations, performance will decrease over time. If you are not looking for this specific scenario, please consider using CreateAssetTreeTest.")
public class UploadImageTest
extends AEMTestBase {
    private String fileName = "toughday_png_asset";
    private String resourcePath = "image.png";
    private String mimeType = "image/png";
    private String parentPath = "/content/dam/toughday";
    public static ThreadLocal<File> lastCreated = new ThreadLocal();
    public static Random rnd = new Random();
    public static final AtomicInteger nextNumber = new AtomicInteger(0);
    private BufferedImage img;
    private InputStream imageStream;

    public UploadImageTest() {
    }

    private UploadImageTest(String fileName, String resourcePath, String mimeType, String parentPath) {
        this.resourcePath = resourcePath;
        this.mimeType = mimeType;
        this.parentPath = parentPath;
        this.fileName = fileName;
    }

    @Before
    private void before() throws ClientException, IOException {
        String nextFileName = this.fileName + nextNumber.getAndIncrement() + ".png";
        this.imageStream = UploadImageTest.getImage(this.resourcePath);
        this.img = ImageIO.read(this.imageStream);
        UploadImageTest.addNoise(this.img);
        File last = new File(this.workspace, nextFileName);
        ImageIO.write((RenderedImage)this.img, "png", last);
        lastCreated.set(last);
    }

    @Override
    public void test() throws Throwable {
        MultipartEntity multiPartEntity = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        try {
            multiPartEntity.addPart("file", new FileBody(lastCreated.get()));
            multiPartEntity.addPart("_charset_", new StringBody("utf-8"));
            multiPartEntity.addPart("fileName", new StringBody(lastCreated.get().getName(), Charset.forName("utf-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new ClientException("Could not create Multipart Post!", e);
        }
        String currentParentPath = StringUtils.stripEnd(this.getCommunication("parentPath", this.parentPath), "/");
        try {
            this.logger().debug("{}: Trying to upload image={}{}", (Object)Thread.currentThread().getName(), (Object)currentParentPath, (Object)lastCreated.get().getName());
            this.benchmark().measure((AbstractTest)this, "UploadImage", this.getDefaultClient()).doPost(currentParentPath + ".createasset.html", (HttpEntity)multiPartEntity, 200);
        }
        catch (Throwable e) {
            this.logger().warn("{}: Failed to upload image={}{}", (Object)Thread.currentThread().getName(), (Object)currentParentPath, (Object)lastCreated.get().getName());
            this.logger().debug(Thread.currentThread().getName() + ": ERROR: ", e);
            throw e;
        }
        this.logger().debug("{}: Successfully uploaded image={}{}", (Object)Thread.currentThread().getName(), (Object)currentParentPath, (Object)lastCreated.get().getName());
    }

    @After
    private void after() {
        if (!lastCreated.get().delete()) {
            throw new RuntimeException("Cannot delete file " + lastCreated.get().getName());
        }
    }

    @Override
    public AbstractTest newInstance() {
        return new UploadImageTest(this.fileName, this.resourcePath, this.mimeType, this.parentPath);
    }

    @ConfigArgSet(required=false, defaultValue="toughday_png_asset", desc="The name of the file to be created")
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @ConfigArgGet
    public String getFileName() {
        return this.fileName;
    }

    @ConfigArgSet(required=false, defaultValue="image.png", desc="The image resource path either in the classpath or the filesystem")
    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    @ConfigArgGet
    public String getResourcePath() {
        return this.resourcePath;
    }

    @ConfigArgSet(required=false, defaultValue="image/png", desc="The mime type of the uploaded image")
    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @ConfigArgGet
    public String getMimeType() {
        return this.mimeType;
    }

    @ConfigArgSet(required=false, defaultValue="/content/dam/toughday", desc="The path where the image is uploaded")
    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    @ConfigArgGet
    public String getParentPath() {
        return this.parentPath;
    }

    public static InputStream getImage(String filename) throws ClientException {
        InputStream in;
        block2: {
            try {
                in = new FileInputStream(filename);
            }
            catch (FileNotFoundException e) {
                in = UploadImageTest.class.getClassLoader().getResourceAsStream(filename);
                if (null != in) break block2;
                throw new ClientException("Could not find " + filename + " in classpath or in path");
            }
        }
        return in;
    }

    public static void addNoise(BufferedImage img) {
        for (int i = 0; i < 200; ++i) {
            int x = rnd.nextInt(img.getWidth());
            int y = rnd.nextInt(img.getHeight());
            img.setRGB(x, y, Color.CYAN.getRGB());
        }
    }
}

