/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.tests.sequential.msm;

import com.adobe.qe.toughday.api.annotations.After;
import com.adobe.qe.toughday.api.annotations.Before;
import com.adobe.qe.toughday.api.annotations.ConfigArgGet;
import com.adobe.qe.toughday.api.annotations.ConfigArgSet;
import com.adobe.qe.toughday.api.annotations.Description;
import com.adobe.qe.toughday.api.annotations.Name;
import com.adobe.qe.toughday.api.annotations.Setup;
import com.adobe.qe.toughday.api.annotations.Tag;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.tests.sequential.AEMTestBase;
import com.adobe.qe.toughday.tests.utils.TreePhaser;
import com.adobe.qe.toughday.tests.utils.WcmUtils;
import java.util.UUID;

@Tag(tags={"author"})
@Name(name="create_lc")
@Description(desc="Creates live copies from pages")
public class CreateLiveCopyFromPageTest
extends AEMTestBase {
    public static final String SOURCE_PAGE_NAME = "create_lc_source";
    public static final String DESTINATION_PAGE_NAME = "create_lc_dest";
    public static final String DEFAULT_SOURCE_ROOT_PAGE = "/content/toughday/language-master/en/toughday";
    public static final String DEFAULT_DESTINATION_ROOT_PAGE = "/content/toughday";
    public static final String DEFAULT_PAGE_TITLE = "lc";
    private final TreePhaser phaser;
    private String title;
    private String sourcePage;
    private String destinationPage;
    private String destinationRoot;
    private String nodeName;
    private boolean failed = false;
    private int nextChild;

    public CreateLiveCopyFromPageTest() {
        this.phaser = new TreePhaser();
        this.sourcePage = DEFAULT_SOURCE_ROOT_PAGE;
        this.destinationRoot = DEFAULT_DESTINATION_ROOT_PAGE;
        this.title = DEFAULT_PAGE_TITLE;
    }

    public CreateLiveCopyFromPageTest(TreePhaser phaser, String title, String sourcePage, String destinationRoot) {
        this.phaser = phaser;
        this.sourcePage = sourcePage;
        this.destinationRoot = destinationRoot;
        this.title = title;
    }

    @Setup
    private void setup() throws Throwable {
        String isolatedFolder = "toughday_lc" + UUID.randomUUID();
        try {
            this.getDefaultClient().createFolder(isolatedFolder, isolatedFolder, this.destinationRoot, new int[0]);
            this.destinationRoot = this.destinationRoot + "/" + isolatedFolder;
        }
        catch (Throwable e) {
            this.logger().debug("Could not create isolated folder for running " + this.getFullName());
        }
    }

    @Before
    private void before() throws Throwable {
        this.sourcePage = this.getCommunication("resource", this.sourcePage);
        this.phaser.register();
        this.nextChild = this.phaser.getNextNode();
        this.destinationPage = TreePhaser.computeParentPath(this.nextChild, this.phaser.getLevel(), this.phaser.getBase(), this.title, this.destinationRoot);
        this.nodeName = TreePhaser.computeNodeName(this.nextChild, this.phaser.getBase(), this.title);
        this.failed = false;
    }

    @Override
    public void test() throws Throwable {
        try {
            this.logger().debug("{}: Trying to create live copy={}{}, from page={}", (Object)Thread.currentThread().getName(), (Object)this.destinationPage, (Object)this.nodeName, (Object)this.sourcePage);
            this.createLC();
        }
        catch (Throwable e) {
            this.failed = true;
            this.logger().warn("{}: Failed to create live copy={}{}, from page={}", (Object)Thread.currentThread().getName(), (Object)this.destinationPage, (Object)this.nodeName, (Object)this.sourcePage);
            this.logger().debug(Thread.currentThread().getName() + "ERROR: ", e);
            throw e;
        }
    }

    private void createLC() throws Throwable {
        WcmUtils.createLiveCopy(this, this.getDefaultClient(), this.nodeName, this.title, this.destinationPage, this.sourcePage, false, null, null, false, 200);
        this.communicate("livecopy", this.destinationPage + this.nodeName);
    }

    @After
    private void after() {
        for (int i = 0; i < 5; ++i) {
            try {
                if (!this.failed || this.getDefaultClient().exists(this.destinationPage + this.nodeName)) {
                    this.logger().debug("{}: Successfully created live copy={}{}, from page={}", (Object)Thread.currentThread().getName(), (Object)this.destinationPage, (Object)this.nodeName, (Object)this.sourcePage);
                    break;
                }
                this.logger().debug("{}: Retrying to create live copy={}{}, from page={}", (Object)Thread.currentThread().getName(), (Object)this.destinationPage, (Object)this.nodeName, (Object)this.sourcePage);
                this.createLC();
                continue;
            }
            catch (Throwable e) {
                this.logger().warn("{}: Failed to create after retry live copy={}{}, from page={}", (Object)Thread.currentThread().getName(), (Object)this.destinationPage, (Object)this.nodeName, (Object)this.sourcePage);
                this.logger().debug(Thread.currentThread().getName() + ": ERROR: ", e);
            }
        }
        this.phaser.arriveAndDeregister();
    }

    @Override
    public AbstractTest newInstance() {
        return new CreateLiveCopyFromPageTest(this.phaser, this.title, this.sourcePage, this.destinationRoot);
    }

    @ConfigArgSet(required=false, desc="The source page for live copies", defaultValue="/content/toughday/language-master/en/toughday")
    public AbstractTest setSourcePage(String page) {
        this.sourcePage = page;
        return this;
    }

    @ConfigArgGet
    public String getSourcePage() {
        return this.sourcePage;
    }

    @ConfigArgSet(required=false, desc="Default root for live copies", defaultValue="/content/toughday")
    public AbstractTest setDestinationRoot(String page) {
        this.destinationRoot = page;
        return this;
    }

    @ConfigArgGet
    public String getDestinationRoot() {
        return this.destinationRoot;
    }

    @ConfigArgSet(required=false, desc="Title for livecopies", defaultValue="lc")
    public AbstractTest setTitle(String title) {
        this.title = title;
        return this;
    }

    @ConfigArgGet
    public String getTitle() {
        return this.title;
    }

    @ConfigArgSet(required=false, desc="How many direct child pages will a page have.", defaultValue="10")
    public AbstractTest setBase(String base) {
        this.phaser.setBase(Integer.parseInt(base));
        return this;
    }

    @ConfigArgGet
    public int getBase() {
        return this.phaser.getBase();
    }
}

