/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.tests.sequential.msm;

import com.adobe.qe.toughday.api.annotations.Before;
import com.adobe.qe.toughday.api.annotations.ConfigArgGet;
import com.adobe.qe.toughday.api.annotations.ConfigArgSet;
import com.adobe.qe.toughday.api.annotations.Description;
import com.adobe.qe.toughday.api.annotations.Internal;
import com.adobe.qe.toughday.api.annotations.Name;
import com.adobe.qe.toughday.api.annotations.Tag;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.tests.sequential.AEMTestBase;
import com.adobe.qe.toughday.tests.utils.WcmUtils;

@Internal
@Tag(tags={"author"})
@Name(name="rollout_source")
@Description(desc="Rollout the source page/ blueprint")
public class RolloutTest
extends AEMTestBase {
    private String sourcePage = null;
    private String destinationPage = null;
    private String type;
    private boolean background;

    public RolloutTest() {
        this.type = "page";
        this.background = false;
    }

    public RolloutTest(String sourcePage, String destinationPage, String type, boolean background) {
        this.sourcePage = sourcePage;
        this.destinationPage = destinationPage;
        this.type = type;
        this.background = background;
    }

    @Before
    private void before() throws Throwable {
        this.sourcePage = this.getCommunication("resource", this.sourcePage);
        this.destinationPage = this.getCommunication("livecopy", this.destinationPage);
    }

    @Override
    public void test() throws Throwable {
        try {
            this.logger().debug("{}: Trying to rollout page={}, from source={}", (Object)Thread.currentThread().getName(), (Object)this.destinationPage, (Object)this.sourcePage);
            WcmUtils.rolloutPage(this.getDefaultClient(), this.type, this.background, new String[]{this.sourcePage}, null, new String[]{this.destinationPage}, 200);
        }
        catch (Throwable e) {
            this.logger().warn("{}: Failed to rollout page={}{}, from source={}", (Object)Thread.currentThread().getName(), (Object)this.destinationPage, (Object)this.sourcePage);
            this.logger().debug(Thread.currentThread().getName() + ": ERROR: ", e);
            throw e;
        }
        this.logger().debug("{}: Successfully rollout page={}, from source={}", (Object)Thread.currentThread().getName(), (Object)this.destinationPage, (Object)this.sourcePage);
    }

    @Override
    public AbstractTest newInstance() {
        return new RolloutTest(this.sourcePage, this.destinationPage, this.type, this.background);
    }

    @ConfigArgSet(required=true, desc="The source page to rollout")
    public AbstractTest setSourcePage(String page) {
        this.sourcePage = page;
        return this;
    }

    @ConfigArgGet
    public String getSourcePage() {
        return this.sourcePage;
    }

    @ConfigArgSet(required=true, desc="The destination page to rollout to")
    public AbstractTest setDestinationPage(String page) {
        this.destinationPage = page;
        return this;
    }

    @ConfigArgGet
    public String getDestinationPage() {
        return this.destinationPage;
    }

    @ConfigArgSet(required=false, desc="page / deep", defaultValue="page")
    public AbstractTest setType(String type) {
        this.type = type;
        return this;
    }

    @ConfigArgGet
    public String getType() {
        return this.type;
    }

    @ConfigArgSet(required=false, desc="true/false - Whether to rollout in the background", defaultValue="false")
    public AbstractTest setBackground(String background) {
        this.background = Boolean.parseBoolean(background);
        return this;
    }

    @ConfigArgGet
    public boolean getBackground() {
        return this.background;
    }
}

