/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.tests.sequential.tags;

import com.adobe.qe.toughday.api.annotations.Internal;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.tests.sequential.AEMTestBase;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.sling.testing.clients.util.FormEntityBuilder;

@Internal
public class AddTagToResourceTest
extends AEMTestBase {
    @Override
    public void test() throws Throwable {
        String resourcePath = this.getCommunication("resource", null);
        List tags = this.getCommunication("tags", null);
        if (resourcePath == null || tags == null) {
            throw new IllegalStateException("Either the resource or the tags were missing");
        }
        resourcePath = resourcePath.endsWith("_jcr_content") ? resourcePath : StringUtils.stripEnd(resourcePath, "/") + "/_jcr_content";
        FormEntityBuilder builder = FormEntityBuilder.create();
        for (String tag : tags) {
            builder.addParameter("./cq:tags", tag);
        }
        builder.addParameter("./cq:tags@TypeHint", "String[]");
        try {
            this.logger().debug("{}: Trying to add tags {} to the resource {}", (Object)Thread.currentThread().getName(), (Object)tags, (Object)resourcePath);
            this.getDefaultClient().doPost(resourcePath, (HttpEntity)builder.build(), 200);
        }
        catch (Throwable e) {
            this.logger().warn("{}: Failed to add tags {} to the resource {}", (Object)Thread.currentThread().getName(), (Object)tags, (Object)resourcePath);
            this.logger().debug(Thread.currentThread().getName() + "ERROR: ", e);
            throw e;
        }
        this.logger().debug("{}: Successfully added tags {} to the resource {}", (Object)Thread.currentThread().getName(), (Object)tags, (Object)resourcePath);
    }

    @Override
    public AbstractTest newInstance() {
        return new AddTagToResourceTest();
    }
}

