/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.tests.sequential.tags;

import com.adobe.qe.toughday.api.annotations.After;
import com.adobe.qe.toughday.api.annotations.Before;
import com.adobe.qe.toughday.api.annotations.ConfigArgGet;
import com.adobe.qe.toughday.api.annotations.ConfigArgSet;
import com.adobe.qe.toughday.api.annotations.Description;
import com.adobe.qe.toughday.api.annotations.Name;
import com.adobe.qe.toughday.api.annotations.Setup;
import com.adobe.qe.toughday.api.annotations.Tag;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.tests.sequential.AEMTestBase;
import com.adobe.qe.toughday.tests.utils.TreePhaser;
import java.util.Arrays;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.util.FormEntityBuilder;

@Tag(tags={"author"})
@Name(name="create_tag_tree")
@Description(desc="This test creates tags hierarchically. Each child on each level has \"base\" children. Each author thread fills in a level in the tag tree, up to base^level")
public class CreateTagTreeTest
extends AEMTestBase {
    public static final String CREATE_TAG_CMD = "createTag";
    public static final String TAG_COMMAND_URL = "/bin/tagcommand";
    public static final String DEFAULT_NAMESPACE = "ToughDay";
    public static final String DEFAULT_TAG_TITLE = "ToughDay";
    public static final String EXTRA_TAG_TITLE = "ToughDayTag";
    private static final String NAMEPSPACE_DESCRIPTION = "Isolated namespace for ToughDay testing";
    private static final String TAG_DESCRIPTION = "Toughday Tag";
    private TreePhaser phaser;
    private boolean failed;
    private String parentPath;
    private String title = "ToughDay";
    private String nodeName;
    private String namespace = "ToughDay";
    private int nextChild;
    private String extra_tag;

    public CreateTagTreeTest() {
        this.phaser = new TreePhaser();
    }

    public CreateTagTreeTest(TreePhaser phaser, String namespace, String title, String extra_tag) {
        this.phaser = phaser;
        this.namespace = namespace;
        this.title = title;
        this.extra_tag = extra_tag;
    }

    @Setup
    private void setup() {
        try {
            String isolatedNameSpace = this.namespace + "_" + RandomStringUtils.randomAlphanumeric(5);
            this.createNamespace(isolatedNameSpace, isolatedNameSpace, NAMEPSPACE_DESCRIPTION);
            this.namespace = isolatedNameSpace;
        }
        catch (Throwable e) {
            this.logger().warn("Failed to create namespace {}", (Object)this.namespace);
            this.namespace = "default";
        }
        try {
            this.createTag(EXTRA_TAG_TITLE, EXTRA_TAG_TITLE, "ToughDay extra tag", this.namespace + ":", false);
            this.extra_tag = this.namespace + ":" + EXTRA_TAG_TITLE;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Before
    private void before() {
        this.phaser.register();
        this.nextChild = this.phaser.getNextNode();
        this.parentPath = this.namespace + ":" + StringUtils.stripStart(TreePhaser.computeParentPath(this.nextChild, this.phaser.getLevel(), this.phaser.getBase(), this.title), "/");
        this.nodeName = TreePhaser.computeNodeName(this.nextChild, this.phaser.getBase(), this.title);
        this.failed = false;
    }

    @Override
    public void test() throws Throwable {
        try {
            this.logger().debug("{}: Trying to create tag={}{}", (Object)Thread.currentThread().getName(), (Object)this.parentPath, (Object)this.nodeName);
            this.createTag();
        }
        catch (Throwable e) {
            this.failed = true;
            this.logger().warn("{}: Failed to create tag={}{}", (Object)Thread.currentThread().getName(), (Object)this.parentPath, (Object)this.nodeName);
            this.logger().debug(Thread.currentThread().getName() + "ERROR: ", e);
            throw e;
        }
    }

    @After
    private void after() {
        for (int i = 0; i < 5; ++i) {
            try {
                if (!this.failed || this.getDefaultClient().exists(this.parentPath + this.nodeName)) {
                    this.logger().debug("{}: Successfully created tag={}{}", (Object)Thread.currentThread().getName(), (Object)this.parentPath, (Object)this.nodeName);
                    break;
                }
                this.logger().debug("{}: Retrying to create tag={}{}", (Object)Thread.currentThread().getName(), (Object)this.parentPath, (Object)this.nodeName);
                this.createTag();
                continue;
            }
            catch (Throwable e) {
                this.logger().warn("{}: Failed to create after retry tag={}{}", (Object)Thread.currentThread().getName(), (Object)this.parentPath, (Object)this.nodeName);
                this.logger().debug(Thread.currentThread().getName() + "ERROR: ", e);
            }
        }
        this.phaser.arriveAndDeregister();
    }

    private void createNamespace(String title, String tag, String description) throws Throwable {
        FormEntityBuilder feb = FormEntityBuilder.create().addParameter("jcr:title", title).addParameter("tag", tag).addParameter("jcr:description", description).addParameter("cmd", CREATE_TAG_CMD);
        this.getDefaultClient().doPost(TAG_COMMAND_URL, (HttpEntity)feb.build(), 200);
    }

    private void createTag() throws Throwable {
        this.createTag(this.nodeName, this.nodeName, TAG_DESCRIPTION, this.parentPath, false);
    }

    private void createTag(String title, String tag, String description, String parentTagID, boolean addToRunMap) throws Throwable {
        SlingClient client = addToRunMap ? this.benchmark().measure((AbstractTest)this, "CreateTag", this.getDefaultClient()) : this.getDefaultClient();
        FormEntityBuilder feb = FormEntityBuilder.create().addParameter("jcr:title", title).addParameter("tag", tag).addParameter("jcr:description", description).addParameter("parentTagID", parentTagID).addParameter("cmd", CREATE_TAG_CMD);
        client.doPost(TAG_COMMAND_URL, (HttpEntity)feb.build(), 200);
        this.communicate("tags", Arrays.asList(this.extra_tag, parentTagID + title));
    }

    @Override
    public AbstractTest newInstance() {
        return new CreateTagTreeTest(this.phaser, this.namespace, this.title, this.extra_tag);
    }

    @ConfigArgSet(required=false, defaultValue="ToughDay", desc="The title of the namespace where the tags will be created. A random string will be added internally to make it unique")
    public AbstractTest setNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @ConfigArgGet
    public String getNamespace() {
        return this.namespace;
    }

    @ConfigArgSet(required=false, defaultValue="ToughDay", desc="The title of the tags. Internally, this will be incremented")
    public AbstractTest setTitle(String title) {
        this.title = title;
        return this;
    }

    @ConfigArgGet
    public String getTitle() {
        return this.title;
    }

    @ConfigArgSet(required=false, desc="How many direct child tags will a tag have.", defaultValue="10")
    public AbstractTest setBase(String base) {
        this.phaser.setBase(Integer.parseInt(base));
        return this;
    }

    @ConfigArgGet
    public int getBase() {
        return this.phaser.getBase();
    }
}

