/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.tests.sequential.users;

import com.adobe.qe.toughday.api.annotations.Before;
import com.adobe.qe.toughday.api.annotations.ConfigArgGet;
import com.adobe.qe.toughday.api.annotations.ConfigArgSet;
import com.adobe.qe.toughday.api.annotations.Description;
import com.adobe.qe.toughday.api.annotations.Setup;
import com.adobe.qe.toughday.api.annotations.Tag;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.tests.sequential.AEMTestBase;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.http.HttpEntity;
import org.apache.sling.commons.html.impl.HtmlParserImpl;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.w3c.dom.Document;

@Tag(tags={"author"})
@Description(desc="Create groups of users. Similar to group editor console (/libs/granite/security/content/groupEditor.html)")
public class CreateUserGroupTest
extends AEMTestBase {
    private String id;
    private String groupName = "ToughDay";
    private String description = "A group for ToughDay users";
    private AtomicInteger increment;
    private String extraGroup;
    public static final String DEFAULT_GROUP_NAME = "ToughDay";
    public static final String DEFAULT_GROUP_DESCRIPTION = "A group for ToughDay users";

    public CreateUserGroupTest() {
        this.increment = new AtomicInteger(0);
    }

    public CreateUserGroupTest(AtomicInteger increment, String groupName, String description, String extraGroup) {
        this.groupName = groupName;
        this.description = description;
        this.increment = increment;
    }

    @Setup
    private void setup() {
        try {
            this.extraGroup = this.createGroup(this.getDefaultClient(), this.id, this.groupName, this.description, false);
        }
        catch (Throwable e) {
            this.extraGroup = null;
        }
    }

    @Before
    private void before() {
        this.id = RandomStringUtils.randomAlphanumeric(20);
    }

    @Override
    public void test() throws Throwable {
        String groupName = this.groupName;
        if (this.increment != null) {
            groupName = groupName + this.increment.getAndIncrement();
        }
        try {
            this.logger().debug("{}: Trying to create user group={}, with id={}", (Object)Thread.currentThread().getName(), (Object)groupName, (Object)this.id);
            String groupPath = this.createGroup(this.getDefaultClient(), this.id, groupName, this.description, true);
            this.communicate("groups", this.extraGroup != null ? Arrays.asList(this.extraGroup, groupPath) : Arrays.asList(groupPath));
        }
        catch (Throwable e) {
            this.logger().warn("{}: Failed to create user group={}{}", (Object)Thread.currentThread().getName(), (Object)groupName, (Object)this.id);
            this.logger().debug(Thread.currentThread().getName() + "ERROR: ", e);
            throw e;
        }
        this.logger().debug("{}: Successfully created user group={}, with id={}", (Object)Thread.currentThread().getName(), (Object)groupName, (Object)this.id);
    }

    private String createGroup(SlingClient client, String id, String groupName, String description, boolean addToRunmap) throws Throwable {
        HtmlParserImpl htmlParser = new HtmlParserImpl();
        FormEntityBuilder entityBuilder = FormEntityBuilder.create().addParameter("authorizableId", id).addParameter("./profile/givenName", groupName).addParameter("./profile/aboutMe", description).addParameter("createGroup", "1").addParameter("_charset_", "utf-8");
        client = addToRunmap ? this.benchmark().measure((AbstractTest)this, "CreateGroup", client) : client;
        SlingHttpResponse response = client.doPost("/libs/granite/security/post/authorizables.html", (HttpEntity)entityBuilder.build(), 201);
        Document responseHtml = htmlParser.parse(null, IOUtils.toInputStream(response.getContent()), "utf-8");
        return responseHtml.getElementsByTagName("title").item(0).getTextContent().split(" ")[2];
    }

    @Override
    public AbstractTest newInstance() {
        return new CreateUserGroupTest(this.increment, this.groupName, this.description, this.extraGroup);
    }

    @ConfigArgSet(required=false, defaultValue="ToughDay")
    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @ConfigArgGet
    public String getGroupName() {
        return this.groupName;
    }

    @ConfigArgSet(required=false, defaultValue="A group for ToughDay users")
    public void setDescription(String description) {
        this.description = description;
    }

    @ConfigArgGet
    public String getDescription() {
        return this.description;
    }

    @ConfigArgSet(required=false, desc="Increment the group name", defaultValue="true")
    public void setIncrement(String value) {
        if (!Boolean.valueOf(value).booleanValue()) {
            this.increment = null;
        }
    }

    @ConfigArgGet
    public boolean getIncrement() {
        return this.increment != null;
    }
}

