/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.tests.sequential.users;

import com.adobe.qe.toughday.api.annotations.Before;
import com.adobe.qe.toughday.api.annotations.ConfigArgGet;
import com.adobe.qe.toughday.api.annotations.ConfigArgSet;
import com.adobe.qe.toughday.api.annotations.Description;
import com.adobe.qe.toughday.api.annotations.Tag;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.tests.sequential.AEMTestBase;
import com.adobe.qe.toughday.tests.utils.Constants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.sling.testing.clients.util.FormEntityBuilder;

@Tag(tags={"author"})
@Description(desc="Creates users similar to the user editor console (/libs/granite/security/content/userEditor.html)")
public class CreateUserTest
extends AEMTestBase {
    public static final String DEFAULT_PASSWORD = "toughday";
    public static final String DEFAULT_EMAIL_ADDRESS = "toughday@adobe.com";
    public static final String DEFAULT_PHONE_NUMBER = "098765654";
    public static final String DEFAULT_FIRST_NAME = "Tough";
    public static final String DEFAULT_LAST_NAME = "Day";
    public static final String DEFAULT_JOB_TITLE = "Performance Tester";
    public static final String DEFAULT_STREET = "151 South Almaden Boulevard";
    public static final String DEFAULT_CITY = "San Jose";
    public static final String DEFAULT_MOBILE = "0987654";
    public static final String DEFAULT_POSTAL_CODE = "123456";
    public static final String DEFAULT_COUNTRY = "United States";
    public static final String DEFAULT_GENDER = "male";
    public static final String DEFAULT_STATE = "California";
    public static final String DEFAULT_ABOUT_ME = "Stress testing and performance benchmarking.";
    public static final String DEFAULT_PATH_TO_ADD_USERS = "/home/users";
    private String id;
    private String title;
    private String password = "toughday";
    private String emailAddress = "toughday@adobe.com";
    private String phoneNumber = "098765654";
    private String firstName = "Tough";
    private String lastName = "Day";
    private String jobTitle = "Performance Tester";
    private String street = "151 South Almaden Boulevard";
    private String city = "San Jose";
    private String mobile = "0987654";
    private String postalCode = "123456";
    private String country = "United States";
    private String state = "California";
    private String gender = "male";
    private String aboutMe = "Stress testing and performance benchmarking.";
    private String pathToAddUsers = "/home/users";
    private List<String> groups = new ArrayList<String>();
    private AtomicInteger increment = new AtomicInteger(0);
    private boolean incrementGender = true;
    private boolean incrementCountry = true;

    @Before
    private void before() {
        this.title = this.id = RandomStringUtils.randomAlphanumeric(20);
    }

    @Override
    public void test() throws Throwable {
        String firstName = this.firstName;
        String lastName = this.lastName;
        String phoneNumber = this.phoneNumber;
        String mobile = this.mobile;
        String jobTitle = this.jobTitle;
        String country = this.country;
        String gender = this.gender;
        String aboutMe = this.aboutMe;
        String emailAddress = this.emailAddress;
        if (this.increment != null) {
            int incrementValue = this.increment.getAndIncrement();
            firstName = firstName + incrementValue;
            lastName = lastName + incrementValue;
            phoneNumber = phoneNumber + incrementValue;
            mobile = mobile + incrementValue;
            jobTitle = jobTitle + incrementValue;
            aboutMe = aboutMe + incrementValue;
            String[] tmp = emailAddress.split("@");
            gender = this.incrementGender ? Constants.GENDERS[incrementValue % 2] : gender;
            country = this.incrementCountry ? Constants.COUNTRIES[incrementValue % Constants.COUNTRIES.length] : country;
            emailAddress = tmp[0] + incrementValue + "@" + tmp[1];
        }
        String currentPathToAddUsers = StringUtils.stripEnd(this.getCommunication("parentPath", this.pathToAddUsers), "/");
        FormEntityBuilder entityBuilder = FormEntityBuilder.create().addParameter("authorizableId", this.id).addParameter("./jcr:title", this.title).addParameter("./profile/email", emailAddress).addParameter("rep:password", this.password).addParameter("./profile/givenName", firstName).addParameter("./profile/familyName", lastName).addParameter("./profile/phoneNumber", phoneNumber).addParameter("./profile/jobTitle", jobTitle).addParameter("./profile/street", this.street).addParameter("./profile/mobile", mobile).addParameter("./profile/city", this.city).addParameter("./profile/postalCode", this.postalCode).addParameter("./profile/country", country).addParameter("./profile/state", this.state).addParameter("./profile/gender", gender).addParameter("./profile/aboutMe", aboutMe).addParameter("_charset_", "utf-8").addParameter("intermediatePath", currentPathToAddUsers).addParameter("createUser", "1");
        try {
            this.logger().debug("{}: Trying to create user={}, with id={}", (Object)Thread.currentThread().getName(), (Object)(firstName + " " + lastName), (Object)this.id);
            this.benchmark().measure((AbstractTest)this, "CreateUser", this.getDefaultClient()).doPost("/libs/granite/security/post/authorizables.html", (HttpEntity)entityBuilder.build(), 201);
        }
        catch (Throwable e) {
            this.logger().warn("{}: Failed to create user={}, with id={}", (Object)Thread.currentThread().getName(), (Object)(firstName + " " + lastName), (Object)this.id);
            this.logger().debug(Thread.currentThread().getName() + "ERROR: ", e);
            throw e;
        }
        this.logger().debug("{}: Successfully created user={}, with id={}", (Object)Thread.currentThread().getName(), (Object)(firstName + " " + lastName), (Object)this.id);
        for (String group : this.groups) {
            this.addUserToGroup(group, this.id);
        }
        List communicatedGroups = this.getCommunication("groups", new ArrayList());
        communicatedGroups.remove(this.groups);
        for (String group : communicatedGroups) {
            this.addUserToGroup(group, this.id);
        }
    }

    private void addUserToGroup(String group, String user) throws Throwable {
        String groupServlet = group + ".rw.userprops.html";
        FormEntityBuilder entityBuilder = FormEntityBuilder.create().addParameter("addMembers", this.id).addParameter("_charset_", "utf-8");
        try {
            this.logger().debug("{}: Trying to add user={}, to group ={}", (Object)Thread.currentThread().getName(), (Object)user, (Object)group);
            this.getDefaultClient().doPost(groupServlet, (HttpEntity)entityBuilder.build(), 200);
        }
        catch (Throwable e) {
            this.logger().warn("{}: Failed to add user={}, to group ={}", (Object)Thread.currentThread().getName(), (Object)user, (Object)group);
            this.logger().debug(Thread.currentThread().getName() + "ERROR: ", e);
            throw e;
        }
        this.logger().debug("{}: Successfully added user={}, to group ={}", (Object)Thread.currentThread().getName(), (Object)user, (Object)group);
    }

    @ConfigArgSet(required=false, desc="Path where the users are created.", defaultValue="/home/users")
    public CreateUserTest setPathToAddUsers(String pathToAddUsers) {
        this.pathToAddUsers = pathToAddUsers;
        return this;
    }

    @ConfigArgGet
    public String getPathToAddUsers() {
        return this.pathToAddUsers;
    }

    @ConfigArgSet(required=false, desc="Email address for created users.", defaultValue="toughday@adobe.com")
    public CreateUserTest setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @ConfigArgGet
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @ConfigArgSet(required=false, desc="Password for the created users.", defaultValue="toughday")
    public CreateUserTest setPassword(String password) {
        this.password = password;
        return this;
    }

    @ConfigArgGet
    public String getPassword() {
        return this.password;
    }

    @ConfigArgSet(required=false, desc="Telephone for the created users.", defaultValue="098765654")
    public CreateUserTest setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @ConfigArgGet
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @ConfigArgSet(required=false, desc="First name for the created users", defaultValue="Tough")
    public CreateUserTest setFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @ConfigArgGet
    public String getFirstName() {
        return this.firstName;
    }

    @ConfigArgSet(required=false, desc="Last name for the created users", defaultValue="Day")
    public CreateUserTest setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @ConfigArgGet
    public String getLastName() {
        return this.lastName;
    }

    @ConfigArgSet(required=false, desc="Job title for the created users", defaultValue="Performance Tester")
    public CreateUserTest setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
        return this;
    }

    @ConfigArgGet
    public String getJobTitle() {
        return this.jobTitle;
    }

    @ConfigArgSet(required=false, desc="Street address for the created users", defaultValue="151 South Almaden Boulevard")
    public CreateUserTest setStreet(String street) {
        this.street = street;
        return this;
    }

    @ConfigArgGet
    public String getStreet() {
        return this.street;
    }

    @ConfigArgSet(required=false, desc="City address for the created users", defaultValue="San Jose")
    public CreateUserTest setCity(String city) {
        this.city = city;
        return this;
    }

    @ConfigArgGet
    public String getCity() {
        return this.city;
    }

    @ConfigArgSet(required=false, desc="Mobile number for the created users", defaultValue="0987654")
    public CreateUserTest setMobile(String mobile) {
        this.mobile = mobile;
        return this;
    }

    @ConfigArgGet
    public String getMobile() {
        return this.mobile;
    }

    @ConfigArgSet(required=false, desc="Postal code for the created users", defaultValue="123456")
    public CreateUserTest setPostalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @ConfigArgGet
    public String getPostalCode() {
        return this.postalCode;
    }

    @ConfigArgSet(required=false, desc="Country for the created users", defaultValue="United States")
    public CreateUserTest setCountry(String country) {
        this.country = country;
        this.incrementCountry = false;
        return this;
    }

    @ConfigArgGet
    public String getCountry() {
        return this.country;
    }

    @ConfigArgSet(required=false, desc="State for the created users", defaultValue="California")
    public CreateUserTest setState(String state) {
        this.state = state;
        return this;
    }

    @ConfigArgGet
    public String getState() {
        return this.state;
    }

    @ConfigArgSet(required=false, desc="Gender for the created users.", defaultValue="male")
    public CreateUserTest setGender(String gender) {
        this.gender = gender;
        this.incrementGender = false;
        return this;
    }

    @ConfigArgGet
    public String getGender() {
        return this.gender;
    }

    @ConfigArgSet(required=false, desc="User description", defaultValue="Stress testing and performance benchmarking.")
    public CreateUserTest setAboutMe(String aboutMe) {
        this.aboutMe = aboutMe;
        return this;
    }

    @ConfigArgGet
    public String getAboutMe() {
        return this.aboutMe;
    }

    @ConfigArgSet(required=false, desc="If this is \"true\" then some of user properties will be either incremented or randomised", defaultValue="true")
    public CreateUserTest setIncrement(String value) {
        if (!Boolean.valueOf(value).booleanValue()) {
            this.increment = null;
        }
        return this;
    }

    @ConfigArgGet
    public boolean getIncrement() {
        return this.increment != null;
    }

    public CreateUserTest setIncrement(AtomicInteger increment) {
        this.increment = increment;
        return this;
    }

    @ConfigArgSet(required=false, desc="Comma separated group paths. Newly created users will be added in these groups.")
    public CreateUserTest setGroups(String values) {
        this.groups.addAll(Arrays.asList(values.split(",")));
        return this;
    }

    public CreateUserTest setGroups(List<String> groups) {
        this.groups = groups;
        return this;
    }

    private CreateUserTest setIncrementCountry(boolean incrementCountry) {
        this.incrementCountry = incrementCountry;
        return this;
    }

    private CreateUserTest setIncrementGender(boolean incrementGender) {
        this.incrementGender = incrementGender;
        return this;
    }

    @Override
    public AbstractTest newInstance() {
        return new CreateUserTest().setGroups(this.groups).setIncrement(this.increment).setFirstName(this.firstName).setLastName(this.lastName).setPassword(this.password).setStreet(this.street).setCity(this.city).setState(this.state).setCountry(this.country).setIncrementCountry(this.incrementCountry).setPostalCode(this.postalCode).setPhoneNumber(this.phoneNumber).setMobile(this.mobile).setJobTitle(this.jobTitle).setEmailAddress(this.emailAddress).setAboutMe(this.aboutMe).setGender(this.gender).setPathToAddUsers(this.pathToAddUsers).setIncrementGender(this.incrementGender);
    }
}

