/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.tests.utils;

import com.adobe.qe.toughday.api.annotations.labels.NotThreadSafe;
import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.api.core.benchmark.Benchmark;
import com.adobe.qe.toughday.api.core.benchmark.Proxy;
import com.adobe.qe.toughday.api.core.benchmark.ResultInfo;
import com.adobe.qe.toughday.api.core.benchmark.TestResult;
import com.adobe.qe.toughday.tests.utils.SlingHttpData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.SlingHttpResponse;

@NotThreadSafe(description="Don't reuse a proxy for requests. Always create a new proxy for a new request.")
public class SlingClientProxy
extends SlingClient
implements Proxy<SlingClient> {
    private AbstractTest test;
    private SlingClient target;
    private Benchmark benchmark;
    private boolean recordResult = true;
    private TestResult<SlingHttpData> testResult;

    public SlingClientProxy(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    @Override
    public void setTest(AbstractTest parent) {
        this.test = parent;
    }

    @Override
    public void setTarget(SlingClient target) {
        this.target = target;
    }

    @Override
    public void setBenchmark(Benchmark benchmark) {
        this.benchmark = benchmark;
    }

    @Override
    public Benchmark benchmark() {
        return this.benchmark;
    }

    private boolean shouldIRecord() {
        boolean tmp = this.recordResult;
        this.recordResult = false;
        return tmp;
    }

    @Override
    public SlingHttpResponse doGet(String requestPath, List<NameValuePair> parameters, List<Header> headers, int ... expectedStatus) throws ClientException {
        boolean recordResultHere = this.shouldIRecord();
        ResultInfo result = this.benchmark().computeTestResult(this.test, testResult -> super.doGet(requestPath, parameters, headers, expectedStatus));
        TestResult<SlingHttpData> currentResult = result.getTestResult();
        SlingHttpResponse response = result.getReturnValue();
        Throwable throwable = result.getThrowable();
        currentResult.withData(this.testResult.getData());
        if (response != null) {
            ((SlingHttpData)currentResult.getData()).withBytes(response.getContent().length());
        }
        if (recordResultHere) {
            this.doRecord(currentResult);
        } else {
            this.testResult = currentResult;
        }
        this.doThrow(throwable);
        return response;
    }

    @Override
    public SlingHttpResponse doRequest(HttpUriRequest request, List<Header> headers, int ... expectedStatus) throws ClientException {
        boolean recordResultHere = this.shouldIRecord();
        ResultInfo result = this.benchmark().computeTestResult(this.test, testResult -> super.doRequest(request, headers, expectedStatus));
        TestResult<SlingHttpData> currentResult = result.getTestResult();
        SlingHttpResponse response = result.getReturnValue();
        Throwable throwable = result.getThrowable();
        currentResult.withData(this.testResult.getData());
        if (response != null) {
            ((SlingHttpData)currentResult.getData()).withBytes(response.getContent().length());
        }
        if (recordResultHere) {
            this.doRecord(this.testResult);
        } else {
            this.testResult = currentResult;
        }
        this.doThrow(throwable);
        return response;
    }

    @Override
    public SlingHttpResponse doRawRequest(String method, String uri, List<Header> headers, int ... expectedStatus) throws ClientException {
        boolean recordResultHere = this.shouldIRecord();
        ResultInfo result = this.benchmark().computeTestResult(this.test, testResult -> {
            SlingHttpData data = testResult.getData() != null ? (SlingHttpData)testResult.getData() : new SlingHttpData();
            SlingHttpResponse response = this.target.doRawRequest(method, uri, headers, expectedStatus);
            Header contentLengthHeader = response.getFirstHeader("Content-Length");
            long bytes = contentLengthHeader != null ? Long.parseLong(contentLengthHeader.getValue()) : response.getEntity().getContentLength();
            ((SlingHttpData)((SlingHttpData)((SlingHttpData)((SlingHttpData)data.withMethod(method)).withUrl(uri)).withResponseCode(response.getStatusLine().getStatusCode())).withUser(this.target.getUser())).withBytes(bytes);
            testResult.withData(data);
            return response;
        });
        TestResult<SlingHttpData> currentResult = result.getTestResult();
        SlingHttpResponse response = result.getReturnValue();
        Throwable throwable = result.getThrowable();
        if (response != null) {
            ((SlingHttpData)currentResult.getData()).withLatency(currentResult.getDuration());
        }
        if (recordResultHere) {
            this.doRecord(currentResult);
        } else {
            this.testResult = currentResult;
        }
        this.doThrow(throwable);
        return response;
    }

    @Override
    public SlingHttpResponse doStreamRequest(HttpUriRequest request, List<Header> headers, int ... expectedStatus) throws ClientException {
        boolean recordResultHere = this.shouldIRecord();
        ResultInfo result = this.benchmark().computeTestResult(this.test, testResult -> {
            SlingHttpData data = testResult.getData() != null ? (SlingHttpData)testResult.getData() : new SlingHttpData();
            SlingHttpResponse response = this.target.doStreamRequest(request, headers, expectedStatus);
            Header contentLengthHeader = response.getFirstHeader("Content-Length");
            long bytes = contentLengthHeader != null ? Long.parseLong(contentLengthHeader.getValue()) : response.getEntity().getContentLength();
            ((SlingHttpData)((SlingHttpData)((SlingHttpData)((SlingHttpData)((SlingHttpData)data.withMethod(request.getMethod())).withUrl(request.getURI().toString())).withResponseCode(response.getStatusLine().getStatusCode())).withQuery(this.getQueryString(request))).withUser(this.target.getUser())).withBytes(bytes);
            testResult.withData(data);
            return response;
        });
        TestResult<SlingHttpData> currentResult = result.getTestResult();
        SlingHttpResponse response = result.getReturnValue();
        Throwable throwable = result.getThrowable();
        if (response != null) {
            ((SlingHttpData)currentResult.getData()).withLatency(currentResult.getDuration());
        }
        if (recordResultHere) {
            this.doRecord(currentResult);
        } else {
            this.testResult = currentResult;
        }
        this.doThrow(throwable);
        return response;
    }

    private List<Map<String, String>> getQueryString(HttpUriRequest request) {
        HttpEntityEnclosingRequestBase httpRequest;
        if (request instanceof HttpEntityEnclosingRequestBase && (httpRequest = (HttpEntityEnclosingRequestBase)request).getEntity() instanceof UrlEncodedFormEntity) {
            UrlEncodedFormEntity urlEncodedFormEntity = (UrlEncodedFormEntity)httpRequest.getEntity();
            try {
                ArrayList<Map<String, String>> query = new ArrayList<Map<String, String>>();
                for (NameValuePair nameValuePair : URLEncodedUtils.parse(urlEncodedFormEntity)) {
                    query.add(Collections.singletonMap(nameValuePair.getName(), nameValuePair.getValue()));
                }
                return query;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private void doRecord(TestResult<SlingHttpData> currentTestResult) {
        this.benchmark().getRunMap().record(currentTestResult);
        this.recordResult = true;
        this.testResult = null;
    }

    private void doThrow(Throwable throwable) throws ClientException {
        if (throwable != null) {
            if (throwable instanceof ClientException) {
                throw (ClientException)throwable;
            }
            throw new ClientException(throwable.getMessage(), throwable);
        }
    }
}

