/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.tests.utils;

import com.adobe.qe.toughday.api.core.AbstractTest;
import com.adobe.qe.toughday.api.core.benchmark.Benchmark;
import com.adobe.qe.toughday.api.core.benchmark.ProxyFactory;
import com.adobe.qe.toughday.api.core.benchmark.ProxyHelpers;
import com.adobe.qe.toughday.tests.utils.SlingClientProxy;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class SlingClientsProxyFactory
implements ProxyFactory<SlingClient> {
    @Override
    public SlingClient createProxy(SlingClient target, AbstractTest test, Benchmark benchmark) {
        try {
            SlingClient slingClientProxy = Mockito.spy(target);
            SlingClientProxy proxy = target.adaptTo(SlingClientProxy.class);
            proxy.setTest(test);
            proxy.setTarget(target);
            proxy.setBenchmark(benchmark);
            Mockito.doAnswer(this.doStreamRequestAnswer(proxy)).when(slingClientProxy).doStreamRequest((HttpUriRequest)Mockito.any(), (List)Mockito.any(), (int[])Mockito.any());
            Mockito.doAnswer(this.doRawRequestAnswer(proxy)).when(slingClientProxy).doRawRequest((String)Mockito.any(), (String)Mockito.any(), (List)Mockito.any(), (int[])Mockito.any());
            Mockito.doAnswer(this.doRequestAnswer(proxy)).when(slingClientProxy).doRequest((HttpUriRequest)Mockito.any(), (List)Mockito.any(), (int[])Mockito.any());
            Mockito.doAnswer(this.doGetAnswer(proxy)).when(slingClientProxy).doGet((String)Mockito.any(), (List<NameValuePair>)((List)Mockito.any()), (List)Mockito.any(), (int[])Mockito.any());
            return slingClientProxy;
        }
        catch (ClientException e) {
            return target;
        }
    }

    private Answer<SlingHttpResponse> doStreamRequestAnswer(SlingClientProxy proxy) {
        return invocation -> {
            Object[] arguments = ProxyHelpers.canonicArguments(invocation.getMethod(), invocation.getArguments());
            return proxy.doStreamRequest((HttpUriRequest)arguments[0], (List)arguments[1], (int[])arguments[2]);
        };
    }

    private Answer<SlingHttpResponse> doRawRequestAnswer(SlingClientProxy proxy) {
        return invocation -> {
            Object[] arguments = ProxyHelpers.canonicArguments(invocation.getMethod(), invocation.getArguments());
            return proxy.doRawRequest((String)arguments[0], (String)arguments[1], (List)arguments[2], (int[])arguments[3]);
        };
    }

    private Answer<SlingHttpResponse> doRequestAnswer(SlingClientProxy proxy) {
        return invocation -> {
            Object[] arguments = ProxyHelpers.canonicArguments(invocation.getMethod(), invocation.getArguments());
            return proxy.doRequest((HttpUriRequest)arguments[0], (List)arguments[1], (int[])arguments[2]);
        };
    }

    private Answer<SlingHttpResponse> doGetAnswer(SlingClient proxy) {
        return invocation -> {
            Object[] arguments = ProxyHelpers.canonicArguments(invocation.getMethod(), invocation.getArguments());
            return proxy.doGet((String)arguments[0], (List<NameValuePair>)((List)arguments[1]), (List)arguments[2], (int[])arguments[3]);
        };
    }
}

