/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.tests.utils;

import java.util.concurrent.Phaser;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;

public class TreePhaser
extends Phaser {
    public Thread mon;
    private int base = Integer.parseInt("10");
    public static final String DEFAULT_BASE = "10";
    public final AtomicInteger nextChildPerLevel = new AtomicInteger(0);
    private int maxChildrenPerLevel = this.base;

    public TreePhaser() {
        this.monitor();
    }

    @Override
    protected boolean onAdvance(int phase, int registeredParties) {
        this.nextChildPerLevel.set(0);
        this.maxChildrenPerLevel *= this.base;
        return false;
    }

    public int getNextNode() {
        int childNumber = this.nextChildPerLevel.getAndIncrement();
        if (childNumber >= this.maxChildrenPerLevel) {
            this.arriveAndAwaitAdvance();
            return this.getNextNode();
        }
        return childNumber;
    }

    public int getLevel() {
        return this.getPhase() + 1;
    }

    public void monitor() {
        this.mon = new Thread(){

            @Override
            public void run() {
                while (true) {
                    if (TreePhaser.this.nextChildPerLevel.get() >= TreePhaser.this.maxChildrenPerLevel) {
                        TreePhaser.this.arriveAndAwaitAdvance();
                        continue;
                    }
                    try {
                        1.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        };
        this.register();
        this.mon.start();
    }

    public void setBase(int base) {
        this.maxChildrenPerLevel = base;
        this.base = base;
    }

    public int getBase() {
        return this.base;
    }

    public static String computeParentPath(int nextChild, int level, int base, String title, String prefix) {
        prefix = null != prefix ? prefix : "/";
        String string = prefix = prefix.endsWith("/") ? prefix : prefix + "/";
        if (level == 1) {
            return prefix;
        }
        String path = Integer.toString(nextChild / base, base);
        path = StringUtils.leftPad(path, level - 1, "0");
        path = StringUtils.stripStart(path.replace("", "/" + title), "/");
        path = prefix + StringUtils.stripEnd(path, title);
        return path;
    }

    public static String computeParentPath(int nextChild, int level, int base, String title) {
        return TreePhaser.computeParentPath(nextChild, level, base, title, "/");
    }

    public static String computeNodeName(int nextChild, int base, String title) {
        return title + Integer.toString(nextChild % base, base);
    }
}

