/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.qe.toughday.tests.utils;

import com.adobe.qe.toughday.api.core.AbstractTest;
import org.apache.http.HttpEntity;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;

public class WcmUtils {
    public static final String CMD_CREATE_PAGE = "createPage";
    public static final String CMD_CREATE_LIVECOPY = "createLiveCopy";
    public static final String CMD_ROLLOUT = "rollout";
    public static final String DEFAULT_PARENT_PATH = "/content/toughday";
    public static final String DEFAULT_TEMPLATE = "/conf/toughday-templates/settings/wcm/templates/toughday-template";

    public static SlingHttpResponse createPage(SlingClient client, String parentPath, String title, String template, int ... expectedStatus) throws ClientException {
        FormEntityBuilder feb = FormEntityBuilder.create().addParameter("cmd", CMD_CREATE_PAGE).addParameter("parentPath", parentPath).addParameter("title", title).addParameter("template", template);
        return client.doPost("/bin/wcmcommand", (HttpEntity)feb.build(), expectedStatus);
    }

    public static SlingHttpResponse createLiveCopy(AbstractTest test, SlingClient client, String label, String title, String destPath, String srcPath, boolean shallow, String[] rolloutConfigs, String[] missingPages, boolean excludeSubPages, int ... expectedStatus) throws Throwable {
        FormEntityBuilder feb = FormEntityBuilder.create().addParameter("cmd", CMD_CREATE_LIVECOPY).addParameter("title", title).addParameter("label", label).addParameter("destPath", destPath).addParameter("srcPath", srcPath).addParameter("missingPage@Delete", "true");
        WcmUtils.fillParameters(feb, "missingPage", missingPages);
        feb.addParameter("excludeSubPages@Delete", "true");
        feb.addParameter("excludeSubPages", Boolean.valueOf(excludeSubPages).toString());
        feb.addParameter("shallow@Delete", "true");
        feb.addParameter("shallow", Boolean.valueOf(shallow).toString());
        feb.addParameter("cq:rolloutConfigs@Delete", "true");
        WcmUtils.fillParameters(feb, "cq:rolloutConfigs", rolloutConfigs);
        return test.benchmark().measure(test, "CreateLiveCopy", client).doPost("/bin/wcmcommand", (HttpEntity)feb.build(), expectedStatus);
    }

    private static void fillParameters(FormEntityBuilder formEntityBuilder, String paramName, String ... values) {
        if (values != null && values.length > 0) {
            for (String value : values) {
                formEntityBuilder.addParameter(paramName, value);
            }
        }
    }

    public static SlingHttpResponse rolloutPage(SlingClient client, String type, boolean background, String[] sourcePaths, String[] paragraphPaths, String[] targetPaths, int ... expectedStatus) throws ClientException {
        FormEntityBuilder feb = FormEntityBuilder.create().addParameter("cmd", CMD_ROLLOUT).addParameter("type", type).addParameter("sling:bg", Boolean.valueOf(background).toString()).addParameter("msm:async", Boolean.valueOf(background).toString());
        WcmUtils.fillParameters(feb, "path", sourcePaths);
        WcmUtils.fillParameters(feb, "paras", paragraphPaths);
        WcmUtils.fillParameters(feb, "msm:targetPath", targetPaths);
        return client.doPost("/bin/wcmcommand", (HttpEntity)feb.build(), expectedStatus);
    }
}

