/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.hapi.client.forms.internal;

import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.sling.hapi.client.forms.internal.Vals;
import org.jsoup.nodes.Element;

public class FormValues {
    private Element form;
    private Iterable<NameValuePair> values;
    private Vals list = new Vals();

    public FormValues(Element form, Iterable<NameValuePair> values) {
        this.form = form;
        this.values = values;
        this.build();
        this.resolve();
    }

    private FormValues build() {
        for (Element input : this.form.select("button, input, select, textarea")) {
            String type = input.attr("type");
            if (input.hasAttr("disabled") || input.tagName().equalsIgnoreCase("button") && !type.equals("submit") || input.tagName().equalsIgnoreCase("input") && (type.equals("button") || type.equals("reset")) || type.equals("checkbox") && input.hasAttr("checked") || type.equals("radio") && input.hasAttr("checked") || !type.equals("image") && input.attr("name").length() == 0 || input.parents().is("datalist") || type.equals("image") || type.equals("file")) continue;
            String name = input.attr("name");
            if (input.tagName().equalsIgnoreCase("select")) {
                for (Element o : input.select("option[selected]")) {
                    if (o.hasAttr("disabled")) continue;
                    this.list.add(name, new BasicNameValuePair(name, o.val()));
                }
                continue;
            }
            if (type.equals("checkbox") || type.equals("radio")) {
                String value = input.hasAttr("value") ? input.val() : "on";
                this.list.add(name, new BasicNameValuePair(name, value));
                continue;
            }
            this.list.add(name, new BasicNameValuePair(name, input.val()));
        }
        return this;
    }

    private FormValues resolve() {
        for (NameValuePair o : this.values) {
            if (this.list.has(o.getName())) {
                this.list.set(o);
                continue;
            }
            this.list.set(o);
        }
        return this;
    }

    public String toString() {
        return URLEncodedUtils.format(this.list.flatten(), "UTF-8");
    }

    public HttpEntity toUrlEncodedEntity() {
        try {
            return new UrlEncodedFormEntity(this.list.flatten(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public HttpEntity toMultipartEntity() {
        MultipartEntityBuilder eb = MultipartEntityBuilder.create();
        for (NameValuePair nameValuePair : this.list.flatten()) {
            eb.addTextBody(nameValuePair.getName(), nameValuePair.getValue());
        }
        return eb.build();
    }
}

