/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.email;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.email.EmailMessage;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public final class SlingEmailClient
extends SlingClient {
    private static final String EMAIL_SERVLET_PATH = "/system/sling/testing/email";
    private static final String PN_CONTENT = "-Content-";
    private final ObjectMapper mapper = new ObjectMapper();

    public SlingEmailClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    public int getBindPort() throws ClientException {
        try {
            SlingHttpResponse mockEmailConfig = this.doGet("/system/sling/testing/email/config", 200);
            JsonNode configNode = this.mapper.readTree(mockEmailConfig.getContent());
            return configNode.get("bindPort").getIntValue();
        }
        catch (IOException e) {
            throw new ClientException("Failed retrieving configuration", e);
        }
    }

    public List<EmailMessage> getMessages() throws ClientException {
        ArrayList<EmailMessage> emails = new ArrayList<EmailMessage>();
        try {
            SlingHttpResponse response = this.doGet("/system/sling/testing/email/messages", 200);
            JsonNode messages = this.mapper.readTree(response.getContent());
            for (JsonNode emailNode : messages.get("messages")) {
                EmailMessage msg = new EmailMessage(emailNode.get(PN_CONTENT).getTextValue());
                Iterator<String> fieldNames = emailNode.getFieldNames();
                while (fieldNames.hasNext()) {
                    String fieldName = fieldNames.next();
                    if (fieldName.equals(PN_CONTENT)) continue;
                    msg.addHeader(fieldName, emailNode.get(fieldName).getTextValue());
                }
                emails.add(msg);
            }
        }
        catch (IOException e) {
            throw new ClientException("Failed retrieving email messages", e);
        }
        return emails;
    }

    public void deleteMessages() throws ClientException {
        this.doDelete(EMAIL_SERVLET_PATH, Collections.emptyList(), Collections.emptyList(), 204);
    }
}

