/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.html;

import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.sling.hapi.client.HtmlClient;
import org.apache.sling.hapi.client.impl.microdata.MicrodataDocument;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicrodataClient
extends SlingClient
implements HtmlClient {
    protected static final Logger LOG = LoggerFactory.getLogger(MicrodataClient.class);

    public MicrodataClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    public MicrodataClient(URI url, String user, String password) throws ClientException {
        super(url, user, password);
    }

    public MicrodataDocument enter(String url) throws org.apache.sling.hapi.client.ClientException {
        return this.get(url);
    }

    public MicrodataDocument get(String url) throws org.apache.sling.hapi.client.ClientException {
        try {
            return this.newDocument(this.doGet(url, new int[0]).getContent());
        }
        catch (ClientException e) {
            throw new org.apache.sling.hapi.client.ClientException("Cannot create Microdata document", e);
        }
    }

    public MicrodataDocument post(String url, HttpEntity entity) throws org.apache.sling.hapi.client.ClientException {
        try {
            return this.newDocument(this.doPost(url, entity, new int[0]).getContent());
        }
        catch (ClientException e) {
            throw new org.apache.sling.hapi.client.ClientException("Cannot create Microdata document", e);
        }
    }

    public MicrodataDocument delete(String url) throws org.apache.sling.hapi.client.ClientException {
        try {
            return this.newDocument(this.doDelete(url, null, null, new int[0]).getContent());
        }
        catch (ClientException e) {
            throw new org.apache.sling.hapi.client.ClientException("Cannot create Microdata document", e);
        }
    }

    public MicrodataDocument newDocument(String html) {
        return new MicrodataDocument(html, this, this.getUrl().toString());
    }
}

