/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.interceptors;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;

public class DelayRequestInterceptor
implements HttpRequestInterceptor {
    private final long milliseconds;

    public DelayRequestInterceptor(long milliseconds) {
        this.milliseconds = milliseconds;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (this.milliseconds <= 0L) {
            return;
        }
        try {
            Thread.sleep(this.milliseconds);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
    }
}

